@extends('layouts.appp')

@section('title')
    Listes des langues locales
@endsection

@section('titre')
    Listes des langues locales
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Paramétrage de base</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Listes des langues locales</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Listes des langues locales</h4>
                    </div>
                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM"))
                    <div class="card-body">                       
                        <form action="{{ route('admin.save.languelocale') }}" method="POST" class="mb-10">
                            @csrf
                            <div class="row">
                                <div class="col-md-8">
                                    <label>Libellé de la langue locale <span class="text-danger">*</span></label>
                                    <input type="text" name="libelle" value="" class="form-control" placeholder="Entrer le libellé de la langue locale" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Ajouter la langue locale</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Libellé</th>
                                        <th>Date création</th>
                                        <th>Statut</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($languelocales as $languelocale)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>{{ $languelocale->languelocal_lib }}</td>
                                            <td>{{ \Carbon\Carbon::parse($languelocale->languelocal_datecrea)->format('d/m/Y') }}</td>
                                            <td>
                                                @if($languelocale->languelocal_statut == "VALIDE")
                                                    <a href="{{ route('admin.desactiver.languelocale',$languelocale->languelocal_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                @else
                                                    <a href="{{ route('admin.activer.languelocale',$languelocale->languelocal_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                @endif
                                            </td>
                                            <td class="text-center"> 
                                                <span  data-toggle="modal" data-target="#ModifierSecteurActivite{{ $languelocale->languelocal_id }}" style="cursor:pointer" title="MODIFIER LANGUE LOCALE"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></span>
                                                <span data-toggle="modal" data-target="#supprimerlanguelocale{{$languelocale->languelocal_id}}" title="SUPPRIMER LANGUE LOCALE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="ModifierSecteurActivite{{ $languelocale->languelocal_id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Modifier : {{ $languelocale->languelocal_lib }}</h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="POST" action="{{ route('admin.modifier.languelocale',$languelocale->languelocal_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Libelle <span class="text-danger">*</span></label>
                                                            <input type="text" name="libelle" placeholder="Entrer le libellé de la langue locale" class="form-control" required value="{{ $languelocale->languelocal_lib }}">
                                                            <br>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Enregistrer</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="modal fade" id="supprimerlanguelocale{{$languelocale->languelocal_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer la langue internationale : {{ $languelocale->languelocal_lib }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.languelocale',$languelocale->languelocal_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection