@extends('layouts.appp')

@section('title')
    Listes des nationalités des entreprises
@endsection

@section('titre')
    Listes des nationalités des entreprises
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Paramétrage de base</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Listes des nationalités des entreprises</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Listes des nationalités des entreprises</h4>
                    </div>
                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM"))
                    <div class="card-body">                       
                        <form action="{{ route('admin.save.nationaliteentreprise') }}" method="POST" class="mb-10">
                            @csrf
                            <div class="row">
                                <div class="col-md-8">
                                    <label>Libellé de la nationalité entreprise <span class="text-danger">*</span></label>
                                    <input type="text" name="libelle" value="" class="form-control" placeholder="Entrer le libellé de la nationalité entreprise" required>
                                </div>
                                <div class="col-md-4">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Ajouter une nationalité entreprise</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Libellé</th>
                                        <th>Date création</th>
                                        <th>Statut</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($nationaliteentreprises as $nationaliteentreprise)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>{{ $nationaliteentreprise->nationalite_lib }}</td>
                                            <td>{{ \Carbon\Carbon::parse($nationaliteentreprise->nationalite_datecrea)->format('d/m/Y') }}</td>
                                            <td>
                                                @if($nationaliteentreprise->nationalite_statut == "VALIDE")
                                                    <a href="{{ route('admin.desactiver.nationaliteentreprise',$nationaliteentreprise->nationalite_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                @else
                                                    <a href="{{ route('admin.activer.nationaliteentreprise',$nationaliteentreprise->nationalite_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                @endif
                                            </td>
                                            <td class="text-center"> 
                                                <span  data-toggle="modal" data-target="#ModifierNationaliteEntreprise{{ $nationaliteentreprise->nationalite_id }}" style="cursor:pointer" title="MODIFIER LA NATIONALITE ENTREPRISE"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></span>
                                                <span data-toggle="modal" data-target="#supprimernationaliteentreprise{{$nationaliteentreprise->nationalite_id}}" title="SUPPRIMER LA NATIONALITE ENTREPRISE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="ModifierNationaliteEntreprise{{ $nationaliteentreprise->nationalite_id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Modifier : {{ $nationaliteentreprise->nationalite_lib }}</h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="POST" action="{{ route('admin.modifier.nationaliteentreprise',$nationaliteentreprise->nationalite_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Libelle <span class="text-danger">*</span></label>
                                                            <input type="text" name="libelle" placeholder="Entrer le libellé de la nationalité entreprise" class="form-control" required value="{{ $nationaliteentreprise->nationalite_lib }}">
                                                            <br>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Enregistrer</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="modal fade" id="supprimernationaliteentreprise{{$nationaliteentreprise->nationalite_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer la nationalité entreprise : {{ $nationaliteentreprise->nationalite_lib }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.nationaliteentreprise',$nationaliteentreprise->nationalite_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection