@extends('layouts.appp')

@section('title')
    Listes des régions
@endsection

@section('titre')
    Listes des régions
@endsection

@section('content')
    <style>
        .theme-bg-light {
          background: rgba(40, 182, 97,0.11) !important;
        }

        .bg-light-danger {
          background-color: #ffeced;
        }

        .bg-light-warning {
          background-color: #fff8ec;
        }

        .bg-light-info {
          background-color: #cfecfe;
        }

        .bg-light-purple {
          background-color: rgb(238, 235, 255);
        }

        .theme-cl {
          color: #28b661 !important;
        }

        .text-warning {
          color: #ff9b20 !important;
        }

        .text-info {
          color: #2196f3 !important;
        }

        .text-purple {
          color: rgb(116, 96, 238);
        }

        .text-danger {
          color: #ea2b33 !important;
        }
    </style>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Paramétrage de base</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Listes des régions</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Listes des régions</h4>
                    </div>
                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PARAM"))
                    <div class="card-body">                       
                        <form action="{{ route('admin.save.region') }}" method="POST" class="mb-10">
                            @csrf
                            <div class="row">
                                <div class="col-md-4">
                                    <label>Libellé de la région <span class="text-danger">*</span></label>
                                    <input type="text" name="libelle" value="{{ old('libelle') }}" class="form-control" placeholder="Entrer le libellé de la region" required>
                                </div>
                                <div class="col-md-4">
                                    <label>Couleur de fond <span class="text-danger">*</span></label>
                                    <select class="form-control" name="couleur" required>
                                        <option value="">Choisir une couleur</option>
                                        <option value="text-info bg-light-info" {{ old('couleur') == 'text-info bg-light-info' ? 'selected' : '' }}>Bleu</option>
                                        <option value="text-warning bg-light-warning" {{ old('couleur') == 'text-warning bg-light-warning' ? 'selected' : '' }}>Orange</option>
                                        <option value="text-danger bg-light-danger" {{ old('couleur') == 'text-danger bg-light-danger' ? 'selected' : '' }}>Rouge</option>
                                        <option value="theme-cl theme-bg-light" {{ old('couleur') == 'theme-cl theme-bg-light' ? 'selected' : '' }}>Vert</option>
                                        <option value="text-purple bg-light-purple" {{ old('couleur') == 'text-purple bg-light-purple' ? 'selected' : '' }}>Violet</option>
                                    </select>
                                </div>
                                <div class="col-md-4">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Ajouter la région</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Libellé</th>
                                        <th class="text-center">Couleur de fond</th>
                                        <th>Date création</th>
                                        <th>Statut</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($regions as $region)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>{{ $region->region_nom }}</td>
                                            <td class="text-center">
                                                @if($region->region_couleur == "theme-cl theme-bg-light")
                                                    <span class="theme-cl theme-bg-light">Vert</span>
                                                @elseif($region->region_couleur == "text-warning bg-light-warning")
                                                    <span class="text-warning bg-light-warning">Orange</span>
                                                @elseif($region->region_couleur == "text-danger bg-light-danger")
                                                    <span class="text-danger bg-light-danger">Rouge</span>
                                                @elseif($region->region_couleur == "text-info bg-light-info")
                                                    <span class="text-info bg-light-info">Bleu</span>
                                                @elseif($region->region_couleur == "text-purple bg-light-purple")
                                                    <span class="text-purple bg-light-purple">Violet</span>
                                                @endif
                                            </td>
                                            <td>{{ \Carbon\Carbon::parse($region->region_datecrea)->format('d/m/Y') }}</td>
                                            <td>
                                                @if($region->region_statut == "VALIDE")
                                                    <a href="{{ route('admin.desactiver.region',$region->region_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                @else
                                                    <a href="{{ route('admin.activer.region',$region->region_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                @endif
                                            </td>
                                            <td class="text-center"> 
                                                <span data-toggle="modal" data-target="#ModifierRegion{{ $region->region_id }}" style="cursor:pointer" title="MODIFIER LA REGION"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></span>
                                                <span data-toggle="modal" data-target="#supprimerregion{{$region->region_id}}" title="SUPPRIMER LA REGION"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="ModifierRegion{{ $region->region_id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Modifier : {{ $region->region_nom }}</h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="POST" action="{{ route('admin.modifier.region',$region->region_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Libelle <span class="text-danger">*</span></label>
                                                            <input type="text" name="libelle" placeholder="Entrer le libellé de la nationalité entreprise" class="form-control" required value="{{ $region->region_nom }}">
                                                            <br>
                                                            <label>Couleur de fond <span class="text-danger">*</span></label>
                                                            <select class="form-control" name="couleur" required>
                                                                <option value="">Choisir une couleur</option>
                                                                <option @if($region->region_couleur == "text-info bg-light-info") selected @endif value="text-info bg-light-info" {{ old('couleur') == 'text-info bg-light-info' ? 'selected' : '' }}>Bleu</option>
                                                                <option @if($region->region_couleur == "text-warning bg-light-warning") selected @endif value="text-warning bg-light-warning" {{ old('couleur') == 'text-warning bg-light-warning' ? 'selected' : '' }}>Orrange</option>
                                                                <option @if($region->region_couleur == "text-danger bg-light-danger") selected @endif value="text-danger bg-light-danger" {{ old('couleur') == 'text-danger bg-light-danger' ? 'selected' : '' }}>Rouge</option>
                                                                <option @if($region->region_couleur == "theme-cl theme-bg-light") selected @endif value="theme-cl theme-bg-light" {{ old('couleur') == 'theme-cl theme-bg-light' ? 'selected' : '' }}>Vert</option>
                                                                <option @if($region->region_couleur == "text-purple bg-light-purple") selected @endif value="text-purple bg-light-purple" {{ old('couleur') == 'text-purple bg-light-purple' ? 'selected' : '' }}>Violet</option>
                                                            </select>
                                                            <br>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Enregistrer</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="modal fade" id="supprimerregion{{$region->region_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer la région : {{ $region->region_nom }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.region',$region->region_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
@endsection