@extends('layouts.appp')

@section('title')
    Listes des fichiers publiés
@endsection

@section('titre')
    Listes des fichiers publiés
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Publication de fichiers</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Listes des fichiers publiés</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Listes des fichiers publiés</h4>
                        <div class="float-end">
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PUB_FICH"))
                                <span class="btn btn-primary" data-toggle="modal" data-target="#TelechagerFichier"><i class="fa fa-file-pdf-o"></i> Nouveau fichier</span>
                            @endif
                        </div>
                    </div>
                    @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_FICH"))
                    <div class="card-body">                       
                        <form action="{{ route('admin.liste.publication') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-4">
                                    <input type="text" name="l" value="{{ $selected_libelle }}" class="form-control" placeholder="Entrer le libellé">
                                </div>
                                <div class="col-md-4">
                                    <input type="date" name="d" value="{{ $selected_date }}" class="form-control">
                                </div>
                                <div class="col-md-2">
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                                <div class="col-md-2">
                                    <a href="{{ route('admin.liste.publication') }}" class="btn btn-warning btn-block">Réinitialiser</a>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Fichier</th>
                                        <th>Titre</th>
                                        <th>Date</th>
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_FICH") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_FICH"))
                                        <th>Statut</th>
                                        @endif
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($publications as $publication)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>
                                                @if($publication->publication_extension == "pdf")
                                                    <div><img src="{{ asset('assets/img/pdf-icon.png') }}" class="img-fluid" width="35" alt=""></div>
                                                @elseif($publication->publication_extension == "xlsx")
                                                    <div><img src="{{ asset('assets/img/excel-icon.png') }}" class="img-fluid" width="35" alt=""></div>
                                                @elseif($publication->publication_extension == "docx")
                                                    <div><img src="{{ asset('assets/img/word-icon.png') }}" class="img-fluid" width="35" alt=""></div>
                                                @endif
                                            </td>
                                            <td><?php echo html_entity_decode($publication->publication_libelle) ?></td>
                                            <td>{{ \Carbon\Carbon::parse($publication->publication_datecreation)->format('d/m/Y') }}</td>
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_FICH") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_FICH"))
                                            <td>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    @if($publication->publication_statut == "VALIDE")
                                                        <a href="{{ route('admin.desactiver.publication',$publication->publication_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                    @else
                                                        <a href="{{ route('admin.activer.publication',$publication->publication_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                    @endif
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_FICH"))
                                                    @if($publication->publication_statut == "VALIDE")
                                                        <a href="{{ route('admin.desactiver.publication',$publication->publication_id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                    @else
                                                        <span class="badge badge-warning">Non actif</span>
                                                    @endif
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_FICH"))
                                                    @if($publication->publication_statut == "BROUILLON")
                                                        <a href="{{ route('admin.activer.publication',$publication->publication_id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                    @else
                                                        <span class="badge badge-success">Actif</span>
                                                    @endif
                                                @endif
                                            </td>
                                            @endif
                                            <td class="text-center"> 
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_FICH"))
                                                    <a href="{{ asset('assets/fichiers/'.$publication->publication_fichier) }}" style="cursor: pointer;" target="_blank"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-fluid" width="25" alt=""></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "PUB_FICH"))
                                                    <span  data-toggle="modal" data-target="#ModifierFichier{{ $publication->publication_id }}" style="cursor:pointer" title="MODIFIER LE FICHIER"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></span>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_FICH"))
                                                    <span data-toggle="modal" data-target="#supprimerfichier{{$publication->publication_id}}" title="SUPPRIMER LE FICHIER"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></span>                                               
                                                @endif
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="ModifierFichier{{ $publication->publication_id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Modifier le fichier</h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="POST" action="{{ route('admin.modifier.publication',$publication->publication_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Libelle <span class="text-danger">*</span></label>
                                                            <input type="text" name="libelle" class="form-control" required value="<?php echo html_entity_decode($publication->publication_libelle) ?>">
                                                            <br>
                                                            <label>Joindre le fichier <small> (fichier autorisé : pdf, docx ou excel)</small></label>
                                                            <input type="file" name="file" class="form-control" value="{{ $publication->publication_fichier }}">
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Enregistrer</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="modal fade" id="supprimerfichier{{$publication->publication_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer le fichier : <?php echo html_entity_decode($publication->publication_libelle) ?>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.publication',$publication->publication_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="TelechagerFichier">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Publier un nouveau fichier</h5>
                    <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                    </button>
                </div>
                <form method="POST" action="{{ route('admin.save.publication') }}" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <label>Libelle <span class="text-danger">*</span></label>
                        <input type="text" name="libelle" class="form-control" required>
                        <br>
                        <label>Joindre le fichier <span class="text-danger">*</span><small> (fichier autorisé : pdf, docx ou excel)</small></label>
                        <input type="file" name="file" class="form-control" required>
                    </div>
                    <div class="modal-footer">
                        <button type="submit" class="btn btn-info">Enregistrer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection