<?php
    use Carbon\Carbon;
?>
@extends('layouts.appp')

@section('title')
    Statistiques journalières
@endsection

@section('titre')
    Statistiques journalières
@endsection

@section('content')
<style>
    .employeur{
        background-color: blue; !important;
    }
</style>
    <script src="{{ asset('js/chart.js') }}"></script>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Statistiques</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Statistiques journalières</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Suivi des comptes du :
                            @php
                                
                                $date_jours = $datejour;

                                $date = Carbon::parse($date_jours)->locale('fr_FR')->translatedFormat('d F Y');

                                echo $date;
                            @endphp
                        </h4>
                        <div class="float-end">
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START"))                                                           
                                @if($employeurCount > 0)
                                    <a class="badge badge-primary employeur" href="{{ route('admin.excel-statistiques.journalieres-emp') }}">Employeurs</a>
                                @endif
                                @if($demandeurCount > 0)
                                    <a class="badge badge-success" href="{{ route('admin.excel-statistiques.journalieres-demp') }}">Demandeurs d'emploi</a> 
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <canvas id="inscriptions-du-jour"></canvas>
                    </div>
                </div><br>
            </div>
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Suivi des offres d'emploi du : 
                            @php
                                
                                $date_jours = $datejour;

                                $date = Carbon::parse($date_jours)->locale('fr_FR')->translatedFormat('d F Y');

                                echo $date;
                            @endphp
                        </h4>
                        <div class="float-end">                            
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")) 
                                @if($offrepublier > 0)                                                          
                                    <a class="badge badge-success" href="{{ route('admin.excel-statistiques.journalieres-offrepub') }}">Offres publiées</a>
                                @endif
                                
                                @if($offrebrouillon > 0)
                                    <a class="badge badge-primary employeur" href="{{ route('admin.excel-statistiques.journalieres-offrebroui') }}">Offres brouillons</a> 
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <canvas id="chart_offre"></canvas>
                    </div>
                </div><br>
            </div> 
        </div>
    </div>
    <script>
        var employeurCount = {!! $employeurCount !!};
        var demandeurCount = {!! $demandeurCount !!};

        var data = {
            labels: ['Employeurs', 'Demandeurs d\'emploi'],
            datasets: [
                {
                    label: 'Inscriptions du jour',
                    backgroundColor: ['#3490dc', '#38c172'],
                    data: [employeurCount, demandeurCount],
                }
            ]
        };

        var options = {
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true,
                        stepSize: 20
                    }
                }]
            }
        };

        var chart = new Chart('inscriptions-du-jour', {
            type: 'bar',
            data: data,
            options: options
        });
    </script>

    <script>
        var offrepublier = {{ $offrepublier }};
        var offrebrouillon = {{ $offrebrouillon }};

        var ctx = document.getElementById('chart_offre').getContext('2d');

        var chart = new Chart(ctx, {
            type: 'bar',
            data: {
                labels: ['Offre publiée', 'Offre au brouillon'],
                datasets: [{
                    label: 'Publication du jour',
                    data: [offrepublier, offrebrouillon],
                    backgroundColor: ['green', 'blue']
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
@endsection
