<?php
    use Carbon\Carbon;
?>
@extends('layouts.appp')

@section('title')
    Statistiques mensuelles
@endsection

@section('titre')
    Statistiques mensuelles
@endsection

@section('content')
    <script src="{{ asset('js/chart.js') }}"></script>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Statistiques</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Statistiques mensuelles</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Suivi des comptes par mois</h4>
                        <div class="float-end">
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")) 
                                @if($data_employeur > 0 or $data_employeurbroui > 0)                                                          
                                    <a class="badge badge-primary employeur" href="{{ route('admin.excel-statistiques.mensuelles-emp') }}">Employeurs</a>
                                @endif
                                @if($data_users > 0 or $data_user_brouillons > 0)
                                    <a class="badge badge-success" href="{{ route('admin.excel-statistiques.mensuelles-demp') }}">Demandeurs d'emploi</a> 
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="card-body pb-0"> 
                        <canvas id="myChart"></canvas>
                    </div>
                </div><br>
            </div>
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Suivi des offres d'emploi par mois</h4>
                        <div class="float-end">
                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START"))  
                                @if($data_offrespubliees > 0)                                                         
                                    <a class="badge badge-success" href="{{ route('admin.excel-statistiques.mensuelles-offrepub') }}">Offres publiées</a>
                                @endif
                                @if($data_offresbrouillon > 0)
                                    <a class="badge badge-danger" href="{{ route('admin.excel-statistiques.mensuelles-offrebroui') }}">Offres brouillons</a> 
                                @endif
                            @endif
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <canvas id="chart_offre"></canvas>
                    </div>
                </div><br>
            </div>
        </div>
    </div>
    <script>
        var ctx = document.getElementById('myChart').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Janv', 'Févr', 'Mars', 'Avr', 'Mai', 'Juin', 'Juill', 'Août', 'Sept', 'Oct', 'Nov', 'Déc'],
                datasets: [{
                    label: 'Demandeurs d\'emploi traités',
                    data: @json($data_users),
                    fill: false,
                    backgroundColor: 'rgba(1, 153, 0)',
                    borderColor: 'rgba(1, 153, 0)',
                    borderWidth: 1
                }, {
                    label: 'Demandeurs d\'emploi non traités',
                    data: @json($data_user_brouillons),
                    fill: false,
                    backgroundColor: 'rgb(249, 57, 57)',
                    borderColor: 'rgb(249, 57, 57)',
                    borderWidth: 1
                }, {
                    label: 'Employeurs traités',
                    data: @json($data_employeur),
                    fill: false,
                    backgroundColor: '#3d09ff',
                    borderColor: '#3d09ff',
                    borderWidth: 1
                }, {
                    label: 'Employeurs non traités',
                    data: @json($data_employeurbroui),
                    fill: false,
                    backgroundColor: '#630a01',
                    borderColor: '#630a01',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            stepSize: 10
                        }
                    }]
                }
            }
        });
    </script>
    <script>
        var ctx = document.getElementById('chart_offre').getContext('2d');
        var chart_offre = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Janv', 'Févr', 'Mars', 'Avr', 'Mai', 'Juin', 'Juill', 'Août', 'Sept', 'Oct', 'Nov', 'Déc'],
                datasets: [{
                    label: 'Offres publiées',
                    data: @json($data_offrespubliees),
                    fill: false,
                    backgroundColor: 'rgba(1, 153, 0)',
                    borderColor: 'rgba(1, 153, 0)',
                    borderWidth: 1
                }, {
                    label: 'Offres non publiées',
                    data: @json($data_offresbrouillon),
                    fill: false,
                    backgroundColor: 'rgb(249, 57, 57)',
                    borderColor: 'rgb(249, 57, 57)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            stepSize: 10
                        }
                    }]
                }
            }
        });
    </script>
@endsection
