@extends('layouts.appp')

@section('title')
    Détails : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}
@endsection

@section('titre')
    Détails : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}
@endsection

@section('content')
<style>
    .bg-dark{
        background-color: #ccc !important;
        padding: 5px;
        color: #000;
    }
</style>
    <link href="{{ asset('assets/css/icons/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion agents</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.liste.utilisateur') }}">Liste des agents</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header"> 
                    <h4 class="card-title">Détails : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}</h4>
                    <div class="float-end">
                        @if($utilisateur->user_statut == "VALIDE")
                            <img src="{{ asset('assets/img/icons/active.png') }}" width="70">
                        @else
                            <img src="{{ asset('assets/img/icons/desactive.png') }}" width="70">
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <!-- Nav tabs -->
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                            </li>
                            @if($employeurs->count() > 0)
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#employeur"><i class="fa fa-user-md mr-2"></i> Employeurs</a>
                            </li>
                            @endif
                            @if($demandeurs->count() > 0)
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#demandeur"><i class="fa fa-graduation-cap mr-2"></i> Demandeurs</a>
                            </li>
                            @endif
                            @if($offres->count() > 0)
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#offre"><i class="flaticon-381-notepad mr-2"></i> Offres</a>
                            </li>
                            @endif
                            @if($articles->count() > 0)
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#article"><i class="flaticon-381-television mr-2"></i> Articles</a>
                            </li>
                            @endif
                            @if($agents->count() > 0)
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#agent"><i class="fa fa-users mr-2"></i> Agents</a>
                            </li>
                            @endif
                            @if($publications->count() > 0)
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#publication"><i class="fa fa-book mr-2"></i> Fichier</a>
                            </li>
                            @endif
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    <img class="img-fluid" src="" alt="">
                                                                    <img src="{{ asset('assets/img/profil/'.$utilisateur->profil_photo) }}" class="img-fluid" width="300px">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <p class="text-couleur">Nom & Prénoms : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}</p>
                                                                    <p class="text-couleur">Numéro de téléphone : {{ $utilisateur->telephone }}</p>
                                                                    <p class="text-couleur">Adresse Email : <a href="mailto::{{ $utilisateur->email }}" target="_blank">{{ $utilisateur->email }}</a></p>
                                                                    <p class="text-couleur">Fonction : {{ $profil->profil_libelle }}</p>
                                                                    <p class="text-couleur">Type d'agent : {{ $utilisateur->qualite }}</p>
                                                                    <p class="text-couleur">Région : {{ $region->region_nom }}</p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <hr>
                                                            <h3>Actions autorisées</h3>
                                                            <hr>
                                                        </div>
                                                        @foreach($action_autorisees as $action_autorisee)
                                                        <div class="col-md-6 bg-dark">
                                                            @if($action_autorisee->action_autorisee_statut =="VALIDE")
                                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT"))
                                                                    <a href="{{ route('admin.desactiver-action-autorisee',[$utilisateur->id, $action_autorisee->action_autorisee_id]) }}"><img src="{{ asset('assets/img/icons/active-check.png') }}" width="30"></a>{{ $action_autorisee->action_libelle }}<br>
                                                                @endif
                                                            @endif
                                                            @if($action_autorisee->action_autorisee_statut =="SUPPRIME")
                                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT"))
                                                                    <a href="{{ route('admin.activer-action-autorisee',[$utilisateur->id, $action_autorisee->action_autorisee_id]) }}"><img src="{{ asset('assets/img/icons/desactive-check.png') }}" width="30"></a>{{ $action_autorisee->action_libelle }}<br>
                                                                @endif
                                                            @endif
                                                        </div>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="employeur">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>Raison sociale</th>
                                                    <th>Interlocuteur</th>
                                                    <th>Contact</th>
                                                    <th>Valider le</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($employeurs as $employeur)
                                                    <tr>
                                                        <td>
                                                            <img src="{{ asset('assets/img/entreprise/'.$employeur->entreprise_logo) }}" class="img-fluid" width="55" alt="">
                                                        </td>
                                                        <td><?php echo html_entity_decode($employeur->raisonsociale) ?></td>
                                                        <td>{{ $employeur->name }}</td>
                                                        <td>{{ $employeur->contact }}</td>
                                                        <td>{{ \Carbon\Carbon::parse($employeur->date_validation)->format('d/m/Y') }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="demandeur">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>Nom & Prénoms</th>
                                                    <th>Email</th>
                                                    <th>Téléphone</th>
                                                    <th>Valider le</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($demandeurs as $demandeur)
                                                    <tr>
                                                        <td>
                                                            @if(!empty($demandeur->profil_photo))
                                                                <img src="{{ asset('assets/img/profil/'.$demandeur->profil_photo) }}" width="30" alt="">
                                                            @else
                                                                <img src="{{ asset('assets/img/profil/avatar.png') }}" width="30" alt="">
                                                            @endif
                                                        </td>
                                                        <td>{{ $demandeur->name }} {{ $demandeur->prenoms }}</td>
                                                        <td>{{ $demandeur->email }}</td>
                                                        <td>{{ $demandeur->telephone }}</td>
                                                        <td>{{ \Carbon\Carbon::parse($demandeur->date_validation)->format('d/m/Y') }}</td>
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="offre">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>Titre de l'offre</th>
                                                    <th>Status</th>
                                                    <th>Valider le</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($offres as $offre)
                                                    <tr>
                                                        <td>
                                                            <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                                        </td>
                                                        <td>
                                                            <div class="cats-box rounded bg-white d-flex align-items-center">
                                                                <div class="cats-box-caption px-2">
                                                                    <h4 class="fs-md mb-0 ft-medium">{{ $offre->offretitre }}</h4>
                                                                    <div class="d-block mb-2 position-relative">
                                                                        <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>{{ $offre->region_nom }}</span>
                                                                        <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $offre->typecontratlib }}</span>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            @if($offre->offre_statut == "BROUILLON")
                                                                <span class="badge badge-danger light">Brouillon</span>
                                                            @elseif($offre->offre_statut == "VALIDE")
                                                                <span class="badge badge-warning light">Active</span>
                                                            @elseif($offre->offre_statut == "PUBLIE")
                                                                <span class="badge badge-success light">Publié</span>
                                                            @endif
                                                        </td>
                                                        <td>{{ \Carbon\Carbon::parse($offre->offre_datepublic)->format('d/m/Y') }}</td>                                              
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="article">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th></th>
                                                    <th>Titre de l'actualite</th>
                                                    <th>Cartégorie</th>
                                                    <th>Publier par</th>
                                                    <th>Créer le</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($articles as $article)
                                                    <tr>
                                                        <td>
                                                            <div class="text-center"><img src="{{ asset('assets/img/actualite/'.$article->actualite_image) }}" class="img-fluid" width="55" alt=""></div>
                                                        </td>
                                                        <td>
                                                            @php
                                                                $titre = $article->actualite_titre;
                                                                $titre_affiche = substr($titre, 0, 55);
                                                                if($titre_affiche < $article->actualite_titre){
                                                                    echo($titre_affiche).'...';
                                                                }
                                                                else{                                            
                                                                    echo($article->actualite_titre);
                                                                }
                                                            @endphp
                                                        </td>
                                                        <td><span class="badge badge-success light">{{ $article->categorielib }}</span></td>
                                                        <td>{{ $article->actualite_publiepar }}</td>
                                                        <td>{{ \Carbon\Carbon::parse($article->actualite_datecrea)->format('d/m/Y') }}</td>                                             
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="agent">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th class="d-none"></th>
                                                    <th>Nom & Prénoms</th>
                                                    <th>Profil</th>
                                                    <th>Région</th>
                                                    <th>Statut</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($agents as $utilisateur)
                                                    <tr>
                                                        <td class="d-none"></td>
                                                        <td><img src="{{ asset('assets/img/profil/'.$utilisateur->profil_photo) }}" class="img-fluid mr-3" width="55" alt="">{{ $utilisateur->name }} {{ $utilisateur->prenoms }}</td>
                                                        <td>{{ $utilisateur->profil_libelle }}</td>
                                                        <td>{{ $utilisateur->region_nom }}</td>                                                        
                                                        <td>
                                                            @if($utilisateur->user_statut == "VALIDE")
                                                                <img src="{{ asset('assets/img/icons/active.png') }}" width="50">
                                                            @else
                                                                <img src="{{ asset('assets/img/icons/desactive.png') }}" width="50">
                                                            @endif
                                                        </td>                                              
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="publication">
                                <div class="pt-4">
                                    <div class="table-responsive">
                                        <table id="example3" class="display min-w850">
                                            <thead>
                                                <tr>
                                                    <th class="d-none"></th>
                                                    <th>Fichier</th>
                                                    <th>Titre</th>
                                                    <th>Date</th>
                                                    <th>Statut</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($publications as $publication)
                                                    <tr>
                                                        <td class="d-none"></td>
                                                        <td>
                                                            @if($publication->publication_extension == "pdf")
                                                                <div><img src="{{ asset('assets/img/pdf-icon.png') }}" class="img-fluid" width="35" alt=""></div>
                                                            @elseif($publication->publication_extension == "xlsx")
                                                                <div><img src="{{ asset('assets/img/excel-icon.png') }}" class="img-fluid" width="35" alt=""></div>
                                                            @elseif($publication->publication_extension == "docx")
                                                                <div><img src="{{ asset('assets/img/word-icon.png') }}" class="img-fluid" width="35" alt=""></div>
                                                            @endif
                                                        </td>
                                                        <td><?php echo html_entity_decode($publication->publication_libelle) ?></td>
                                                        <td>{{ \Carbon\Carbon::parse($publication->publication_datecreation)->format('d/m/Y') }}</td>
                                                        <td>
                                                            @if($publication->publication_statut == "VALIDE")
                                                                <img src="{{ asset('assets/img/icons/active.png') }}" width="50"> 
                                                            @else
                                                                <img src="{{ asset('assets/img/icons/desactive.png') }}" width="50">
                                                            @endif
                                                        </td>                                               
                                                    </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection