@extends('layouts.appp')

@section('title')
    Liste des agents
@endsection

@section('titre')
    Liste des agents
@endsection

@section('content') 
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion agents</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des agents</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT"))
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des agents</h4>
                        <!--div class="float-end">
                            @if($utilisateurs->count() > 0)
                                <a href="{{ route('admin.export-utilisateur.pdf') }}" class="badge badge-primary">Export PDF</a>
                                <a href="{{ route('admin.export-utilisateur.excel') }}" class="badge badge-success">Export Excel</a>
                            @endif
                        </div-->
                    </div>
                    <div class="card-body">
                        <form action="{{ route('admin.liste.utilisateur') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-5">
                                    <label>Région</label>
                                    <select id="single-select" name="r">
                                        <option value="">Choissisez une région</option>
                                        @foreach($regions as $region)
                                            <option @if($region_selected == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-5">
                                    <label>Profil</label>
                                    <select class="form-control" name="p">
                                        <option value="">Choissisez un profil</option>
                                        @foreach($profils as $profil)
                                            <option @if($profil_selected == $profil->profil_id) selected @endif value="{{ $profil->profil_id }}">{{ $profil->profil_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Nom & Prénoms</th>
                                        <th>Type d'agent</th>
                                        <th>Région</th>
                                        @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT"))
                                        <th>Statut</th>
                                        @endif
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($utilisateurs as $utilisateur)
                                        <tr>
                                            <td class="d-none"></td>
                                            <td><img src="{{ asset('assets/img/profil/'.$utilisateur->profil_photo) }}" class="img-fluid mr-3" width="55" alt="">{{ $utilisateur->name }} {{ $utilisateur->prenoms }}</td>
                                            <td>{{ $utilisateur->qualite }}</td>
                                            <td>{{ $utilisateur->region_nom }}</td>
                                            @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT"))
                                            <td>
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    @if($utilisateur->user_statut == "VALIDE")
                                                        <a href="{{ route('admin.desactiver-compte.utilisateur',$utilisateur->id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a>
                                                    @else
                                                        <a href="{{ route('admin.activer-compte.utilisateur',$utilisateur->id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                    @endif
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT"))
                                                    @if($utilisateur->user_statut == "VALIDE")
                                                        <a href="{{ route('admin.desactiver-compte.utilisateur',$utilisateur->id) }}"><img src="{{ asset('assets/img/icons/active.png') }}" width="50"></a> 
                                                    @endif
                                                    
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT"))
                                                    @if($utilisateur->user_statut == "BROUILLON")
                                                        <a href="{{ route('admin.activer-compte.utilisateur',$utilisateur->id) }}"><img src="{{ asset('assets/img/icons/desactive.png') }}" width="50"></a>
                                                    @endif                                                    
                                                @endif
                                            </td>
                                            @endif
                                            <td class="text-center">
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT_ACT"))
                                                    <a href="{{ route('admin.details.utilisateur', [$utilisateur->id, Stdfn::clean_url($utilisateur->prenoms)]) }}" style="cursor:pointer"><img src="{{ asset('assets/img/icons/details.png') }}" class="img-fluid" width="24" title="DETAILS"></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT"))
                                                    <a href="{{ route('admin.modifier.utilisateur', [$utilisateur->id, Stdfn::clean_url($utilisateur->prenoms)]) }}" style="cursor:pointer"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" title="MODIFIER"></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT") and $utilisateur->creerpar_id == Auth::user()->id)
                                                    <a href="{{ route('admin.modifier.utilisateur', [$utilisateur->id, Stdfn::clean_url($utilisateur->prenoms)]) }}" style="cursor:pointer"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" title="MODIFIER"></a>
                                                @endif
                                                @if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_AGENT"))
                                                    <span data-toggle="modal" data-target="#supprimerutilisateur{{$utilisateur->id}}"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="25" title="SUPPRIMER"></span>                                             
                                                @endif
                                           </td>                                               
                                        </tr>
                                        <div class="modal fade" id="supprimerutilisateur{{$utilisateur->id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer le demandeur d'emploi : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('admin.supprimer.utilisateur',$utilisateur->id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                @endif
            </div>
        </div>
    </div>
@endsection