@extends('layouts.appp')

@section('title')
    Modifier : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}
@endsection
 
@section('titre')
    Modifier : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}
@endsection

@section('content')
    <style>
        #actions{
            background-color: #ccc;
        }
    </style>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion agents</a></li>
                <li class="breadcrumb-item"><a href="{{ route('admin.liste.utilisateur') }}">Liste des agents</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Modifier</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Modifier : {{ $utilisateur->name }} {{ $utilisateur->prenoms }}</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form method="POST" action="{{ route('admin.save-modifier.utilisateur',$utilisateur->id) }}" enctype="multipart/form-data">
                                @csrf
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label>Nom <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="nom" value="{{ $utilisateur->name }}" placeholder="Entrer le nom">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Prénoms <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" name="prenoms" value="{{ $utilisateur->prenoms }}" placeholder="Entrer le prénoms">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Civilité <span class="text-danger">*</span></label>
                                        <select name="civilite" class="form-control">
                                            <option value="" selected>Choisir une civilité</option>
                                            <option value="Mme" @if($utilisateur->civilite == "Mme") selected @endif>Madame</option>
                                            <option value="Mlle" @if($utilisateur->civilite == "Mlle") selected @endif>Mademoiselle</option>
                                            <option value="Mr" @if($utilisateur->civilite == "Mr") selected @endif>Monsieur</option>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Région <span class="text-danger">*</span></label>
                                        <select name="region_id" id="metier-select" class="form-control" required>
                                            <option value="" selected>Choisir une région</option>
                                            @foreach($regions as $region)
                                                <option value="{{ $region->region_id }}" @if($utilisateur->region_id == $region->region_id) selected @endif>{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Type d'agent</label>
                                        <input type="text" class="form-control" name="qualite" value="{{ $utilisateur->qualite }}" placeholder="Entrer le type d'agent">
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label>Photo de profil</label>
                                        <input type="file" class="form-control" name="profil_photo" value="{{ $utilisateur->profil_photo }}">
                                    </div>
                                </div>
                                <div class="form-row">                                    
                                    <div class="form-group col-md-12">
                                        <label>Niveau d'administration</label>
                                        <select name="profil_id" class="form-control" onchange="getActions(this.value)">
                                            <option value="" selected>Choisir un niveau d'administration</option>
                                            @foreach($profils as $profil)
                                                <option value="{{ $profil->profil_id }}" {{ old('profil_id') == $profil->profil_id ? 'selected' : '' }}>{{ $profil->profil_libelle }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div id="actions"></div>
                                <button type="submit" class="btn btn-primary mt-3">Mettre à jours le compte</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function getActions(profil_id) {
            if (profil_id) {
                $.ajax({
                    url: '/profil/' + profil_id + '/actions',
                    success: function(actions) {
                        var html = '';
                        for (var i = 0; i < actions.length; i++) {
                            if (i % 2 === 0) {
                                html += '<div class="row" style="padding:5px !important; color:#000 !important">';
                            }
                            html += '<div class="col-md-6"><input type="checkbox" class="css-control-input" name="actions[]" value="' + actions[i].action_id + '"> ' + actions[i].action_libelle + '</div>';
                            if (i % 2 === 1 || i === actions.length - 1) {
                                html += '</div>';
                            }
                        }
                        $('#actions').html(html);
                    }
                });
            } else {
                $('#actions').html('');
            }
        }
    </script>
@endsection