@extends('layouts.app')
@section('title')
    Réinitialisation du mot de passe
@endsection

@section('content')
<style>
    .btn-success{
        color: #fff !important;
        border-radius: 5px;
        margin-top: 15px;
    }

    .theme-bg-light{
        background: #39BC6D !important;
        border: 4px solid orange;
    }

    .lni-user , .fa-user-circle{
        color: #fff !important;
    }

    .motpasseoublie{
        background-color: #fff !important;
    }

</style>
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Réinitialisation du mot de passe</h1>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="space min">
    <div class="container">        
        <div class="row align-items-center">
            <div class="col-lg-8 col-md-8 mx-auto">
                <div class="pricing_wrap">
                    <form class="_apply_form_form" method="POST" action="{{ route('save.password.update') }}">   
                        @csrf  
                        <input type="hidden" name="token" value="{{ $token }}">
                        <div class="row"> 
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="text-dark mb-1 ft-medium medium">Adresse Email <span style="color:red">*</span></label>
                                    <input id="email" type="email" class="form-control @error('email') is-invalid @enderror" name="email" value="{{ $email ?? old('email') }}" autocomplete="email" autofocus>
                                </div> 
                            </div> 
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="text-dark mb-1 ft-medium medium">Nouveau mot de passe <span style="color:red">*</span></label>
                                    <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="new-password">
                                </div>
                            </div>                        
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="text-dark mb-1 ft-medium medium">Confirmer mot de passe <span style="color:red">*</span></label>
                                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation" autocomplete="new-password">
                                </div>
                            </div>
                        </div>                            
                        <div class="form-group">
                            <button type="submit" class="btn btn-md rounded theme-bg text-light ft-medium fs-sm full-width">Envoyer la demande de réinitialisation du mot de passe</button>
                        </div>                         
                    </form>
                </div>
            </div>
        </div>        
    </div>
</section>
@endsection