@extends('layouts.app')
@section('title')
    Créer un nouveau CV
@endsection

@section('content')
<script src="//maxcdn.bootstrapcdn.com/bootstrap/3.3.0/js/bootstrap.min.js"></script>
<script src="//code.jquery.com/jquery-1.11.1.min.js"></script>
<script type="text/javascript" src="js/jquery-1.9.0.js"></script>
<script type="text/javascript" src="http://ajax.aspnetcdn.com/ajax/jquery.validate/1.13.1/jquery.validate.js"></script>
<script type="text/javascript" src="http://ajax.aspnetcdn.com/ajax/jquery.validate/1.13.1/additional-methods.js"></script>
<style type="text/css">
    #personal_information, #company_information{
        display:none;
    }
    .has-error{
        color: red !important;
        font-style: italic;
        margin-top: 3px;
    }
    #messageErreur{
        color: red;
        font-size: 6 !important;
        font-style: italic;
    }
    .
</style>
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Créer un nouveau CV</h1>
                </div>                
            </div>
        </div>
    </div>
</div>
<section class="space min">
    <div class="container">        
        <div class="row align-items-center">
            <div class="col-lg-10 col-md-10 mx-auto">
                <div class="pricing_wrap">
                    <form class="form-horizontal" action="{{ route('demandeur.save.nouveau.cv') }}" method="POST" id="myform" enctype="multipart/form-data">
                        <fieldset id="account_information" class="">
                            <legend class="text-center">Information Personnelle</legend><hr>
                            <div class="row">
                                <div class="col-md-6">                      
                                    <div class="form-group">
                                        <label class="text-dark mb-1 medium">Nom <span style="color:red">*</span></label>
                                        <input type="text" class="form-control" id="nom" name="nom" placeholder="Entrer votre prénoms"  onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="col-md-6">                      
                                    <div class="form-group">
                                        <label class="text-dark mb-1 medium">Prénoms <span style="color:red">*</span></label>
                                        <input type="text" class="form-control" id="prenoms" name="prenoms" placeholder="Entrer votre prénoms"  onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1">Âge <span style="color:red;">*</span></label>
                                        <input type="text" class="form-control" id="age" name="age" placeholder="Entrer votre âge" onkeypress="isInputNumber(event)" onblur="verifierValeur(this.value)">
                                        <div id="messageErreur"></div>
                                    </div>
                                </div> 
                                <div class="col-md-6">                      
                                    <div class="form-group">
                                        <label class="text-dark mb-1 medium">Téléphone <span style="color:red">*</span></label>
                                        <input type="text" class="form-control" id="telephone" name="telephone" placeholder="Entrer le numéro de téléphone" onkeypress="isInputNumber(event)">
                                    </div>
                                </div>
                            </div>
                            <div class="row">  
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Adresse mail <span style="color:red">*</span></label>
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Votre adresse mail">
                                    </div>                            
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Photo <span style="color:red">*</span></label>
                                        <input type="file" class="form-control" id="profil_photo" name="profil_photo">
                                    </div>                            
                                </div>
                            </div>
                          <p><center><a class="btn btn-md theme-bg text-light next">Suivant <i class="lni lni-arrow-right-circle ml-2"></i></a></center></p>
                        </fieldset>
                        <fieldset id="company_information" class="">
                            <legend class="text-center">Domaines de compétence & Formations et Diplômes</legend><hr>
                            <div id="field">
                                <div id="field0">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Compétence</label>
                                                <input type="text"  name="competences[]" id="competences" class="form-control" placeholder="Entrer le domaine de compétence..." required>
                                            </div>
                                        </div>
                                        <br>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Formations ou Diplômes</label>
                                                <input type="text"  name="formation_diplomes[]" id="formation_diplomes" class="form-control" placeholder="Entrer une formation ou un diplôme..." required>
                                            </div>
                                        </div>
                                    </div>
                                   <hr>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-md-12 col-md-offset-12">
                                    <button id="add-more" name="add-more" class="btn btn-primary"><i class="fa fa-plus-circle mr-2"></i>Ajouter Plus</button>
                                </div>
                            </div>
                            <br><br>
                            <div class="jbd-02 px-3 py-3 br-top">
                                <div class="jbd-02-flex d-flex align-items-center justify-content-between">
                                    <div class="jbd-02-social">
                                        <p><a class="btn btn-md bg-dark text-light hover-theme" id="previous"><i class="lni lni-arrow-left-circle mr-2"></i> Précédent</a></p>
                                    </div>
                                    <div class="jbd-02-aply">
                                        <div class="jbl_button mb-2">
                                            <a class="btn btn-md theme-bg text-light fs-sm ft-medium next">Suivant <i class="lni lni-arrow-right-circle ml-2"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                        <fieldset id="personal_information" class="">
                            <legend class="text-center">Qualités personnelles, Intérêts & Langues</legend><hr>
                            <div id="fielda">
                                <div id="fielda0">
                                    <div class="row">
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Qualités personnelles</label> 
                                                <input type="text"  name="qualites[]" id="qualites" class="form-control" placeholder="Entrer un qualité" required> 
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Intérêts</label>                                        
                                                <input type="text"  name="interets[]" id="interets" class="form-control" placeholder="Entrer un centre d'intérêt" required>
                                            </div>
                                        </div>
                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label>Langues</label>                                      
                                                <input type="text"  name="langues[]" id="langues" class="form-control" placeholder="Entrer une langue" required>
                                            </div>
                                        </div>
                                    </div>
                                    <hr>
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="col-md-12 col-md-offset-12">
                                   <button id="add-more1" name="add-more" class="btn btn-primary"><i class="fa fa-plus-circle mr-2"></i>Ajouter Plus</button>
                                </div>
                            </div>
                            <div class="jbd-02 px-3 py-3 br-top">
                                <div class="jbd-02-flex d-flex align-items-center justify-content-between">
                                    <div class="jbd-02-social">
                                        <p><a class="btn btn-md bg-dark text-light hover-theme" id="previous"><i class="lni lni-arrow-left-circle mr-2"></i> Précédent</a></p>
                                    </div>
                                    <div class="jbd-02-aply">
                                        <div class="jbl_button mb-2">
                                            <button type="submit" class="btn btn-md theme-bg text-light fs-sm ft-medium">Valider <i class="fas fa-check small ml-2"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
      <script>
        
        $(document).ready(function(){

            // Custom method to validate username
            $.validator.addMethod("usernameRegex", function(value, element) {
                return this.optional(element) || /^[a-zA-Z0-9]*$/i.test(value);
            }, "Username must contain only letters, numbers");

            $(".next").click(function(){
                var form = $("#myform");
                form.validate({
                    errorElement: 'span',
                    errorClass: 'help-block',
                    highlight: function(element, errorClass, validClass) {
                        $(element).closest('.form-group').addClass("has-error");
                    },
                    unhighlight: function(element, errorClass, validClass) {
                        $(element).closest('.form-group').removeClass("has-error");
                    },
                    rules: {
                        nom: {
                            required: true,
                            minlength: 3,
                        },
                        prenoms: {
                          required: true,
                          minlength: 3,
                       },
                       telephone: {
                          required: true,
                       },
                        url:{
                            required: true,
                        },
                        age: {
                            required: true,
                            minlength: 2,
                        },
                        email: {
                            required: true,
                            minlength: 3,
                        },
                        profil_photo: {
                          required: true,
                          extension: "png|jpg|jpeg"
                       },
                        
                    },
                    messages: {
                        nom: {
                            required: "Le nom est obligatoire",
                            minlength: "Le nom doit être d'au moins 3 caractères",
                        },
                        prenoms: {
                          required: "Le prénoms est obligatoire",
                          minlength: "Le prénoms doit être d'au moins 3 caractères",
                       },
                       age: {
                          required: "L'âge est obligatoire",
                          minlength: "L'âge doit être d'au moins 2 chiffres",
                       },
                       telephone: {
                          required: "Le numéro de téléphone est obligatoire",
                       },
                        email: {
                            required: "L'adresse mail est obligatoire",
                            minlength: "Entrer une adresse mail d'au moins 6 caractères",
                        },
                        profil_photo: {
                          required: "Veuillez choisir une photo de carte",
                          extension: "Le fichier doit être une image de type PNG, JPG ou JPEG",
                       },
                    }
                });
                if (form.valid() === true){
                    if ($('#account_information').is(":visible")){
                        current_fs = $('#account_information');
                        next_fs = $('#company_information');
                    }else if($('#company_information').is(":visible")){
                        current_fs = $('#company_information');
                        next_fs = $('#personal_information');
                    }
                    
                    next_fs.show(); 
                    current_fs.hide();
                }
            });

            $('#previous').click(function(){
                if($('#company_information').is(":visible")){
                    current_fs = $('#company_information');
                    next_fs = $('#account_information');
                }else if ($('#personal_information').is(":visible")){
                    current_fs = $('#personal_information');
                    next_fs = $('#company_information');
                }
                next_fs.show(); 
                current_fs.hide();
            });
            
    //@naresh action dynamic childs
    var next_exp = 0;
    $("#add-more1").click(function(e){
        e.preventDefault();
        var addto = "#fielda" + next_exp;
        var addRemove = "#fielda" + (next_exp);
        next_exp = next_exp + 1;
        var newInp = ' <div id="fielda'+ next_exp +'" name="field1'+ next_exp +'"><div class="row"><div class="col-md-12"><div class="form-group"><label>Qualités personnelles</label> <input type="text"  name="qualites[]" id="qualites" class="form-control" placeholder="Entrer un qualité" required> </div></div><div class="col-md-12"><div class="form-group"><label>Intérêts</label><input type="text"  name="interets[]" id="interets" class="form-control" placeholder="Entrer un centre d\'intérêt" required></div></div><div class="col-md-12"><div class="form-group"><label>Langues</label><input type="text"  name="langues[]" id="langues" class="form-control" placeholder="Entrer une langue" required></div></div></div><hr>';
        var newInput = $(newInp);
    
        var removeBtn = '<button id="remove' + (next_exp - 1) + '" class="btn btn-danger remove-me" >Retirer</button></div></div><div id="field"><br>';
        var removeButton = $(removeBtn);
        $(addto).after(newInput);
        $(addRemove).after(removeButton);
        $("#fielda" + next_exp).attr('data-source',$(addto).attr('data-source'));
        $("#count").val(next_exp);  
        
            $('.remove-me').click(function(e){
                e.preventDefault();
                var fieldNum = this.id.charAt(this.id.length-1);
                var fieldID = "#fielda" + fieldNum;
                $(this).remove();
                $(fieldID).remove();
            });
    });
    
        
    //@naresh action dynamic childs
    var nextedu = 0;
    $("#add-more").click(function(e){
        e.preventDefault();
        var addto = "#field" + nextedu;
        var addRemove = "#field" + (nextedu);
        nextedu = nextedu + 1;
        var newIn = ' <div id="field'+ nextedu +'" name="field'+ nextedu +'"><!-- Text input--><div class="row"><div class="col-md-12"><label>Compétence</label><div class="form-group"><input type="text" name="competences[]" id="competences" class="form-control" placeholder="Entrer le domaine de compétence..." required> </div></div><br><!-- Text input--><div class="col-md-12"><label>Formations ou Diplômes</label><div class="form-group"><input type="text"  name="formation_diplomes[]" id="formation_diplomes" class="form-control" placeholder="Entrer une formation ou un diplôme..." required></div></div><!-- Text input--></div></div><hr>';
        var newInput = $(newIn);
    
        var removeBtn = '<button id="remove' + (nextedu - 1) + '" class="btn btn-danger remove-me" >Retirer</button></div></div><div id="field">';
        var removeButton = $(removeBtn);
        $(addto).after(newInput);
        $(addRemove).after(removeButton);
        $("#field" + nextedu).attr('data-source',$(addto).attr('data-source'));
        $("#count").val(nextedu);  
        
            $('.remove-me').click(function(e){
                e.preventDefault();
                var fieldNum = this.id.charAt(this.id.length-1);
                var fieldID = "#field" + fieldNum;
                $(this).remove();
                $(fieldID).remove();
            });
    }); 
    
            
        });
    // Récupération de l'élément HTML input
    const estimationInput = document.getElementById("age");

    // Définition de la limite de saisie à une caractère
    estimationInput.maxLength = 2;

    function verifierValeur(valeur){
        if (valeur > 17) {
            document.getElementById('messageErreur').innerHTML = '';
        }else{            
            document.getElementById('messageErreur').innerHTML = "L'âge saisi doit être supérieur ou égale 18";
            document.getElementById('age').value = '';
        }
    }
    </script>
@endsection