@extends('layouts.appp')

@section('title')
    Liste des candidatures validées
@endsection

@section('titre')
    Liste des candidatures validées
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Mes Candidatures</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des candidatures validées</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des candidatures validées</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Titre</th>
                                        <th>Date abonnement</th>
                                        <th class="text-center">Statut</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($offres as $offre)
                                        <tr>
                                            <td>
                                                <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                            </td>
                                            <td>
                                                <div class="cats-box rounded bg-white d-flex align-items-center">
                                                    <div class="cats-box-caption px-2">
                                                        <h4 class="fs-md mb-0 ft-medium">{{ $offre->offretitre }}</h4>
                                                        <div class="d-block mb-2 position-relative">
                                                            <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>{{ $offre->raisonsociale }}</span>
                                                            <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ \Carbon\Carbon::parse($offre->candidature_datecrea)->format('d/m/Y') }}</td>
                                            <td class="text-center">
                                                @if($offre->candidature_statut == "BROUILLON")
                                                    <span class="badge badge-danger">En attente</span>
                                                @elseif($offre->candidature_statut == "VALIDE")
                                                    <span class="badge badge-warning">Validé par l'ANPE</span>
                                                @elseif($offre->candidature_statut == "APPROUVE")
                                                    <span class="badge badge-success">{{ $offre->contrat->typecontratlib }} accepté</span>
                                                @endif
                                            </td>                                               
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection