@extends('layouts.appp')

@section('title')
    Tableau de bord
@endsection

@section('titre')
    Tableau de bord
@endsection

@section('content')
<link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
<link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
@if(Auth::user()->profil_id ==3)
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12">    
            <div class="row">
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="{{ route('demandeur.candidature.attente') }}">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-warning">
                                            @if($mes_candidature_attente > 1000)
                                                <?php
                                                    $mes_candidature_attente_premiers_caracteres = substr($mes_candidature_attente, 0, 2);
                                                    echo $mes_candidature_attente_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $mes_candidature_attente }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-warning">
                                        <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M38.4998 10.4995H35.0002V38.4999H38.4998C40.4245 38.4999 42 36.9238 42 34.9992V13.9992C42 12.075 40.4245 10.4995 38.4998 10.4995Z" fill="#2BC155"/>
                                            <path d="M27.9998 10.4995V6.9998C27.9998 5.07515 26.4243 3.49963 24.5001 3.49963H17.4998C15.5757 3.49963 14.0001 5.07515 14.0001 6.9998V10.4995H10.5V38.4998H31.5V10.4995H27.9998ZM24.5001 10.4995H17.4998V6.99929H24.5001V10.4995Z" fill="#2BC155"/>
                                            <path d="M3.50017 10.4995C1.57551 10.4995 0 12.075 0 13.9997V34.9997C0 36.9243 1.57551 38.5004 3.50017 38.5004H6.99983V10.4995H3.50017Z" fill="#2BC155"/>
                                        </svg>
                                    </span>
                                </div>
                                <span class="position">Candidatures en attente</span>
                            </a>
                        </div>
                        <span class="line bg-warning"></span>
                    </div>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="{{ route('demandeur.candidature.valide') }}">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-secondary">
                                            @if($mes_candidature_valide > 1000)
                                                <?php
                                                    $mes_candidature_valide_premiers_caracteres = substr($mes_candidature_valide, 0, 2);
                                                    echo $mes_candidature_valide_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $mes_candidature_valide }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-secondary">
                                        <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M38.4998 10.4995H35.0002V38.4999H38.4998C40.4245 38.4999 42 36.9238 42 34.9992V13.9992C42 12.075 40.4245 10.4995 38.4998 10.4995Z" fill="#2BC155"/>
                                            <path d="M27.9998 10.4995V6.9998C27.9998 5.07515 26.4243 3.49963 24.5001 3.49963H17.4998C15.5757 3.49963 14.0001 5.07515 14.0001 6.9998V10.4995H10.5V38.4998H31.5V10.4995H27.9998ZM24.5001 10.4995H17.4998V6.99929H24.5001V10.4995Z" fill="#2BC155"/>
                                            <path d="M3.50017 10.4995C1.57551 10.4995 0 12.075 0 13.9997V34.9997C0 36.9243 1.57551 38.5004 3.50017 38.5004H6.99983V10.4995H3.50017Z" fill="#2BC155"/>
                                        </svg>
                                    </span>
                                </div>
                                <span class="position">Candidatures validées</span>
                            </a>
                        </div>
                        <span class="line bg-secondary"></span>
                    </div>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="{{ route('demandeur.candidature.approuve') }}">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-success">
                                            @if($mes_candidature_approuve > 1000)
                                                <?php
                                                    $mes_candidature__approuve_premiers_caracteres = substr($mes_candidature_approuve, 0, 2);
                                                    echo $mes_candidature__approuve_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $mes_candidature_approuve }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-success">
                                        <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M38.4998 10.4995H35.0002V38.4999H38.4998C40.4245 38.4999 42 36.9238 42 34.9992V13.9992C42 12.075 40.4245 10.4995 38.4998 10.4995Z" fill="#2BC155"/>
                                            <path d="M27.9998 10.4995V6.9998C27.9998 5.07515 26.4243 3.49963 24.5001 3.49963H17.4998C15.5757 3.49963 14.0001 5.07515 14.0001 6.9998V10.4995H10.5V38.4998H31.5V10.4995H27.9998ZM24.5001 10.4995H17.4998V6.99929H24.5001V10.4995Z" fill="#2BC155"/>
                                            <path d="M3.50017 10.4995C1.57551 10.4995 0 12.075 0 13.9997V34.9997C0 36.9243 1.57551 38.5004 3.50017 38.5004H6.99983V10.4995H3.50017Z" fill="#2BC155"/>
                                        </svg>
                                    </span>
                                </div>
                                <span class="position">Candidatures approuvées</span>
                            </a>
                        </div>
                        <span class="line bg-success"></span>
                    </div>
                </div>
            </div>
        </div>
        @if($offre_publie->count() > 0)
        <div class="col-xl-12">
            <div class="d-sm-flex align-items-center mb-sm-3 mt-sm-2 mt-2  mb-2">
                <h4 class="fs-20 text-black mr-auto mb-sm-0 mb-2">Offres qui peuvent vous intéressé</h4>
                <a href="{{ route('offres') }}" class="btn btn-outline-primary rounded mb-sm-0 mb-1">Voir Plus</a>
            </div>
            <div class="testimonial-one owl-carousel">
                @foreach($offre_publie as $offre)
                    <div class="items">
                        <div class="card" style="height:170px !important;">
                            <div class="card-body"> 
                                <div class="media pb-4 mb-4 align-items-center">
                                    <img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" style="width: 80px !important; margin-right: 10px !important;">                                
                                    <div class="media-body">
                                        <h4 class="fs-20"><a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="text-black">{{ $offre->offretitre }}</a></h4>
                                        <p>{{ $offre->diplomelib }}</p>
                                        <div class="d-flex">
                                            <a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn-link">Détails</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</div>
@endif
@endsection