<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>CV DE : {{ $nom }} {{ $prenoms }}</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
      list-style: none;
      font-family: "Arial", sans-serif;
    }

    body {
      font-size: 14px;
      line-height: 22px;
      color: #555555;
    }
    .container{
      padding-left:30px;
      padding-right:30px;
    }
    .titre{
      text-align:center;
      color:#0000A0;
      font-size:20px;
      margin-top:35px;
    }
    .border_name{
      color:#0000A0;
      margin-top:5px;
    }
    .information_personnelle .info_texte, .information_personnelle .info_image{
      display:inline-block;
    }
    .information_personnelle .info_texte{
      float:left;
      margin-top:10px;
    }
    .information_personnelle .info_image{
      float:right;
      margin-top:10px;
    }
    .nom, .telephone{
      font-weight:bold;
    }
    .photo_cv{
      width:120px;
      border:1px solid #ccc;
    }
    .domaines{
      background:#0000A0;
      padding:3px;
      margin-top:145px;
    }
    .domaines .titre_domaine{
      color:#fff;
      font-size:14px;
    }
    .paragraphe_domaine, .paragraphe_formation, .paragraphe_atout{
      margin-left:12px;
      margin-top:5px;
      font-size:16px;
      line-height:28px;
    }
    .formations{
      background:#0000A0;
      padding:3px;
      margin-top:15px;
    }
    .formations .titre_formation{
      color:#fff;
      font-size:14px;
    }
    .atouts{
      background:#0000A0;
      padding:3px;
      margin-top:15px;
    }
    .atouts .titre_atout{
      color:#fff;
      font-size:14px;
    }
    .circle {
      display: inline-block;
      width: 7px;
      height: 7px;
      border-radius: 50%;
      background-color: #0000A0; /* ou une autre couleur de votre choix */
    }
    .carre {
      display: inline-block;
      width: 7px;
      height: 7px;
      background-color: #136203;
    }
    .triangle {
      display: inline-block;
      width: 0;
      height: 0;
      border-left: 5px solid transparent;
      border-right: 5px solid transparent;
      border-bottom: 7px solid #f9c208;
    }
    .certifier{
      margin-top: 10px;
      float: right;
      font-style: italic;
    }
  </style>
</head>
<body>
  <div class="container">
    <h2 class="titre">{{ $fonction }}</h2><hr class="border_name">
    <div class="information_personnelle">
      <div class="info_texte">
        <p class="nom">{{ $nom }} {{ $prenoms }}</p>
        <p>{{ $age }} ans, {{ $situation }}</p>
        <p>Téléphone : <span class="telephone">{{ $telephone }} / {{ $telephone2 }}</span></p>
        <p>E-mail : {{ $email }}</p>
      </div>
      <div class="info_image">
        <img src="{{ $image_cv }}" alt="Photo CV" class="photo_cv">
      </div>
    </div>
    <div class="domaines">
      <h2 class="titre_domaine">DOMAINES DE COMPÉTENCE</h2>      
    </div>
    <div class="paragraphe_domaine">
      @foreach($competences as $competence)
        <p><span class="circle"></span> {{ $competence }}</p>
      @endforeach
    </div>
    <div class="formations">
      <h2 class="titre_formation">FORMATIONS ET DIPLÔMES</h2>      
    </div>
    <div class="paragraphe_formation">
      @foreach($formations as $formation)
        <p><span class="carre"></span> {{ $formation }}</p>
      @endforeach
    </div>
    <div class="atouts">
      <h2 class="titre_atout">QUALITÉS PERSONNELLES, INTÉRÊTS & LANGUES</h2>      
    </div>
    <div class="paragraphe_atout"> 
      @foreach($qualites as $qualite)     
        <p><span class="triangle"></span> {{ $qualite }}</p>
      @endforeach
      @foreach($interets as $interet)
        <p><span class="triangle"></span> {{ $interet }}</p>
      @endforeach
      @foreach($langues as $langue)
        <p><span class="triangle"></span> {{ $langue }}</p>
      @endforeach
    </div>
    <div class="certifier">
      <p>Certifié sincère</p>
    </div>
  </div>
</body>
</html>