@extends('layouts.appp')
@section('title')
    Créer un nouveau CV
@endsection

@section('titre')
    Créer un nouveau CV
@endsection

@section('content')
    <style type="text/css">
        label{
            color: #000;
        }
    </style>
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Mon CV</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Créer un nouveau CV</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Créer un nouveau CV</h4>
                        <div class="float-end">
                            @if($formations->count() > 0 and $experiencepro->count() > 0 and $specialites->count() > 0 and $centreinterets->count() > 0)
                                <a style="cursor:pointer" data-toggle="modal" data-target="#modal_generercv" class="badge badge-success"><i class="fa fa-file-pdf-o mr-2"></i>                                
                                    Générer le CV                                
                                </a>
                            @endif
                        </div>
                    </div>
                    <div class="card-body">     
                        <div class="default-tab">
                            <ul class="nav nav-tabs" role="tablist" style="font-size: 14px;">
                                <li class="nav-item">
                                    <a class="nav-link active" data-toggle="tab" href="#formations"><i class="fas fa-diagnoses mr-2"></i> Formations & Diplômes</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#experienceprofessionnelle"><i class="fas fa-award mr-2"></i> Expériences Professionnelles</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#specialites"><i class="fas fa-gopuram mr-2"></i> Spécialités</a>
                                </li>
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#centreinteretsqualiteslangues"><i class="fas fa-hot-tub mr-2"></i> Centre Intérêts, Qualités & Autres</a>
                                </li>
                            </ul>
                            <div class="tab-content">
                                <div class="tab-pane fade show active" id="formations" role="tabpanel">
                                    <div class="pt-4">
                                        <br><a class="badge badge-primary" data-toggle="modal" data-target="#modal_iconified" style="cursor:pointer;"><i class="fa fa-plus-circle mr-2"></i>Ajouter une formation & un diplôme</a><br><br>
                                        <div class="table-responsive">
                                            <table id="example3" class="display min-w850">
                                                <thead>
                                                    <tr>
                                                        <th>Diplôme</th>
                                                        <th>Institution de formation</th>
                                                        <th>Année de Formation</th>
                                                        <th>Date de création</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($formations as $formation)
                                                        <tr>
                                                            <td>{{ $formation->formation_diplome }}</td>
                                                            <td>{{ $formation->formation_institution }}</td>
                                                            <td>{{ $formation->formation_annescolaire }}</td>
                                                            <td>{{ \Carbon\Carbon::parse($formation->formation_datecreation)->format('d/m/Y') }}</td>
                                                            <td class="text-center">
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#modal_iconified{{$formation->formation_id}}" class="" title="MODIFIER LA FORMATION"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="32" alt=""></a>
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#supprimerformation{{$formation->formation_id}}" title="SUPPRIMER LA FORMATION"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="35" alt=""></a>
                                                            </td>
                                                        </tr>
                                                        <div id="modal_iconified{{$formation->formation_id}}" class="modal fade" tabindex="-1">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Modifier la formation</h5>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>
                                                                    <form method="POST" action="{{ route('demandeur.savemodifierformation',$formation->formation_id) }}">
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                            <div class="row" style="background:#ccc; padding-bottom: 6px;">
                                                                                <div class="col-md-12">
                                                                                    <label>Formation & Diplôme</label>
                                                                                    <input type="text" name="diplome" value="{{ $formation->formation_diplome }}" required class="form-control">
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label>Institution de formation</label>
                                                                                    <input type="text" name="institution" value="{{ $formation->formation_institution }}" required class="form-control">
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label>Année de Formation</label>
                                                                                    <input type="text" name="annescolaire" value="{{ $formation->formation_annescolaire }}" required class="form-control">
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="modal-footer">
                                                                            <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                                            <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer la modification</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="modal fade" id="supprimerformation{{$formation->formation_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        Vous êtes sur le point de supprimer la formation : {{ $formation->formation_diplome }}
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                                        <a href="{{ route('demandeur.supprimerformation',$formation->formation_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>                                        
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="experienceprofessionnelle">
                                    <div class="pt-4">
                                        <br><a class="badge badge-primary" data-toggle="modal" data-target="#modal_exepriencepro" style="cursor:pointer;"><i class="fa fa-plus-circle mr-2"></i>Ajouter une expérience</a><br><br>
                                        <div class="table-responsive">
                                            <table id="example3" class="display min-w850">
                                                <thead>
                                                    <tr>
                                                        <th>Type d'expérience</th>
                                                        <th>Durée</th>
                                                        <th>Entreprise</th>
                                                        <th>Compétence</th>
                                                        <th>Date de création</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($experiencepro as $experience)
                                                        <tr>
                                                            <td>{{ $experience->experiencepro_titre }}</td>
                                                            <td>{{ $experience->experiencepro_duree }}</td>
                                                            <td>{{ $experience->experiencepro_entreprise }}</td>
                                                            <td>{{ $experience->experiencepro_competence }}</td>
                                                            <td>{{ \Carbon\Carbon::parse($experience->experiencepro_datecreation)->format('d/m/Y') }}</td>
                                                            <td class="text-center">
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#modal_experiencepro{{$experience->experiencepro_id}}" class="" title="MODIFIER L'EXPÉRIENCE PROFESSIONNELLE"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="32" alt=""></a>
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#supprimerexperiencepro{{$experience->experiencepro_id}}" title="SUPPRIMER L'EXPÉRIENCE PROFESSIONNELLE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="35" alt=""></a>
                                                            </td>
                                                        </tr>
                                                        <div id="modal_experiencepro{{$experience->experiencepro_id}}" class="modal fade" tabindex="-1">
                                                            <div class="modal-dialog modal-lg">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Modifier l'expérience professionnelle</h5>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>
                                                                    <form method="POST" action="{{ route('demandeur.savemodifierexperiencepro',$experience->experiencepro_id) }}">
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                            <div class="row" style="background:#ccc; padding-bottom: 6px;">
                                                                                <div class="col-md-6">
                                                                                    <label>Titre du poste</label>
                                                                                    <input type="text" name="titre" value="{{ $experience->experiencepro_titre }}" required class="form-control">
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label>Période</label>
                                                                                    <input type="text" name="duree" value="{{ $experience->experiencepro_duree }}" required class="form-control">
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label>Entreprise</label>
                                                                                    <input type="text" name="entreprise" value="{{ $experience->experiencepro_entreprise }}" required class="form-control">
                                                                                </div>
                                                                                <div class="col-md-6 mt-3">
                                                                                    <label>Compétence</label>
                                                                                    <input type="text" name="competence" value="{{ $experience->experiencepro_competence }}" required class="form-control">
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="modal-footer">
                                                                            <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                                            <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer la modification</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal fade" id="supprimerexperiencepro{{$experience->experiencepro_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        Vous êtes sur le point de supprimer l'expérience professionnelle: {{ $experience->experiencepro_titre }}
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                                        <a href="{{ route('demandeur.supprimerexperiencepro',$experience->experiencepro_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>      
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="specialites">
                                    <div class="pt-4">
                                        <br><a class="badge badge-primary" data-toggle="modal" data-target="#modal_specialite" style="cursor:pointer;"><i class="fa fa-plus-circle mr-2"></i>Ajouter une spécialité</a><br><br>
                                        <div class="table-responsive">
                                            <table id="example3" class="display min-w850">
                                                <thead>
                                                    <tr>
                                                        <th>Intitulé</th>
                                                        <th class="text-center">Date de création</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($specialites as $specialite)
                                                        <tr>
                                                            <td>{{ $specialite->specialite_intitule }}</td>
                                                            <td class="text-center">{{ \Carbon\Carbon::parse($specialite->experiencepro_datecreation)->format('d/m/Y') }}</td>
                                                            <td class="text-center">
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#modal_specialite{{$specialite->specialite_id}}" class="" title="MODIFIER LA SPECIALITE"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="32" alt=""></a>
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#supprimerspecialite{{$specialite->specialite_id}}" title="SUPPRIMER LA SPECIALITE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="35" alt=""></a>
                                                            </td>
                                                        </tr>
                                                        <div id="modal_specialite{{$specialite->specialite_id}}" class="modal fade" tabindex="-1">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Modifier la spécialité</h5>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>
                                                                    <form method="POST" action="{{ route('demandeur.savemodifierspecialite',$specialite->specialite_id) }}">
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                            <div class="row" style="background:#ccc; padding-bottom: 6px;">
                                                                                <div class="col-md-12">
                                                                                    <label>Intitulé</label>
                                                                                    <input type="text" name="intitule" value="{{ $specialite->specialite_intitule }}" required class="form-control">
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="modal-footer">
                                                                            <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                                            <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer la modification</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="modal fade" id="supprimerspecialite{{$specialite->specialite_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        Vous êtes sur le point de supprimer la spécialité : {{ $specialite->specialite_intitule }}
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                                        <a href="{{ route('demandeur.supprimerspecialite',$specialite->specialite_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>    
                                    </div>
                                </div>
                                <div class="tab-pane fade" id="centreinteretsqualiteslangues">
                                    <div class="pt-4">
                                        <br><a class="badge badge-primary" data-toggle="modal" data-target="#modal_centreinteret" style="cursor:pointer;"><i class="fa fa-plus-circle mr-2"></i>Ajouter un centre intérêts, qualités & autres</a><br><br>
                                        <div class="table-responsive">
                                            <table id="example3" class="display min-w850">
                                                <thead> 
                                                    <tr>
                                                        <th>Intitulé</th>
                                                        <th class="text-center">Date de création</th>
                                                        <th class="text-center">Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($centreinterets as $centreinteret)
                                                        <tr>
                                                            <td>{{ $centreinteret->centreint_langue_intitule }}</td>
                                                            <td class="text-center">{{ \Carbon\Carbon::parse($centreinteret->centreint_langue_datecreation)->format('d/m/Y') }}</td>
                                                            <td class="text-center">
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#modal_centreinteret{{$centreinteret->centreint_langue_id}}" class="" title="MODIFIER LE CENTRE D'INTERET"><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="32" alt=""></a>
                                                                <a href="javascript:void(0);" data-toggle="modal" data-target="#supprimercentreinteret{{$centreinteret->centreint_langue_id}}" title="SUPPRIMER LE CENTRE D'INTERET"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="35" alt=""></a>
                                                            </td>
                                                        </tr>
                                                        <div id="modal_centreinteret{{$centreinteret->centreint_langue_id}}" class="modal fade" tabindex="-1">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Modifier le Centre Intérêts, Qualités & Autres</h5>
                                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                                    </div>
                                                                    <form method="POST" action="{{ route('demandeur.savemodifiercentreinteret',$centreinteret->centreint_langue_id) }}">
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                            <div class="row" style="background:#ccc; padding-bottom: 6px;">
                                                                                <div class="col-md-12">
                                                                                    <label>Intitulé</label>
                                                                                    <input type="text" name="centreinteret" value="{{ $centreinteret->centreint_langue_intitule }}" required class="form-control">
                                                                                </div>
                                                                            </div>
                                                                        </div>

                                                                        <div class="modal-footer">
                                                                            <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                                            <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer la modification</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="modal fade" id="supprimercentreinteret{{$centreinteret->centreint_langue_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        Vous êtes sur le point de supprimer le centre d'intérêt : {{ $centreinteret->centreint_langue_intitule }}
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                                        <a href="{{ route('demandeur.supprimercentreinteret',$centreinteret->centreint_langue_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Début Formation Modal -->
    <div id="modal_iconified" class="modal fade" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Ajouter des formations & diplômes</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form method="POST" action="{{ route('demandeur.saveformation') }}">
                    @csrf
                    <div class="modal-body">
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 1 <small class="text-danger">(Obligatoire)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Formation & Diplôme</label>
                                <input type="text" name="diplomes[]" placeholder="Entrer la formation & le diplôme" required class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Institution de formation</label>
                                <input type="text" name="institutions[]" placeholder="Entrer le nom de l'institution de formation" required class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Année de Formation</label>
                                <input type="text" name="annescolaires[]" placeholder="Entrer l'année de formation" required class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 2 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Formation & Diplôme</label>
                                <input type="text" name="diplomes[]" placeholder="Entrer la formation & le diplôme" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Institution de formation</label>
                                <input type="text" name="institutions[]" placeholder="Entrer le nom de l'institution de formation" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Année de Formation</label>
                                <input type="text" name="annescolaires[]" placeholder="Entrer l'année de formation" class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 3 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Formation & Diplôme</label>
                                <input type="text" name="diplomes[]" placeholder="Entrer la formation & le diplôme" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Institution de formation</label>
                                <input type="text" name="institutions[]" placeholder="Entrer le nom de l'institution de formation" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Année de Formation</label>
                                <input type="text" name="annescolaires[]" placeholder="Entrer l'année de formation" class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 4 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Formation & Diplôme</label>
                                <input type="text" name="diplomes[]" placeholder="Entrer la formation & le diplôme" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Institution de formation</label>
                                <input type="text" name="institutions[]" placeholder="Entrer le nom de l'institution de formation" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Année de Formation</label>
                                <input type="text" name="annescolaires[]" placeholder="Entrer l'année de formation" class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 5 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Formation & Diplôme</label>
                                <input type="text" name="diplomes[]" placeholder="Entrer la formation & le diplôme" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Institution de formation</label>
                                <input type="text" name="institutions[]" placeholder="Entrer le nom de l'institution de formation" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Année de Formation</label>
                                <input type="text" name="annescolaires[]" placeholder="Entrer l'année de formation" class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 6 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Formation & Diplôme</label>
                                <input type="text" name="diplomes[]" placeholder="Entrer la formation & le diplôme" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Institution de formation</label>
                                <input type="text" name="institutions[]" placeholder="Entrer le nom de l'institution de formation" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Année de Formation</label>
                                <input type="text" name="annescolaires[]" placeholder="Entrer l'année de formation" class="form-control">
                            </div>
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                        <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Fin Formation Modal -->

    <!-- Début Expérience Professionnellle Modal -->
    <div id="modal_exepriencepro" class="modal fade" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Ajouter des expériences professionnellles</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form method="POST" action="{{ route('demandeur.saveexperiencepro') }}">
                    @csrf
                    <div class="modal-body">
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 1 <small class="text-danger">(Obligatoire)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-6 mt-3">
                                <label>Titre du poste</label>
                                <input type="text" name="titres[]" placeholder="Entrer le titre du poste occupé" required class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Période</label>
                                <input type="text" name="durees[]" placeholder="Entrer la période" required class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Entreprise</label>
                                <input type="text" name="entreprises[]" placeholder="Entrer la raison sociale de l'entreprise" required class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Compétence</label>
                                <input type="text" name="competences[]" placeholder="Entrer la compétaence acquise" required class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 2 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-6 mt-3">
                                <label>Titre du poste</label>
                                <input type="text" name="titres[]" placeholder="Entrer le titre du poste occupé" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Période</label>
                                <input type="text" name="durees[]" placeholder="Entrer la période" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Entreprise</label>
                                <input type="text" name="entreprises[]" placeholder="Entrer la raison sociale de l'entreprise" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Compétence</label>
                                <input type="text" name="competences[]" placeholder="Entrer la compétaence acquise" class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 3 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-6 mt-3">
                                <label>Titre du poste</label>
                                <input type="text" name="titres[]" placeholder="Entrer le titre du poste occupé" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Période</label>
                                <input type="text" name="durees[]" placeholder="Entrer la période" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Entreprise</label>
                                <input type="text" name="entreprises[]" placeholder="Entrer la raison sociale de l'entreprise" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Compétence</label>
                                <input type="text" name="competences[]" placeholder="Entrer la compétaence acquise" class="form-control">
                            </div>
                        </div> 

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 4 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-6 mt-3">
                                <label>Titre du poste</label>
                                <input type="text" name="titres[]" placeholder="Entrer le titre du poste occupé" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Période</label>
                                <input type="text" name="durees[]" placeholder="Entrer la période" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Entreprise</label>
                                <input type="text" name="entreprises[]" placeholder="Entrer la raison sociale de l'entreprise" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Compétence</label>
                                <input type="text" name="competences[]" placeholder="Entrer la compétaence acquise" class="form-control">
                            </div>
                        </div>

                        <hr>  
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 5 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-6 mt-3">
                                <label>Titre du poste</label>
                                <input type="text" name="titres[]" placeholder="Entrer le titre du poste occupé" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Période</label>
                                <input type="text" name="durees[]" placeholder="Entrer la période" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Entreprise</label>
                                <input type="text" name="entreprises[]" placeholder="Entrer la raison sociale de l'entreprise" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Compétence</label>
                                <input type="text" name="competences[]" placeholder="Entrer la compétaence acquise" class="form-control">
                            </div>
                        </div>

                        <hr> 
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 6 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-6 mt-3">
                                <label>Titre du poste</label>
                                <input type="text" name="titres[]" placeholder="Entrer le titre du poste occupé" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Période</label>
                                <input type="text" name="durees[]" placeholder="Entrer la période" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Entreprise</label>
                                <input type="text" name="entreprises[]" placeholder="Entrer la raison sociale de l'entreprise" class="form-control">
                            </div>
                            <div class="col-md-6 mt-3">
                                <label>Compétence</label>
                                <input type="text" name="competences[]" placeholder="Entrer la compétaence acquise" class="form-control">
                            </div>
                        </div>                       
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                        <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Fin Expérience Professionnellle Modal -->

    <!-- Début Spécialité Modal -->
    <div id="modal_specialite" class="modal fade" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Ajouter des spécialités</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form method="POST" action="{{ route('demandeur.savespecialite') }}">
                    @csrf
                    <div class="modal-body">
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 1 <small class="text-danger">(Obligatoire)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Intitulé</label>
                                <input type="text" name="intitules[]" placeholder="Entrer l'intitulé de la spécialité" required class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 2 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Intitulé</label>
                                <input type="text" name="intitules[]" placeholder="Entrer l'intitulé de la spécialité" class="form-control">
                            </div>
                        </div>
                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 3 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Intitulé</label>
                                <input type="text" name="intitules[]" placeholder="Entrer l'intitulé de la spécialité" class="form-control">
                            </div>
                        </div>                        
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                        <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Fin Spécialité Modal -->

    <!-- Début Centre Intérêt Modal -->
    <div id="modal_centreinteret" class="modal fade" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Centre Intérêts, Qualités & Langues</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form method="POST" action="{{ route('demandeur.savecentreinteret') }}">
                    @csrf
                    <div class="modal-body">
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 1 <small class="text-danger">(Obligatoire)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Intitulé</label>
                                <input type="text" name="centreinterets[]" placeholder="Entrer l'intitulé" required class="form-control">
                            </div>
                        </div>

                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 2 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Intitulé</label>
                                <input type="text" name="centreinterets[]" placeholder="Entrer l'intitulé" class="form-control">
                            </div>
                        </div>
                        <hr>
                        <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Ligne 3 <small class="">(Facultatif)</small></h6>
                        <div class="row" style="background:#ccc; padding-bottom: 6px;">
                            <div class="col-md-12">
                                <label>Intitulé</label>
                                <input type="text" name="centreinterets[]" placeholder="Entrer l'intitulé" class="form-control">
                            </div>
                        </div>                        
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                        <button class="btn btn-primary" type="submit"><i class="icon-checkmark3 font-size-base mr-1"></i> Enregistrer</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Fin Centre Intérêt Modal -->

    <!-- Début Générer CV Modal -->
    <div id="modal_generercv" class="modal fade" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;Générer le CV en PDF</h5>
                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                </div>
                <form method="POST" action="{{ route('demandeur.generercv') }}" id="cv-form" enctype="multipart/form-data">
                    @csrf
                    <div class="modal-body">
                        <div class="row" style="background:#ccc; padding-bottom: 10px;">
                            <div class="col-md-12 mt-2">
                                <label>Fonction actuelle</label>
                                <input type="text" name="fonction" required class="form-control" placeholder="Entrer votre fonction actuelle" onkeyup="this.value=this.value.toUpperCase()">
                            </div>
                            <div class="col-md-12 mt-3">
                                <label>Âge</label>
                                <input type="text" name="age" required class="form-control" placeholder="Entrer votre âge actuelle" onkeypress="isInputNumber(event)">
                            </div>
                            <div class="col-md-12 mt-3">
                                <label>Téléphone 2</label>
                                <input type="text" name="telephone2" class="form-control" placeholder="Entrer un deuxième numéro de téléphone" onkeypress="isInputNumber(event)">
                            </div>
                            <div class="col-md-12 mt-3">
                                <label>Situation matrimoniale</label>
                                <input type="text" name="situation" required class="form-control" placeholder="Entrer votre situation matrimoniale">
                            </div>
                            <div class="col-md-12 mt-3 mb-10">
                                <label>Photo de CV</label>
                                <input type="file" name="file" class="form-control" id="cv-file">
                                <div id="cv-file-error" class="text-danger" style="font-size:10px"></div>
                            </div>
                        </div>                       
                    </div>

                    <div class="modal-footer">
                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                        <button class="btn btn-primary" type="submit" id="submit-button"><i class="icon-checkmark3 font-size-base mr-1"></i> Générer le CV</button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    <!-- Fin Générer CV Modal -->

    <script>
        function isInputNumber(evt){
        
            var ch = String.fromCharCode(evt.which);
            
            if(!(/[0-9]/.test(ch))){
                evt.preventDefault();
            }        
        } 
        $('.supprimerformation').click(function() {
            var formationname = $(this).attr('data-name');
            var formationsupurl = $(this).attr('data-url');
            Swal.fire({
                title: 'ÊTES-VOUS SÛRS ?',
                text: "Vous êtes sur le point de supprimer la formation "+formationname+" !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Valider',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                window.location = ""+formationsupurl+""
                Swal.fire(
                    'SUPPRIMER !',
                    'Formation supprimée avec succès !',
                    'success'
                )
                }
            })
        });

        $('.supprimerexperiencepro').click(function() {
            var formationname = $(this).attr('data-name');
            var formationsupurl = $(this).attr('data-url');
            Swal.fire({
                title: 'ÊTES-VOUS SÛRS ?',
                text: "Vous êtes sur le point de supprimer la formation "+formationname+" !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Valider',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                window.location = ""+formationsupurl+""
                Swal.fire(
                    'SUPPRIMER !',
                    'Formation supprimée avec succès !',
                    'success'
                )
                }
            })
        });

        $('.supprimerspecialite').click(function() {
            var formationname = $(this).attr('data-name');
            var formationsupurl = $(this).attr('data-url');
            Swal.fire({
                title: 'ÊTES-VOUS SÛRS ?',
                text: "Vous êtes sur le point de supprimer la formation "+formationname+" !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Valider',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                window.location = ""+formationsupurl+""
                Swal.fire(
                    'SUPPRIMER !',
                    'Formation supprimée avec succès !',
                    'success'
                )
                }
            })
        });

        $('.supprimercentreinteret').click(function() {
            var centreinteretname = $(this).attr('data-name');
            var centreinteretsupurl = $(this).attr('data-url');
            Swal.fire({
                title: 'ÊTES-VOUS SÛRS ?',
                text: "Vous êtes sur le point de supprimer centre d'intérêt "+centreinteretname+" !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#d33',
                cancelButtonColor: '#3085d6',
                confirmButtonText: 'Valider',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                window.location = ""+centreinteretsupurl+""
                Swal.fire(
                    'SUPPRIMER !',
                    'Centre d\'Intérêt supprimé avec succès !',
                    'success'
                )
                }
            })
        });
    </script>
    <script>
        // Vérifie que le fichier a une extension valide avant soumission du formulaire
        document.getElementById("cv-form").addEventListener("submit", function(event) {
            const allowedExtensions = ["png", "jpg", "jpeg"];
            const fileInput = document.getElementById("cv-file");
            const fileError = document.getElementById("cv-file-error");

            if (fileInput.value) {
                const extension = fileInput.value.split('.').pop().toLowerCase();
                if (!allowedExtensions.includes(extension)) {
                    fileError.textContent = "Le fichier doit être au format PNG, JPG ou JPEG.";
                    event.preventDefault();
                } else {
                    fileError.textContent = "";
                }
            }
        });
    </script>
@endsection