@extends('layouts.app')
@section('title')
    Postuler à l'offre : <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('content')
<script type="text/javascript" src="http://ajax.aspnetcdn.com/ajax/jquery.validate/1.13.1/jquery.validate.js"></script>
<script type="text/javascript" src="http://ajax.aspnetcdn.com/ajax/jquery.validate/1.13.1/additional-methods.js"></script>
<style>
    .login-lien a{
        color: orange;
        font-size: 20px;
        font-weight: bold;
    }
    .login-lien a:hover{
        color: green;
    }
    #personal_information, #company_information{
        display:none;
    }
    .has-error{
        color: red !important;
        font-style: italic;
        margin-top: 3px;
    }
    .error {
        color: red !important;
    }
</style>
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Postuler à l'offre : <?php echo html_entity_decode($offre->offretitre) ?></h1>
                </div>                
            </div>
        </div>
    </div>
</div>
<section class="bg-light py-5 position-relative">
    <div class="container">
        <div class="row">            
            <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">                
                <div class="bg-white rounded mb-4">
                    <div class="jb-apply-form bg-white rounded py-3 px-4 box-static">
	                    <form class="_apply_form_form" method="POST" action="{{ route('register') }}" id="myform" enctype="multipart/form-data">   
	                        @csrf  
	                        <input type="hidden" name="code" value="3">
	                        <fieldset id="account_information" class="">
	                            <legend class="text-center text-uppercase" style="font-weight:bold">Etape 1 : Information Personnelle</legend><hr>
	                            <div class="row">
	                                <div class="col-md-6">                      
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 medium">Nom <span style="color:red">*</span></label>
	                                        <input type="text" class="form-control" id="nom" name="nom" placeholder="Entrer votre nom" onkeyup="this.value=this.value.toUpperCase()">
	                                    </div>
	                                </div>
	                                <div class="col-md-6">                      
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 medium">Prénoms <span style="color:red">*</span></label>
	                                        <input type="text" class="form-control" id="prenoms" name="prenoms" placeholder="Entrer votre prénoms" onkeyup="this.value=this.value.toUpperCase()">
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1">Genre <span style="color:red;">*</span></label>
	                                        <select name="genre" required class="form-control" id="genre">
	                                            <option value="" disabled selected style="">Choisir un genre</option>
	                                            <option value="F" {{ old('genre') == 'F' ? 'selected' : '' }}>Feminin</option>
	                                            <option value="H" {{ old('genre') == 'H' ? 'selected' : '' }}>Masculin</option>
	                                        </select>
	                                    </div>
	                                </div>                                 
	                                <div class="col-md-6">                      
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 medium">Téléphone <span style="color:red">*</span></label>
	                                        <input type="text" class="form-control" id="telephone" name="telephone" placeholder="Numéro de Téléphone" onkeypress="isInputNumber(event)" onblur="checkPhoneNumberExists(this.value)">
	                                    </div>
	                                </div>
	                                <div class="col-md-6">                      
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 medium">Date de naissance <span style="color:red">*</span> <small>Ayez ou moins 18 ans</small></label>
	                                        <input type="date" class="form-control" id="datenaissance" max="{{$datesources->format('Y-m-d')}}" name="datenaissance" onblur="verifierValeur(this.value)">
	                                        <div id="messageErreur"></div>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1">Lieu de naissance <span style="color:red;">*</span></label>
	                                        <input type="text" class="form-control" id="lieunaissance" name="lieunaissance" placeholder="Lieu de naissance" onkeyup="this.value=this.value.toUpperCase()">
	                                    </div>
	                                </div>                               
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Nationalité <span style="color:red">*</span></label> 
	                                        <select class="form-control" id="pays_id" name="pays_id">
	                                            <option value="" disabled selected style="">Choisissez une nationalité</option>
	                                            @foreach($paysliste as $pays)
	                                                <option value="{{ $pays->pays_id }}">{{ $pays->nom_fr }}</option>
	                                            @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Lieu de résidence <span style="color:red">*</span></label>
	                                        <select class="form-control" name="region_id" id="region_id">
	                                            <option value="" disabled selected style="">Choisissez une région</option>
	                                             @foreach($regions as $region)
	                                            <option value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
	                                            @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Département</label>
	                                        <input type="text" class="form-control" name="departement" id="departement" placeholder="Département">
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Commune</label>
	                                        <input type="text" class="form-control" name="commune" id="commune" placeholder="Commune">
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Handicap <span style="color:red">*</span></label>
	                                        <select class="form-control" name="handicap" id="handicap">
	                                            <option value="" disabled selected style="">Avez-vous un handicap ?</option>
	                                            <option value="OUI">OUI</option>
	                                            <option value="NON">NON</option>
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6" id="typehandicap" style="display: none;">
	                                    <label class="text-dark mb-1 ft-medium medium" for="new_diplome">Votre type d'handicap <span style="color:red;">*</span></label>
	                                    <input type="text" id="type_handicap" name="type_handicap" class="form-control" placeholder="Entrer votre type d'handicap" onkeyup="this.value=this.value.toUpperCase()">
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Situation matrimoniale <span style="color:red">*</span></label>
	                                        <select class="form-control" name="stituationmatrimoniale" id="stituationmatrimoniale">
	                                            <option value="" disabled selected style="">Quelle est votre situation ?</option>
	                                            <option value="CELIBATAIRE">CELIBATAIRE</option>
	                                            <option value="MARIE(E)">MARIE(E)</option>
	                                            <option value="DIVORCE(E)">DIVORCE(E)</option>
	                                            <option value="VEUF(E)">VEUF(E)</option>
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Nombre d'enfant</label>
	                                        <input type="text" class="form-control" name="nombreenfant" id="nombreenfant" placeholder="Nombre d'enfant" onkeypress="isInputNumber(event)">
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Emploi souhaité</label>
	                                        <input type="text" class="form-control" name="emploisouhaite" id="emploisouhaite" placeholder="Emploi souhaité">
	                                    </div>
	                                </div>
	                                <div class="col-md-6" id="cni">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Pièce d'identité(CIN ou passport ou nationalité)</label>
	                                        <input type="file" class="form-control" name="pieceidentite" id="pieceidentite" required>
	                                    </div>
	                                </div>
	                                <div class="col-md-6" id="etranger">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Pour les étrangers(Permis de séjour, carte....)</label>
	                                        <input type="file" class="form-control" name="pieceetranger" id="pieceetranger" required>
	                                    </div>
	                                </div>
	                            </div>
	                            <p><center><a class="btn btn-md theme-bg text-light next">Suivant <i class="lni lni-arrow-right-circle ml-2"></i></a></center></p>
	                        </fieldset>
	                        <fieldset id="company_information" class="">
	                            <legend class="text-center text-uppercase" style="font-weight:bold">Etape 2 : Information Professionnelle</legend><hr>
	                            <div class="row">
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1">Diplôme <span style="color:red;">*</span></label>
	                                        <select name="diplome_id" id="diplome_id" required class="form-control">
	                                            <option value="" disabled selected style="">Choisir un diplôme</option>
	                                            @foreach($diplomes as $diplome)
	                                                <option value="{{ $diplome->diplome_id }}">{{ $diplome->diplomelib }}</option>
	                                            @endforeach
	                                        </select>
	                                    </div> 
	                                </div>
	                                <div class="col-md-6" id="diplome" style="display: none;">
	                                    <label class="text-dark mb-1 ft-medium medium" for="new_diplome">Votre diplôme <span style="color:red;">*</span></label>
	                                    <input type="text" id="new_diplome" required name="new_diplome" class="form-control" placeholder="Entrer votre diplôme obtenu" onkeyup="this.value=this.value.toUpperCase()">
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1">Filière <span style="color:red;">*</span></label>
	                                        <select name="metier_id" id="metier_id" required class="form-control">
	                                            <option value="" disabled selected style="">Choisir une filière</option>
	                                            @foreach($metiers as $metier)
	                                                <option value="{{ $metier->metier_id }}">{{ $metier->metier_libelle }}</option>
	                                            @endforeach
	                                        </select>
	                                    </div> 
	                                </div>
	                                <div class="col-md-6" id="metier" style="display: none;">
	                                    <label class="text-dark mb-1 ft-medium medium" for="new_diplome">Votre filière <span style="color:red;">*</span></label>
	                                    <input type="text" id="new_metier" required name="new_metier" class="form-control" placeholder="Entrer votre filière pratiquée" onkeyup="this.value=this.value.toUpperCase()">
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Catégorie Professionnelle <span style="color:red">*</span></label>
	                                        <select class="form-control" name="catepro_id" id="catepro_id">
	                                          <option value="" disabled selected style="">Choisissez une catégorie professionnelle</option>
	                                          @foreach($categories as $categorie)
	                                            <option value="{{ $categorie->catepro_id }}">{{ $categorie->catepro_lib }}</option>
	                                          @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Type de demandeur <span style="color:red">*</span></label>
	                                        <select class="form-control" name="situation_id" id=situation_id>
	                                          <option value="" disabled selected style="">Choisissez un type de demandeur</option>
	                                          @foreach($typedemandeur as $demandeur)
	                                            <option value="{{ $demandeur->situation_id }}" >{{ $demandeur->situation_lib }}</option>
	                                          @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Niveau d'instruction <span style="color:red">*</span></label>
	                                        <select class="form-control" name="niveau_id" id="niveau_id">
	                                          <option value="" disabled selected style="">Choisissez un niveau d'instruction</option>
	                                          @foreach($niveaux as $niveau)
	                                            <option value="{{ $niveau->niveau_id }}">{{ $niveau->niveau_lib }}</option>
	                                          @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Langue internationale</label>
	                                        <select class="form-control" name="langueinter_id" id="langueinter_id">
	                                          <option value="" disabled selected style="">Choisissez une langue internationale</option>
	                                          @foreach($langueinter as $langue)
	                                          <option value="{{ $langue->langueinter_id }}">{{ $langue->langueinter_lib }}</option>
	                                          @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6" id="langueinter" style="display: none;">
	                                    <label class="text-dark mb-1 ft-medium medium" for="new_diplome">Votre langue internationale <span style="color:red;">*</span></label>
	                                    <input type="text" id="new_langueinter" required name="new_langueinter" class="form-control" placeholder="Entrer votre langue internationale parlée" onkeyup="this.value=this.value.toUpperCase()">
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Langue locale <span style="color:red">*</span></label>
	                                        <select class="form-control" name="languelocal_id" id="languelocal_id">
	                                          <option value="" disabled selected style="">Choisissez une langue locale</option>
	                                          @foreach($languelocale as $locale)
	                                          <option value="{{ $locale->languelocal_id }}">{{ $locale->languelocal_lib }}</option>
	                                          @endforeach
	                                        </select>
	                                    </div>
	                                </div>
	                                <div class="col-md-6" id="languelocal" style="display: none;">
	                                    <label class="text-dark mb-1 ft-medium medium" for="new_diplome">Votre langue locale <span style="color:red;">*</span></label>
	                                    <input type="text" id="new_languelocal" required name="new_languelocal" class="form-control" placeholder="Entrer votre langue locale parlée" onkeyup="this.value=this.value.toUpperCase()">
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Année d'expérience</label>
	                                        <input type="text" class="form-control" id="experience" name="experience" placeholder="Votre année d'expérence" onkeypress="isInputNumber(event)">
	                                    </div>                            
	                                </div>     
	                            </div>
	                            <div class="jbd-02 px-3 py-3 br-top">
	                                <div class="jbd-02-flex d-flex align-items-center justify-content-between">
	                                    <div class="jbd-02-social">
	                                        <p><a class="btn btn-md bg-dark text-light hover-theme" id="previous"><i class="lni lni-arrow-left-circle mr-2"></i> Précédent</a></p>
	                                    </div>
	                                    <div class="jbd-02-aply">
	                                        <div class="jbl_button mb-2">
	                                            <a class="btn btn-md theme-bg text-light fs-sm ft-medium next">Suivant <i class="lni lni-arrow-right-circle ml-2"></i></a>
	                                        </div>
	                                    </div>
	                                </div>
	                            </div>
	                        </fieldset>
	                        <fieldset id="personal_information" class="">
	                            <legend class="text-center text-uppercase" style="font-weight:bold">Etape 3 : Information Compte</legend><hr>
	                            <div class="row">
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Adresse mail</label>
	                                        <input type="email" class="form-control" id="email" name="email" placeholder="Votre adresse mail">
	                                    </div>                            
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Photo de carte</label>
	                                        <input type="file" class="form-control" id="profil_photo" name="profil_photo">
	                                    </div>                            
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Mot de passe</label>
	                                        <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe">
	                                    </div>                            
	                                </div>
	                                <div class="col-md-6">
	                                    <div class="form-group">
	                                        <label class="text-dark mb-1 ft-medium medium">Confirmer mot de passe</label>
	                                        <input type="password" class="form-control" id="conf_password" name="conf_password" placeholder="Confirmer mot de passe">
	                                    </div>
	                                </div>
	                            </div>
	                            <div class="jbd-02 px-3 py-3 br-top">
	                                <div class="jbd-02-flex d-flex align-items-center justify-content-between">
	                                    <div class="jbd-02-social">
	                                        <p><a class="btn btn-md bg-dark text-light hover-theme" id="previous"><i class="lni lni-arrow-left-circle mr-2"></i> Précédent</a></p>
	                                    </div>
	                                    <div class="jbd-02-aply">
	                                        <div class="jbl_button mb-2">
	                                            <button type="submit" class="btn btn-md theme-bg text-light fs-sm ft-medium">Valider <i class="fas fa-check small ml-2"></i></button>
	                                        </div>
	                                    </div>
	                                </div>
	                            </div>
	                        </fieldset>                                                   
	                    </form>
                    </div>
                </div>                
            </div>
            
            <!-- Sidebar -->
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
                <div class="jb-apply-form bg-white rounded py-3 px-4 box-static">
					<legend class="text-center">Intéressé par ce poste ?</legend><hr>
                    
                    <form class="_apply_form_form" action="{{ route('login') }}" method="POST">
                        @csrf
                        <input type="hidden" name="offre_id" value="{{ $offre->offre_id }}">
                        <div class="form-group">
                            <label class="text-dark mb-1 ft-medium medium">Votre Email</label>
                            <input id="login" type="text" class="form-control @error('login') is-invalid @enderror" name="login" value="{{ old('login') }}" required autofocus placeholder="Entrer votre adresse email ou le numéro de téléphone">
                        </div>
                        
                        <div class="form-group">
                            <label class="text-dark mb-1 ft-medium medium">Mot de passe</label>
                            <input type="password" class="form-control" name="password" placeholder="Mot de passe" required>
                        </div>
                        
                        <div class="form-group">
                            <button type="submit" class="btn btn-md rounded theme-bg text-light ft-medium fs-sm full-width">Postuler pour ce travail</button>
                        </div>
                        
                    </form>
                </div>
            </div>
            
        </div>
    </div>
</section>
<!-- ============================ Job Details End ================================== -->
<script>
    function isInputNumber(evt){
        
        var ch = String.fromCharCode(evt.which);
        
        if(!(/[0-9]/.test(ch))){
            evt.preventDefault();
        }        
    } 
    
    function verifierValeur() {
        // récupération de la date de naissance entrée par l'utilisateur
        var datenaissance = document.getElementById("datenaissance").value;

        // conversion de la date de naissance en objet Date
        var dateNaissanceObj = new Date(datenaissance);

        // calcul de l'âge de l'utilisateur en années
        var age = (new Date().getTime() - dateNaissanceObj.getTime()) / (1000 * 60 * 60 * 24 * 365.25);

        // vérification que l'utilisateur a au moins 10 ans
        if (age < 10) {
            // affichage d'un message d'erreur
            alert("Vous devez avoir au moins 10 ans pour continuer.");
            document.getElementById("datenaissance").value = "";
            // annulation de l'envoi du formulaire
            return false;
        }
        return true;
    } 
</script>
<script>
    $(document).ready(function() {
        $('#pays_id').change(function() {
            var pays_id = $(this).val();
            //alert(pays_id);

            if(pays_id == 127){
                $('#cni').show();
                $('#etranger').hide();
            }else{
                $('#etranger').show();
                $('#cni').hide();
            }
        });
    });

    $(document).ready(function() {
        $('#handicap').change(function() {
            var handicap = $(this).val();
            //alert(handicap);

            if(handicap == "OUI"){
                $('#typehandicap').show();
            }else{
                $('#typehandicap').hide();
            }
        });
    });

    $(document).ready(function() {
        $('#diplome_id').change(function() {
            var diplome_id = $(this).val();
            //alert(diplome_id);

            if(diplome_id == 27){
                $('#diplome').show();
            }else{
                $('#diplome').hide();
            }
        });
    });

    $(document).ready(function() {
        $('#metier_id').change(function() {
            var metier_id = $(this).val();
            //alert(metier_id);

            if(metier_id == 51){
                $('#metier').show();
            }else{
                $('#metier').hide();
            }
        });
    });

    $(document).ready(function() {
        $('#langueinter_id').change(function() {
            var langueinter_id = $(this).val();
            //alert(langueinter_id);

            if(langueinter_id == 13){
                $('#langueinter').show();
            }else{
                $('#langueinter').hide();
            }
        });
    });

    $(document).ready(function() {
        $('#languelocal_id').change(function() {
            var languelocal_id = $(this).val();
            //alert(languelocal_id);

            if(languelocal_id == 15){
                $('#languelocal').show();
            }else{
                $('#languelocal').hide();
            }
        });
    });
</script>
<script type = "text/javascript">
    $(document).ready(function () {

        // Custom method to validate nom
        /*$.validator.addMethod("nomRegex", function (value, element) {
            return this.optional(element) || /^[a-zA-Z0-9]*$/i.test(value);
        }, "Le nom d'utilisateur ne doit contenir que des lettres, des chiffres");*/

      $(".next").click(function (){
         var form = $("#myform");
         form.validate({
            errorElement: 'span',
            errorClass: 'help-block',
            highlight: function (element, errorClass, validClass) {
               $(element).closest('.form-group').addClass("has-error");
            },
            unhighlight: function (element, errorClass, validClass) {
               $(element).closest('.form-group').removeClass("has-error");
            },
            rules: {
               nom: {
                  required: true,
                  minlength: 4,
               },
               prenoms: {
                  required: true,
                  minlength: 4,
               },
               genre: {
                  required: true,
                  minlength: 1,
               },
               datenaissance: {
                  required: true,
                  minlength: 6,
               },
               lieunaissance: {
                  required: true,
               },
               telephone: {
                  required: true,
               },
               metier_id: {
                   required: true,
               },
               diplome_id: {
                   required: true,
               },
               region_id: {
                   required: true,
               },
               pays_id: {
                   required: true,
               },
                new_diplome: {
                  required: true,
                  minlength: 4,
                },
                new_metier: {
                  required: true,
                  minlength: 4,
                },
                new_langueinter: {
                  required: true,
                  minlength: 4,
                },
                new_languelocal: {
                  required: true,
                  minlength: 4,
                },
               stituationmatrimoniale: {
                   required: true,
               },
               handicap: {
                   required: true,
               },
               type_handicap: {
                   required: true,
                   minlength: 4,
                },
               catepro_id: {
                   required: true,
                },
                situation_id: {
                   required: true,
                },
                experience: {
                   required: true,
                },
                niveau_id: {
                   required: true,
                },
                languelocal_id: {
                   required: true,
                },                
                typeinscription_id: {
                   required: true,
                },
               password: {
                  required: true,
                  minlength: 6,
               },
               conf_password: {
                  required: true,
                  equalTo: '#password',
               },
               email: {
                  required: true,
                  minlength: 6,
               },
               profil_photo: {
                  required: true,
                  extension: "png|jpg|jpeg"
               },
               pieceidentite: {
                 required: true,
                  extension: "png|jpg|jpeg"
               },
               pieceetranger: {
                 required: true,
                  extension: "png|jpg|jpeg"
               }

            },
            messages: {
               nom: {
                  required: "Le nom de famille est obligatoire",
                  minlength: "Le nom doit être d'au moins 4 caractères",
               },
               prenoms: {
                  required: "Le prénoms est obligatoire",
                  minlength: "Le prénoms doit être d'au moins 4 caractères",
               },
               genre: {
                  required: "Le genre est obligatoire",
               },
               experience: {
                  required: "L'année d'expérience est obligatoire",
               },
               datenaissance: {
                  required: "La date de naissance est obligatoire",
               },
               lieunaissance: {
                  required: "Le lieu de naissance est obligatoire",
               },
               telephone: {
                  required: "Le numéro de téléphone est obligatoire",
               },
               metier_id: {
                   required: "La filière est obligatoire",
               },
               diplome_id: {
                   required: "Le diplôme est obligatoire",
               },
               region_id: {
                   required: "Le lieu de résidence est obligatoire",
               },
               pays_id: {
                   required: "La nationalité est obligatoire",
               },
               stituationmatrimoniale: {
                   required: "La situation matrimoniale est obligatoire",
               },
               new_diplome: {
                  required: "Votre diplôme est obligatoire",
                  minlength: "Le nom du diplôme doit être d'au moins 4 caractères",
                },
                new_metier: {
                  required: "Votre filière est obligatoire",
                  minlength: "Le nom de la filière doit être d'au moins 4 caractères",
                },
                new_languelocal: {
                  required: "Votre langue locale est obligatoire",
                  minlength: "Le nom de la langue locale doit être d'au moins 4 caractères",
                },
                new_langueinter: {
                  required: "Votre langue internationale est obligatoire",
                  minlength: "Le nom de la langue internationale doit être d'au moins 4 caractères",
                },
               handicap: {
                   required: "La reponse à l'handicap est obligatoire",
               },
               type_handicap: {
                  required: "Le type d'handicap est obligatoire",
                  minlength: "Le nom du type d'handicap doit être d'au moins 4 caractères",
                },
               catepro_id: {
                   required: "La catégorie professionnelle est obligatoire",
                },
                situation_id: {
                   required: "Le type de demandeur est obligatoire",
                },
                niveau_id: {
                   required: "Le niveau d'instruction est obligatoire",
                },
                languelocal_id: {
                   required: "Le langue locale est obligatoire",
                },                
               typeinscription_id: {
                   required: "Le type d'inscription est obligatoire",
                },
               password: {
                  required: "Mot de passe obligatoire",
                  minlength: "Entrer un mot de passe obligatoire d'au moins 6 caractères",
               },
               conf_password: {
                  required: "Mot de passe obligatoire",
                  equalTo: "Le mot de passe ne correspond pas",
               },
               email: {
                  required: "L'adresse mail est obligatoire",
                  minlength: "Entrer une adresse mail d'au moins 6 caractères",
               },
               profil_photo: {
                  required: "Veuillez choisir une photo de carte",
                  extension: "Le fichier doit être une image de type PNG, JPG ou JPEG",
               },
               pieceidentite: {
                    required: "Veuillez choisir une CIN ou passport ou nationalité",
                    extension: "Le fichier doit être une image de type PNG, JPG ou JPEG",
               },
               pieceetranger: {
                    required: "Veuillez choisir un permis de séjour, une carte....",
                    extension: "Le fichier doit être une image de type PNG, JPG ou JPEG",
               }
            }
        });
        if(form.valid() === true){
            if($('#account_information').is(":visible")){
               current_fs = $('#account_information');
               next_fs = $('#company_information');
            }else if($('#company_information').is(":visible")){
               current_fs = $('#company_information');
               next_fs = $('#personal_information');
            }

            next_fs.show();
            current_fs.hide();
        }
      });

      $('#previous').click(function () {
         if ($('#company_information').is(":visible")){
            current_fs = $('#company_information');
            next_fs = $('#account_information');
         } else if ($('#personal_information').is(":visible")){
            current_fs = $('#personal_information');
            next_fs = $('#company_information');
         }
         next_fs.show();
         current_fs.hide();
      });
   }); 

    $(document).ready(function() {
  $('#telephone').on('blur', function() {
    var numeroTelephone = $(this).val();

    // Effectuer ici votre vérification dans la base de données
    // et afficher une alerte si nécessaire
    if (numeroTelephone === 'valeur dans la base de données') {
      alert('Le numéro de téléphone existe dans la base de données !');
    }
  });
});
</script>
<script>
    $(document).ready(function() {
        $('#new_diplome').on('input', function() {
            var inputValue = $(this).val();
            if (inputValue.length < 4) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        });
    });
    $(document).ready(function() {
        $('#new_metier').on('input', function() {
            var inputValue = $(this).val();
            if (inputValue.length < 4) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        });
    });
    $(document).ready(function() {
        $('#new_langueinter').on('input', function() {
            var inputValue = $(this).val();
            if (inputValue.length < 4) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        });
    });
    $(document).ready(function() {
        $('#new_languelocal').on('input', function() {
            var inputValue = $(this).val();
            if (inputValue.length < 4) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        });
    });
    $(document).ready(function() {
        $('#type_handicap').on('input', function() {
            var inputValue = $(this).val();
            if (inputValue.length < 4) {
                $(this).addClass('error');
            } else {
                $(this).removeClass('error');
            }
        });
    });
</script>
@endsection