<?php
    use Carbon\Carbon;
?>
@extends('layouts.appp')

@section('title')
   Information générale 
@endsection

@section('titre')
   Information générale 
@endsection

@section('content')
   <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
   <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
   <div class="container-fluid">
      <div class="col-xl-12">
         <div class="card">
            <div class="card-header">
              <h4 class="card-title"></h4>
            </div>
            <div class="card-body">
                 <!-- Nav tabs -->
                 <div class="default-tab">
                     <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item">
                             <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                         </li>
                         <li class="nav-item">
                             <a class="nav-link" data-toggle="tab" href="#cv"><i class="fa fa-book mr-2"></i> Consulter le CV</a>
                         </li>
                         <li class="nav-item">
                             <a class="nav-link" data-toggle="tab" href="#candidature"><i class="fa fa-graduation-cap mr-2"></i> Liste des candidatures</a>
                         </li>
                     </ul>
                     <div class="tab-content">
                        <div class="tab-pane fade show active" id="infos" role="tabpanel">
                          <div class="pt-4">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="card">
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                    <div class="tab-content">
                                                        <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                            @if($demandeur->profil_photo !=null and $demandeur->profil_photo !="")
                                                                <img class="img-fluid" src="{{ asset('assets/img/profil/'.$demandeur->profil_photo) }}" alt="" style="border: 2px solid #000;" width="250">
                                                            @else
                                                                @if($demandeur->genre == "F")
                                                                    <img class="img-fluid" src="{{ asset('assets/img/profil/femme.png') }}" alt="" style="border: 2px solid #000;">
                                                                @else
                                                                    <img class="img-fluid" src="{{ asset('assets/img/profil/homme.jpg') }}" alt="" style="border: 2px solid #000;">
                                                                @endif
                                                            @endif
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                    <div class="product-detail-content">
                                                        <div class="new-arrival-content pr">
                                                            <p class="text-couleur">Nom & Prénoms : {{ $demandeur->name }} {{ $demandeur->prenoms }}</p>
                                                            <p class="text-couleur">Adresse Email : {{ $demandeur->email }}</p>
                                                            <p class="text-couleur">Téléphone : {{ $demandeur->telephone }}</p>
                                                            <p class="text-couleur">Genre : {{ $demandeur->genre }}
                                                                @if($demandeur->genre =="F")
                                                                    Femme
                                                                @else
                                                                    Homme
                                                                @endif
                                                            </p>
                                                            <p class="text-couleur">Date de naissance :
                                                                @php
                        
                                                                    $date_naissance = $demandeur->datenaissance;

                                                                    $date = Carbon::parse($date_naissance)->locale('fr_FR')->translatedFormat('d F Y');

                                                                    echo $date;
                                                                @endphp
                                                            </p>
                                                            <p class="text-couleur">Lieu de naissance : {{ $demandeur->lieunaissance }}</p>
                                                            @if($pays)<p class="text-couleur">Nationalité : {{ $pays->nom_fr }}</p>@endif
                                                            @if($region)<p class="text-couleur">Lieu de résidence : {{ $region->region_nom }}</p>@endif
                                                            <p class="text-couleur">Département : {{ $demandeur->departement }}</p>
                                                            <p class="text-couleur">Situation matrimoniale : {{ $demandeur->situationmatrimoniale }}</p>
                                                            <p class="text-couleur">Nombre d'enfant : {{ $demandeur->nombreenfant }}</p>
                                                            <p class="text-couleur">Handicap : 
                                                                @if($demandeur->handicap == "OUI")
                                                                    {{ $demandeur->type_handicap }}
                                                                @else
                                                                    Aucun handicap
                                                                @endif
                                                            </p>
                                                            <p class="text-couleur">Commune : {{ $demandeur->commune }}</p>
                                                            <p class="text-couleur">Quartier/Village : {{ $demandeur->village_quart }}</p>
                                                            <p class="text-couleur">Emploi souhaité : <?php echo html_entity_decode($demandeur->emploisouhaite) ?></p>                                                                    
                                                        </div>
                                                    </div>
                                                </div>
                                            </div><hr>                                                 
                                            <h2 class="text-center mt-3">Autres informations</h2>
                                            <div class="row mt-3">
                                                <div class="col-md-6">
                                                    @if($metier)
                                                        <p class="text-couleur">Filière :
                                                            @if($metier->metier_id == 51)
                                                                {{ $demandeur->new_metier }}
                                                            @else
                                                                {{ $metier->metier_libelle }}
                                                            @endif
                                                        </p>
                                                    @endif
                                                    @if($diplome)
                                                        <p class="text-couleur">Diplôme : 
                                                            @if($diplome->diplome_id == 27)
                                                                {{ $demandeur->new_diplome }}
                                                            @else
                                                                {{ $diplome->diplomelib }}
                                                            @endif
                                                        </p>
                                                    @endif
                                                    @if($niveauintruction)<p class="text-couleur">Niveau d'instruction : {{ $niveauintruction->niveau_lib }}</p>@endif
                                                    @if($languelocale)
                                                        <p class="text-couleur">Langue Locale : 
                                                            @if($languelocale->languelocal_id == 15)
                                                                {{ $demandeur->new_languelocal }}
                                                            @else
                                                                {{ $languelocale->languelocal_lib }}
                                                            @endif
                                                        </p>
                                                    @endif
                                                </div>
                                                <div class="col-md-6">
                                                    @if($categoriepro)<p class="text-couleur">Categorie Professionnelle : {{ $categoriepro->catepro_lib }}</p>@endif
                                                    @if($typedemandeur)<p class="text-couleur">Type demandeur : {{ $typedemandeur->situation_lib }}</p>@endif
                                                    @if($langueinter)
                                                        <p class="text-couleur">Langue internationale : 
                                                            @if($langueinter->langueinter_id == 13)
                                                                {{ $demandeur->new_langueinter }}
                                                            @else
                                                                {{ $langueinter->langueinter_lib }}
                                                            @endif
                                                        </p>
                                                    @endif
                                                    <p class="text-couleur">Année d'expérience : {{ $demandeur->experience }}</p>
                                                </div>
                                            </div>                                                   
                                        </div>
                                    </div>
                                </div>
                            </div>
                          </div>
                        </div>
                        <div class="tab-pane fade" id="cv">
                          <div class="pt-4">
                              <div class="row">
                                 <div class="col-md-12">
                                      <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des formations</h6>
                                      @foreach($formations as $formation)
                                          <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $formation->formation_diplome }}</small><br>
                                      @endforeach
                                      <br>
                                 </div>
                                 <div class="col-md-12">
                                      <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des expériences professionnelles</h6>
                                      @foreach($experiencepro as $experience)
                                          <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $experience->experiencepro_titre }}</small><br>
                                      @endforeach
                                      <br>
                                 </div>
                                 <div class="col-md-12">
                                      <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des spécialités</h6>
                                      @foreach($specialites as $specialite)
                                          <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $specialite->specialite_intitule }}</small><br>
                                      @endforeach
                                      <br>
                                 </div>
                                 <div class="col-md-12">
                                   <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des atouts, centre d'intérêt & qualité</h6>
                                   @foreach($centreint_langue as $centreinteret)
                                       <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $centreinteret->centreint_langue_intitule }}</small><br>
                                   @endforeach
                                 </div>
                              </div>
                          </div>
                        </div>
                        <div class="tab-pane fade" id="candidature">
                           <div class="pt-4">
                              <div class="table-responsive">
                                  <table id="example3" class="display min-w850">
                                      <thead>
                                          <tr>
                                              <th>Titre de l'offre</th>
                                              <th class="text-center">Date création</th>
                                              <th class="text-center">Status</th>
                                          </tr>
                                      </thead>
                                      <tbody>
                                          @foreach($candidatures as $candidature)
                                              <tr>
                                                  <td>
                                                      <div class="cats-box rounded bg-white d-flex align-items-center">
                                                          <div class="cats-box-caption px-2">
                                                              <h4 class="fs-md mb-0 ft-medium">{{ $candidature->offretitre }}</h4>
                                                              <div class="d-block mb-2 position-relative">
                                                                  <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>{{ $candidature->typecontratlib }}</span>
                                                              </div>
                                                          </div>
                                                      </div>
                                                  </td>
                                                  <td class="text-center">{{ \Carbon\Carbon::parse($candidature->candidature_datecrea)->format('d/m/Y') }}</td>
                                                  <td class="text-center">
                                                      @if($candidature->candidature_statut == "BROUILLON")
                                                          <span class="badge badge-danger light text-info">Brouillon</span>
                                                      @elseif($candidature->candidature_statut == "VALIDE")
                                                          <span class="badge badge-warning light text-info">Active</span>
                                                       @elseif($candidature->candidature_statut == "APPROUVE")
                                                          <span class="badge badge-success light text-info">Approuvé</span>
                                                      @endif
                                                  </td>                                              
                                              </tr>
                                          @endforeach
                                      </tbody>
                                  </table>
                              </div>
                          </div>
                        </div>
                     </div>
                 </div>
            </div>
         </div>
     </div>
   </div>
@endsection