@extends('layouts.app')
@section('title')
    <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4"><?php echo html_entity_decode($offre->offretitre) ?></h1>
                </div>                
            </div>
        </div>
    </div>
</div>
@if(!empty($offre))
<section class="bg-light py-5 position-relative">
    <div class="container">
        <div class="row">
            
            <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
            
                <div class="bg-white rounded px-3 py-4 mb-4">
                    <div class="jbd-01 d-flex align-items-center justify-content-between">
                        <div class="jbd-flex d-flex align-items-center justify-content-start">
                            <div class="jbd-01-thumb">
                                <img src="{{ asset('assets/img/entreprise/'.$user->entreprise_logo) }}" class="img-fluid" alt="" style="width:100px !important; height: 100px !important;">
                            </div>
                            <div class="jbd-01-caption pl-3">
                                <div class="tbd-title"><h4 class="mb-0 ft-medium fs-md"><?php echo html_entity_decode($user->raisonsociale) ?></h4></div>
                                <div class="jbl_location mb-3"><span><i class="lni lni-briefcase mr-1"></i><span class="badge badge-success">{{ $offre->contrat->typecontratlib }}</span></span></div>
                                <div class="jbl_info01">
                                    @if($metier !=null)
                                        <span class="px-2 py-1 ft-medium medium rounded theme-cl theme-bg-light mr-2">{{ $metier->metier_libelle }}</span>                                             
                                    @endif   
                                </div>
                            </div>
                        </div>
                        <div class="jbd-01-right text-right hide-1023">
                            <div class="jbd-02-aply">
                                @if($offre->offre_soumission == "PAR MAIL")
                                    <div class="jbl_button mb-2"><a href="mailto::{{ $offre->offre_liensoumission }}" target="_blank" class="btn rounded theme-bg-light theme-cl fs-sm ft-medium">Postuler à l'offre</a></div>
                                @elseif($offre->offre_soumission == "LIEN SITE WEB")
                                    <div class="jbl_button mb-2"><a href="{{ $offre->offre_liensoumission }}" target="_blank" class="btn rounded theme-bg-light theme-cl fs-sm ft-medium">Postuler à l'offre</a></div>
                                @else
                                    <div class="jbl_button mb-2"><a href="{{ route('postuler.offre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn rounded theme-bg-light theme-cl fs-sm ft-medium">Postuler à l'offre</a></div>
                                @endif
                            </div>
                        </div>
                    </div>
                    @if($offre->offre_entreprisetiers !=null)
                        <br>
                        <hr>
                        <h4 class="mb-0 ft-medium fs-md">Offre d'emploi de : <strong style="font-style:italic;">{{ $offre->offre_entreprisetiers }}</strong></h4>
                    @endif
                    @if($user->description !=null)
                        <hr>                    
                        <h3>Description</h3><hr>
                        <p><?php echo html_entity_decode($user->description) ?></p>
                    @endif
                </div>
                
                <div class="bg-white rounded mb-4">
                    <div class="jbd-01 px-3 py-4">
                        <div class="jbd-details mb-4">
                            @if($offre->offredescription !=null)
                                <h5>Description</h5><hr>
                                <p>
                                    <?php echo html_entity_decode($offre->offredescription) ?>
                                </p>
                            @endif
                        </div>
                        
                        <div class="jbd-details mb-3">
                            @if($offre->offre_mission !=null)
                                <p>
                                    <?php echo html_entity_decode($offre->offre_mission) ?>
                                </p>
                                <p></p>
                            @endif                         
                        </div>
                        
                        <div class="jbd-details mb-4">
                            @if($offre->offre_profil !=null)
                                <p>
                                    <?php echo html_entity_decode($offre->offre_profil) ?>
                                </p>
                            @endif
                            <div class="other-details">
                                @if($offre->metier_id !=null)<div><p><span style="font-weight:bold">Secteur d´activité : </span>{{$metier->metier_libelle}}</p></div>@endif
                                @if($offre->typecontrat_id !=null)<div><p><span style="font-weight:bold">Type de contrat : </span>{{$offre->typecontratlib}}</p></div>@endif
                                @if($offre->offre_anneeexperience !=null)<div><p><span style="font-weight:bold">Niveau d'expérience : </span>{{$offre->offre_anneeexperience}}</p></div>@endif
                                <div><p><span style="font-weight:bold">Niveau d'études minimum : </span>{{$offre->diplome->diplomelib}}</p></div>
                                @if($offre->offrenombreposte !=null)<div><p><span style="font-weight:bold">Nombre de poste : </span>{{$offre->offrenombreposte}}</p></div>@endif
                                <strong>Region : </strong><div class="jb-list-01-title d-inline">
                                    @foreach($offre->regions as $region)
                                        <span class="mr-2 mb-2 d-inline-flex px-2 py-1 rounded {{ $region->region_couleur }} text-capitalize">{{ $region->region_nom }}</span>
                                    @endforeach 
                                </div>
                            </div>
                        </div>
                        <blockquote class="alert-dark" style="padding:12px">
                            @if($offre->offre_dossier !=null)
                                <p class="text"><?php echo html_entity_decode($offre->offre_dossier) ?></p>
                            @endif
                        </blockquote>                       
                    </div>
                    
                    <div class="jbd-02 px-3 py-3 br-top">
                        <div class="jbd-02-flex d-flex align-items-center justify-content-between">
                            <div class="jbd-02-social">
                                <ul class="jbd-social">
                                    <li><a href="https://www.facebook.com/profile.php?id=100063818243158&amp;mibextid=LQQJ4d" target="_blank"><i class="ti-facebook"></i></a></li>
                                    <li><a href="https://twitter.com/nigeranpe?s=11&amp;t=uohPwLttnCBCpWU1B8bqmA " target="_blank"><i class="ti-twitter"></i></a></li>
                                    <li><a href="mailto:anpe.niger16@gmail.com" target="_blank"><i class="ti-google"></i></a></li>
                                    <li><a href="https://www.linkedin.com/company/agence-nationale-pour-la-promotion-de-l-emploi/" target="_blank"><i class="ti-linkedin"></i></a></li>
                                    <li><a href="https://www.instagram.com/p/CpChK3Usqlb/?utm_source=ig_web_copy_link" target="_blank"><i class="ti-instagram"></i></a></li>
                                </ul>
                            </div>
                            <div class="jbd-02-aply">
                                @if($offre->offre_soumission == "PAR MAIL")
                                    <div class="jbl_button mb-2"><a href="mailto::{{ $offre->offre_liensoumission }}" target="_blank" class="btn btn-md rounded theme-bg text-light theme-cl fs-sm ft-medium">Postuler à l'offre</a></div>
                                @elseif($offre->offre_soumission == "LIEN SITE WEB")
                                    <div class="jbl_button mb-2"><a href="{{ $offre->offre_liensoumission }}" class="btn btn-md rounded theme-bg text-light theme-cl fs-sm ft-medium">Postuler à l'offre</a></div>
                                @else
                                    <div class="jbl_button mb-2"><a href="{{ route('postuler.offre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn btn-md rounded theme-bg text-light theme-cl fs-sm ft-medium">Postuler à l'offre</a></div>
                                @endif
                            </div>
                        </div> 
                    </div>
                </div>                
            </div>            
        </div>
    </div>
</section>
@endif
@if($offres->count() > 0)
<section class="space min">
    <div class="container"> 
        <h1 class="text-center mb-4">Offres Similaires</h1>
        <div class="row align-items-center">
            @foreach($offres as $offre)
                <div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
                    <div class="jbr-wrap text-left border rounded">
                        <div class="cats-box mlb-res rounded bg-white d-flex align-items-center justify-content-between px-3 py-3">
                            <div class="cats-box rounded bg-white d-flex align-items-center">
                                <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                <div class="cats-box-caption px-2">
                                    <h5 class="ft-medium mb-1" style="font-size:16px">
                                        <a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}">
                                            <?php echo html_entity_decode($offre->offretitre) ?>
                                        </a>
                                    </h5>
                                    <div class="d-block mb-2 position-relative">
                                        <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>
                                            @foreach($offre->region_offre as $region)
                                                <span class="mr-2 mb-2 d-inline-flex px-2 py-1 rounded {{ $region->region_couleur }} text-capitalize">{{ $region->region_nom }}</span>
                                            @endforeach 
                                        </span>
                                        <span class="text-muted mr-2"><i class="lni lni-briefcase mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
                                        <span class="text-success ml-2 theme-cl"><i class="fa fa-clock mr-1"></i>
                                            @php
                                                $datejour = \Carbon\Carbon::today();
                                                $datefin = \Carbon\Carbon::createFromFormat('Y-m-d', $offre->offre_datefin);
                                                $joursrestant = $datejour->diffInDays($datefin);
                                                if($joursrestant < 1){
                                                    echo('Expire dans quelques heures');
                                                }
                                                if($joursrestant >= 1){
                                                    echo('Expire dans '.$joursrestant. ' jours');
                                                }                                                        
                                            @endphp   
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="text-center mlb-last"><a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn btn-md theme-bg ft-medium text-light apply-btn fs-sm rounded">Détails<i class="lni lni-arrow-right-circle ml-1"></i></a></div>
                        </div>
                    </div>
                </div>
            @endforeach                              
        </div>
    </div>
</section>
@endif
@endsection