@extends('layouts.appp')

@section('title')
    Liste des candidatures à valider
@endsection

@section('titre')
    Liste des candidatures à valider
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Les Candidatures</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Candidatures à valider</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des candidatures à valider</h4>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Nom & Prénom</th>
                                        <th>Email</th>
                                        <th>Téléphone</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($candidats as $candidat)
                                        <tr>
                                            <td>
                                                @if(!empty($candidat->profil_photo))
                                                    <img src="{{ asset('assets/img/profil/'.$candidat->profil_photo) }}" width="30" alt="">
                                                @else
                                                    <img src="{{ asset('assets/img/profil/avatar.png') }}" width="20" alt="">
                                                @endif
                                            </td>
                                            <td>{{ $candidat->name }} {{$candidat->prenoms}}</td>
                                            <td>{{ $candidat->email }}</td>
                                            <td>{{ $candidat->telephone }}</td> 
                                            <td class="text-center">
                                                <a href="{{ route('details.candidature',$candidat->candidature_id) }}" title="DÉTAILS DU CANDIDAT" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                <a href="{{ route('entreprise.valider.candidature',$candidat->candidature_id) }}" title="VALIDER LA CANDIDATURE" class=""><img src="{{ asset('assets/img/icons/validercone.png') }}" width="25"></a>
                                            </td>                                               
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection