@extends('layouts.appp')

@section('title')
    Détails du candidat
@endsection

@section('titre')
    Détails du candidat
@endsection

@section('content')
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('entreprise.listecandidature') }}">Les Candidatures</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails du candidat</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Détails du candidat</h4>
                </div>
                <div class="card-body">
                    <!-- Nav tabs -->
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#cv"><i class="la la-file mr-2"></i> Visualiser le CV</a>
                            </li>
                            @if($candidature->candidature_statut != "APPROUVE")
                                <li class="nav-item">
                                    <a class="nav-link" data-toggle="tab" href="#valider-contrat"><i class="fa fa-address-card mr-2"></i> Valider le Contrat</a>
                                </li>
                            @endif 
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                            <div class="tab-content">
                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                    @if($user->profil_photo)
                                                        <img class="img-fluid" src="{{ asset('assets/img/profil/'.$user->profil_photo) }}" alt="" style="border: 2px solid #000;" width="260">
                                                    @else
                                                        <img class="img-fluid" src="{{ asset('assets/img/profil/avatar.png') }}" alt="" style="border: 2px solid #000;" width="260">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                            <div class="product-detail-content">
                                                <div class="new-arrival-content pr">
                                                    <p class="text-couleur">Nom & Prénoms : {{ $user->name }} {{ $user->prenoms }}</p>
                                                    <p class="text-couleur">Adresse Email : {{ $user->email }}</p>
                                                    <p class="text-couleur">Téléphone : {{ $user->telephone }}</p>
                                                    <p class="text-couleur">Genre : 
                                                        @if($user->genre =="F")
                                                            Femme
                                                        @else
                                                            Homme
                                                        @endif
                                                    </p>
                                                    @if($user->metier)
                                                        <p class="text-couleur">Filière : 
                                                            {{  }}
                                                            @if($user->metier->metier_id == 51)
                                                                {{ $user->new_metier }}
                                                            @else
                                                                {{ $user->metier->metier_libelle }}
                                                            @endif
                                                        </p>
                                                    @endif
                                                    @if($user->diplome)
                                                        <p class="text-couleur">Dernier Diplôme : 
                                                            {{  }}
                                                            @if($user->diplome->diplome_id == 27)
                                                                {{ $user->new_diplome }}
                                                            @else
                                                                {{ $user->diplome->diplomelib }}
                                                            @endif
                                                        </p>
                                                    @endif
                                                    <p class="text-couleur">Département : {{ $user->departement }}</p>
                                                    <p class="text-couleur">Commune : {{ $user->commune }}</p>
                                                    <p class="text-couleur">Quartier/Village : {{ $user->village_quart }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des formations</h6>
                                            @foreach($user->formations as $formation)
                                                <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $formation->formation_diplome }}</small><br>
                                            @endforeach
                                            <br>
                                        </div>
                                        <div class="col-md-12">
                                            <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des expériences professionnelles</h6>
                                            @foreach($user->experiencepro as $experience)
                                                <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $experience->experiencepro_titre }}</small><br>
                                            @endforeach
                                            <br>
                                        </div>
                                        <div class="col-md-12">
                                            <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des spécialités</h6>
                                            @foreach($user->specialites as $specialite)
                                                <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $specialite->specialite_intitule }}</small><br>
                                            @endforeach
                                        </div>
                                    </div> 
                                </div>
                            </div>
                            <div class="tab-pane fade" id="cv">
                                <div class="pt-4">
                                    @if($user->user_cv !=null and $user->user_cv !="")
                                        <embed src="{{ asset('assets/img/profil/documents/'.$user->user_cv) }}" width="900" height="700" type="application/pdf"/>
                                    @else
                                        <h4 class="text-danger">
                                            <center>Ce demandeur d'emploi ne dispose pas de CV pour l'instant</center>
                                        </h4>
                                    @endif
                                </div>
                            </div>
                            <div class="tab-pane fade" id="valider-contrat">
                                <div class="pt-4">                                   
                                    <div class="basic-form">
                                        <form  action="{{ route('save.validercandidature',$candidature->candidature_id) }}" method="POST">
                                            @csrf
                                            @if($errors->any())
                                                <div class="alert alert-danger alert-styled-left alert-dismissible">
                                                    <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                                                    <span class="font-weight-semibold">
                                                        @foreach($errors->all() as $error)
                                                            <li><i class="fa fa-circle mr-3"></i>{{ $error }}</li>
                                                        @endforeach
                                                    </span>
                                                </div>
                                            @endif
                                            @if(Session::has('info_erreur'))
                                                <div class="alert alert-danger alert-styled-left alert-dismissible">
                                                    <button type="button" class="close" data-dismiss="alert"><span>&times;</span></button>
                                                    <span class="font-weight-semibold">
                                                        {{Session::get('info_erreur')}}
                                                    </span>
                                                </div>
                                            @endif
                                            <input type="hidden" name="candidature_id" value="{{ $candidature->candidature_id }}">
                                            <div class="form-row">
                                                <div class="form-group col-md-4">
                                                    <label>Type de contrat</label>
                                                    <select class="form-control" name="typecontrat_id">
                                                        <option value="">Sélectionnez un type de contrat</option>
                                                        @foreach($typecontrats as $contrat)
                                                            <option value="{{ $contrat->typecontrat_id }}">{{ $contrat->typecontratlib }}</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label>Date de Début</label>
                                                    <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control" name="datedebut">
                                                </div>
                                                <div class="form-group col-md-4">
                                                    <label>Date de Fin</label>
                                                    <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control" name="datefin">
                                                </div>
                                            </div>
                                            <button type="submit" class="btn btn-primary">Valider le contrat</button>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection