@extends('layouts.appp')

@section('title')
    Détails du candidat
@endsection

@section('titre')
    Détails du candidat
@endsection

@section('content')
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript::void(0)">Les Candidatures</a></li>
                <li class="breadcrumb-item"><a href="{{ route('entreprise.listecandidatureapprouvee') }}">Liste des candidatures approuvées</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Détails du candidat</a></li>
            </ol>
        </div>
        <div class="col-xl-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Détails du candidat</h4>
                </div>
                <div class="card-body">
                    <!-- Nav tabs -->
                    <div class="default-tab">
                        <ul class="nav nav-tabs" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active" data-toggle="tab" href="#infos"><i class="la la-home mr-2"></i> Informations générale</a>
                            </li>
                            <li class="nav-item">
                                <a class="nav-link" data-toggle="tab" href="#cv"><i class="la la-file mr-2"></i> Visualiser le CV</a>
                            </li>
                        </ul>
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="infos" role="tabpanel">
                                <div class="pt-4">
                                    <div class="row">
                                        <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                            <div class="tab-content">
                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                    @if($user->profil_photo)
                                                        <img class="img-fluid" src="{{ asset('assets/img/profil/'.$user->profil_photo) }}" alt="" style="border: 2px solid #000;" width="260">
                                                    @else
                                                        <img class="img-fluid" src="{{ asset('assets/img/profil/avatar.png') }}" alt="" style="border: 2px solid #000;" width="260">
                                                    @endif
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                            <div class="product-detail-content">
                                                <div class="new-arrival-content pr">
                                                    <p class="text-couleur">Nom & Prénoms : {{ $user->name }} {{ $user->prenoms }}</p>
                                                    <p class="text-couleur">Adresse Email : {{ $user->email }}</p>
                                                    <p class="text-couleur">Téléphone : {{ $user->telephone }}</p>
                                                    <p class="text-couleur">Genre : 
                                                        @if($user->genre =="F")
                                                            Femme
                                                        @else
                                                            Homme
                                                        @endif
                                                    </p>
                                                    @if($user->metier)<p class="text-couleur">Filière : {{ $user->metier->metier_libelle }}</p>@endif
                                                    @if($user->diplome)<p class="text-couleur">Dernier Diplôme : {{ $user->diplome->diplomelib }}</p>@endif
                                                    <p class="text-couleur">Département : {{ $user->departement }}</p>
                                                    <p class="text-couleur">Commune : {{ $user->commune }}</p>
                                                    <p class="text-couleur">Quartier/Village : {{ $user->village_quart }}</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div> 
                                    <hr>
                                    <div class="row">
                                        <div class="col-md-12">
                                            <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des formations</h6>
                                            @foreach($user->formations as $formation)
                                                <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $formation->formation_diplome }}</small><br>
                                            @endforeach
                                            <br>
                                        </div>
                                        <div class="col-md-12">
                                            <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des expériences professionnelles</h6>
                                            @foreach($user->experiencepro as $experience)
                                                <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $experience->experiencepro_titre }}</small><br>
                                            @endforeach
                                            <br>
                                        </div>
                                        <div class="col-md-12">
                                            <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des spécialités</h6>
                                            @foreach($user->specialites as $specialite)
                                                <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $specialite->specialite_intitule }}</small><br>
                                            @endforeach
                                        </div>
                                    </div> 
                                </div>
                            </div>
                            <div class="tab-pane fade" id="cv">
                                <div class="pt-4">
                                    @if($user->user_cv !=null and $user->user_cv !="")
                                        <embed src="{{ asset('assets/img/profil/documents/'.$user->user_cv) }}" width="900" height="700" type="application/pdf"/>
                                    @else
                                        <h4 class="text-danger">
                                            <h4 class="text-danger">
                                                <center>Ce demandeur d'emploi ne dispose pas de CV pour l'instant</center>
                                            </h4>
                                        </h4>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection