@extends('layouts.appp')

@section('title')
    Valider le contrat
@endsection

@section('titre')
    Valider le contrat
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="{{ route('listecandidature') }}">Les Candidatures</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Valider le contrat</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12 col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Valider le contrat</h4>
                    </div>
                    <div class="card-body">
                        <div class="basic-form">
                            <form  action="{{ route('savevalidercontrat',$abonnement->abonnement_id) }}" method="POST">
                                @csrf
                                <input type="hidden" name="abonnement_id" value="{{ $abonnement->abonnement_id }}">
                                <div class="form-row">
                                    <div class="form-group col-md-12">
                                        <label>Type de contrat <span class="text-danger">*</span></label>
                                        <select class="form-control" name="typetravail_id" required>
                                            <option value="">Sélectionnez un type de contrat</option>
                                            @foreach($typecontrats as $contrat)
                                                <option value="{{ $contrat->typetravail_id }}">{{ $contrat->typetravailib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>Date de Début <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" name="datedebut" required>
                                    </div>
                                    <div class="form-group col-md-12">
                                        <label>Date de Fin <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control" name="datefin">
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">Valider le contrat</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection