@extends('layouts.appp')

@section('title')
    Profils demandeurs d'emploi recommandés
@endsection

@section('titre')
    Profils demandeurs d'emploi recommandés
@endsection

@section('content')
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Cvthèque</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Profils recommandés</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des profils recommandés</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('entreprise.profil.recommande') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <label>Diplômes</label>
                                    <select id="diplome_select" name="d">
                                        <option value="">Choissisez un diplôme</option>
                                        @foreach($diplomes as $diplome)
                                            <option @if($diplome_selected == $diplome->diplome_id) selected @endif value="{{ $diplome->diplome_id }}">{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Métiers</label>
                                    <select id="metier_select" name="m">
                                        <option value="">Choissisez un métier</option>
                                        @foreach($filieres as $filiere)
                                            <option @if($metier_selected == $filiere->metier_id) selected @endif value="{{ $filiere->metier_id }}">{{ $filiere->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Année d'expérience</label>
                                    <input type="text" name="a" class="form-control" value="{{ $experience_selected }}" placeholder="Entrer l'année d'expérience">
                                </div>
                                <div class="col-md-3 mt-3">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                                <div class="col-md-3 mt-3">
                                    <label class="mt-3"></label>
                                    <a href="{{ route('entreprise.profil.recommande') }}" class="btn btn-warning btn-block">Réinitialiser</a>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Nom & Prénom</th>
                                        <th>Diplôme</th>
                                        <th>Métier</th>
                                        <th>Année d'Expérience</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($profil_recommandes as $profil)
                                        <tr>
                                            <td>
                                                @if(!empty($profil->profil_photo))
                                                    <img src="{{ asset('assets/img/profil/'.$profil->profil_photo) }}" width="30" alt="">
                                                @else
                                                    <img src="{{ asset('assets/img/profil/avatar.png') }}" width="20" alt="">
                                                @endif
                                            </td>
                                            <td>{{ $profil->name }} {{$profil->prenoms}}</td>
                                            <td>
                                                @if($profil->diplome_id == 27)
                                                    {{ $profil->new_diplome }}
                                                @else
                                                    {{ $profil->diplomelib }}
                                                @endif
                                            </td>
                                            <td>
                                                @if($profil->metier_id == 51)
                                                    {{ $profil->new_metier }}
                                                @else
                                                    {{ $profil->metier_libelle }}
                                                @endif
                                            </td> 
                                            <td>{{ $profil->experience }}</td> 
                                            <td class="text-center">
                                                @if($profil->cvtheque_statut == "VALIDE")
                                                    <a style="cursor:pointer;" href="" data-toggle="modal" data-target="#modal_details{{ $profil->id }}" title="DÉTAILS" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                @else
                                                    <span class="badge badge-info">En cours de traitment</span>
                                                @endif
                                            </td>                                               
                                        </tr>
                                        <div id="modal_details{{ $profil->id }}" class="modal fade" tabindex="-1">
                                            <div class="modal-dialog modal-lg">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;DETAILS DE : {{ $profil->name }} {{$profil->prenoms}}</h5>
                                                        <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                                <div class="tab-content">
                                                                    <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                        @if($profil->profil_photo)
                                                                            <img class="img-fluid" src="{{ asset('assets/img/profil/'.$profil->profil_photo) }}" alt="" style="border: 2px solid #000;" width="260">
                                                                        @else
                                                                            <img class="img-fluid" src="{{ asset('assets/img/profil/avatar.png') }}" alt="" style="border: 2px solid #000;" width="260">
                                                                        @endif
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                                <div class="product-detail-content">
                                                                    <div class="new-arrival-content pr">
                                                                        <p class="text-couleur">Nom & Prénoms : {{ $profil->name }} {{ $profil->prenoms }}</p>
                                                                        <p class="text-couleur">Adresse Email : {{ $profil->email }}</p>
                                                                        <p class="text-couleur">Téléphone : {{ $profil->telephone }}</p>
                                                                        <p class="text-couleur">Genre : 
                                                                            @if($profil->genre =="F")
                                                                                Femme
                                                                            @else
                                                                                Homme
                                                                            @endif
                                                                        </p>
                                                                        @if($profil->metier)
                                                                            <p class="text-couleur">Filière :
                                                                                @if($profil->metier->metier_id == 51)
                                                                                    {{ $profil->new_metier }}
                                                                                @else
                                                                                    {{ $profil->metier->metier_libelle }}
                                                                                @endif
                                                                            </p>
                                                                        @endif
                                                                        @if($profil->diplome)
                                                                            <p class="text-couleur">Dernier Diplôme :
                                                                                @if($profil->diplome->diplome_id == 27)
                                                                                    {{ $profil->new_diplome }}
                                                                                @else
                                                                                    {{ $profil->diplome->diplomelib }}
                                                                                @endif
                                                                            </p>
                                                                        @endif
                                                                        <p class="text-couleur">Département : {{ $profil->departement }}</p>
                                                                        <p class="text-couleur">Commaune : {{ $profil->commune }}</p>
                                                                        <p class="text-couleur">Quartier/Village : {{ $profil->village_quart }}</p>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div> 
                                                        <hr>
                                                        <div class="row">
                                                            <div class="col-md-12">
                                                                <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des formations</h6>
                                                                @foreach($profil->formations as $formation)
                                                                    <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $formation->formation_diplome }}</small><br>
                                                                @endforeach
                                                                <br>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des expériences professionnelles</h6>
                                                                @foreach($profil->experiencepro as $experience)
                                                                    <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $experience->experiencepro_titre }}</small><br>
                                                                @endforeach
                                                                <br>
                                                            </div>
                                                            <div class="col-md-12">
                                                                <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des spécialités</h6>
                                                                @foreach($profil->specialites as $specialite)
                                                                    <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $specialite->specialite_intitule }}</small><br>
                                                                @endforeach
                                                            </div>
                                                        </div>                   
                                                    </div>

                                                    <div class="modal-footer">
                                                        <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                        @if($profil->user_cv !=null and $profil->user_cv != "")
                                                            <a href="{{ asset('assets/img/profil/documents/'.$profil->user_cv) }}" target="_blank" class="btn btn-primary"><i class="fas fa-address-card mr-1"></i> Ouvrir le CV</a>
                                                        @endif
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection