@extends('layouts.appp')

@section('title')
    Résultat de recherche
@endsection

@section('titre')
    Résultat de recherche
@endsection

@section('content')
    <link href="{{ asset('assets/css/icomoon/styles.min.css') }}" rel="stylesheet" type="text/css">
    <link href="{{ asset('assets/css/fontawesome/styles.min.css') }}" rel="stylesheet" type="text/css">
    <style type="text/css">
        .float-end{
            float: right;
        }
    </style>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Cvthèque</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Rechercher un profil</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des profils recherchés</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('entreprise.profil.resultat') }}" class="mb-10">
                            <div class="row">
                                <div class="col-md-6">
                                    <label>Type de formation</label>
                                     <input type="text" name="f" value="{{ $formation_selected }}" class="form-control" placeholder="Entrer le type de formation">
                                </div>
                                <div class="col-md-6">
                                    <label>Expérience professionnelle</label>
                                     <input type="text" name="e" value="{{ $experiencepro_selected }}" class="form-control" placeholder="Entrer l'expérience professionnelle">
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Spécialité</label>
                                    <input type="text" name="s" value="{{ $specialite_selected }}" class="form-control" placeholder="Entrer la spécialité">
                                </div>
                                <div class="col-md-6 mt-3">
                                    <label>Année d'expérience</label>
                                    <input type="text" name="a" value="{{ $experience_selected }}" class="form-control" placeholder="Entrer l'année d'expérience">
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <a href="{{ route('entreprise.profil.resultat') }}" class="btn btn-warning btn-block">Réinitialiser</a>
                                </div>
                            </div>
                        </form><hr>
                        <form method="POST" action="{{ route('entreprise.demander.profil') }}">  
                            @csrf                            
                            <div class="table-responsive">                            
                                <table id="example3" class="display min-w850">
                                    <thead>
                                        <tr>
                                            <th></th>
                                            <th>Nom & Prénom</th>
                                            <th>Genre</th>
                                            <th>Année d'Expérience</th>
                                            <th class="text-center">Détails</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($profil_recommandes as $profil)
                                            <tr>
                                                <td>
                                                    <input type="checkbox" value="{{ $profil->id }}" name="demandeur_id[]">
                                                </td>
                                                <td>{{ $profil->name }} {{$profil->prenoms}}</td>
                                                <td>
                                                    @if($profil->genre =="F")
                                                        Femme
                                                    @else
                                                        Homme
                                                    @endif
                                                </td> 
                                                <td>{{ $profil->experience }}</td>                                 
                                                <td class="text-center">
                                                    <a style="cursor:pointer;" href="" data-toggle="modal" data-target="#modal_details{{ $profil->id }}" title="DÉTAILS" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                </td>                                 
                                            </tr>
                                            <div id="modal_details{{ $profil->id }}" class="modal fade" tabindex="-1">
                                                <div class="modal-dialog modal-lg">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title"><i class="icon-menu7 mr-2"></i> &nbsp;DETAILS DE : {{ $profil->name }} {{$profil->prenoms}}</h5>
                                                            <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="row">
                                                                <div class="col-xl-3 col-lg-6 col-md-6 col-xxl-5 ">
                                                                    <div class="tab-content">
                                                                        <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                            @if($profil->profil_photo)
                                                                                <img class="img-fluid" src="{{ asset('assets/img/profil/'.$profil->profil_photo) }}" alt="" style="border: 2px solid #000;" width="220">
                                                                            @else
                                                                                <img class="img-fluid" src="{{ asset('assets/img/profil/avatar.png') }}" alt="" style="border: 2px solid #000;">
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <div class="col-xl-9 col-lg-6 col-md-6 col-xxl-7 col-sm-12">
                                                                    <div class="product-detail-content">
                                                                        <div class="new-arrival-content pr">
                                                                            <p class="text-couleur">Nom & Prénoms : {{ $profil->name }} {{ $profil->prenoms }}</p>
                                                                            <p class="text-couleur">Genre : 
                                                                                @if($profil->genre =="F")
                                                                                    Femme
                                                                                @else
                                                                                    Homme
                                                                                @endif
                                                                            </p>
                                                                            <p class="text-couleur">Filière : {{ $profil->metier->metier_libelle }}</p>
                                                                            @if($profil->diplome)
                                                                                <p class="text-couleur">Dernier Diplôme : {{ $profil->diplome->diplomelib }}</p>
                                                                            @endif
                                                                            <p class="text-couleur">Département : {{ $profil->departement }}</p>
                                                                            <p class="text-couleur">Année d'expérience : {{ $profil->experience }}</p>
                                                                            <p class="text-couleur">Commune : {{ $profil->commune }}</p>
                                                                            <p class="text-couleur">Quartier/Village : {{ $profil->village_quart }}</p>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div> 
                                                            <hr>
                                                            <div class="row">
                                                                <div class="col-md-12">
                                                                    <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des formations</h6>
                                                                    @foreach($profil->formations as $formation)
                                                                        <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $formation->formation_diplome }}</small><br>
                                                                    @endforeach
                                                                    <br>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des expériences professionnelles</h6>
                                                                    @foreach($profil->experiencepro as $experience)
                                                                        <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $experience->experiencepro_titre }}</small><br>
                                                                    @endforeach
                                                                    <br>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des spécialités</h6>
                                                                    @foreach($profil->specialites as $specialite)
                                                                        <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $specialite->specialite_intitule }}</small><br>
                                                                    @endforeach
                                                                    <br>
                                                                </div>
                                                                <div class="col-md-12">
                                                                    <h6 class="font-weight-semibold"><i class="fas fa-hand-point-right mr-2"></i> Liste des atouts, centre d'intérêt & qualité</h6>
                                                                    @foreach($profil->centreinterets as $centreinteret)
                                                                        <small style="margin-left:10px"><i class="fas fa-caret-right mr-2"></i>{{ $centreinteret->centreint_langue_intitule }}</small><br>
                                                                    @endforeach
                                                                </div>
                                                            </div>                   
                                                        </div>

                                                        <div class="modal-footer">
                                                            <button class="btn btn-danger" data-dismiss="modal"><i class="icon-cross2 font-size-base mr-1"></i> Fermer</button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </tbody>
                                    @if($profil_recommandes->count() > 0)
                                    <tfoot>
                                        <tr>
                                            <td colspan="5">
                                                <button type="submit" class="btn btn-primary float-end">Envoyer la demande</button>
                                            </td>
                                        </tr>
                                    </tfoot>
                                    @endif
                                </table>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection