@extends('layouts.appp')

@section('title')
   Mon Compte
@endsection

@section('titre')
   Mon Compte
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Mon compte</a></li>
                <!--li class="breadcrumb-item active"><a href="javascript:void(0)">Mon profil</a></li-->
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-body">
                        <div class="profile-tab">
                            <div class="custom-tab-1">
                                <ul class="nav nav-tabs">
                                    <li class="nav-item"><a href="#info-generale" data-toggle="tab" class="nav-link active show"><i class="fa fa-gears" style="margin-right: 15px !important;"></i>Informations Générales</a>
                                    </li>
                                    <li class="nav-item"><a href="#edit-compte" data-toggle="tab" class="nav-link"><i class="fa fa-user-circle" style="margin-right: 15px !important;"></i>Modifier mon compte</a>
                                    </li>
                                    <li class="nav-item"><a href="#edit-password" data-toggle="tab" class="nav-link"><i class="fa fa-key" style="margin-right: 15px !important;"></i>Modifier mot de passe</a>
                                    </li>
                                </ul>
                                <div class="tab-content">
                                    <div id="info-generale" class="tab-pane fade active show">
                                        <div class="pt-4">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="card">
                                                <div class="card-body">
                                                    <div class="row">
                                                        <div class="col-xl-3 col-lg-6  col-md-6 col-xxl-5 ">
                                                            <div class="tab-content">
                                                                <div role="tabpanel" class="tab-pane fade show active" id="first">
                                                                    <img class="img-fluid" src="{{ asset('assets/img/entreprise/'.$user->entreprise_logo) }}" alt="">
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-xl-9 col-lg-6  col-md-6 col-xxl-7 col-sm-12">
                                                            <div class="product-detail-content">
                                                                <div class="new-arrival-content pr">
                                                                    <h4><?php echo html_entity_decode($user->raisonsociale) ?></h4>
                                                                    @if($user->nationalite_id !=null or $user->nationalite_id !="")<p>Nationalité : {{ $nationalite->nationalite_lib }}</p>@endif
                                                                    @if($user->region_id !=null or $user->region_id !="")<p>Region : {{ $region->region_nom }}</p>@endif
                                                                    @if($user->statutentreprise_id !=null or $user->statutentreprise_id !="")<p>Statut : {{ $statutentreprise->statutentreprise_lib }}</p>@endif
                                                                    @if($user->situationentreprise_id !=null or $user->situationentreprise_id !="")<p>Situation actuelle : 
                                                                        @if($situationentreprise->situationentreprise_lib == "EN ACTIVITEE")
                                                                            <span class="badge badge-success light">{{ $situationentreprise->situationentreprise_lib }}</span>
                                                                        @elseif($situationentreprise->situationentreprise_lib == "VEILLEUSE")
                                                                            <span class="badge badge-warning light">{{ $situationentreprise->situationentreprise_lib }}</span>  
                                                                        @else
                                                                            <span class="badge badge-danger light">{{ $situationentreprise->situationentreprise_lib }}</span>
                                                                        @endif
                                                                    </p>@endif
                                                                    @if($user->secteuractivite_id !=null or $user->secteuractivite_id !="")<p>Branche activité : {{ $secteuractivite->secteuractivitelib }}</p>@endif
                                                                    <p>Interlocuteur : {{ $user->name }}</p>
                                                                    <p>Email : {{ $user->email }}</p>
                                                                    <p>Contact : {{ $user->contact }}</p>
                                                                    <p class="text-content">
                                                                        <strong>Adresse</strong><br>
                                                                        {{ $user->adresse }}
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                    </div>
                                    <div id="edit-compte" class="tab-pane fade">
                                        <div class="pt-3">
                                            <div class="settings-form">
                                                <form method="POST" action="{{ route('entreprise.save.edit') }}" enctype="multipart/form-data">
                                                    @csrf
                                                    <div class="form-group">
                                                        <label>Designation <span style="color:red">*</span></label>
                                                        <input type="text" required class="form-control rounded @error('raisonsociale') is-invalid @enderror"  name="raisonsociale" value="{{ $user->raisonsociale }}" placeholder="Raison sociale" onkeyup="this.value=this.value.toUpperCase()">
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Adresse <span style="color:red">*</span></label>
                                                                <input type="text" required class="form-control rounded @error('adresse') is-invalid @enderror"  name="adresse" value="{{ $user->adresse }}" placeholder="Adresse" onkeyup="this.value=this.value.toUpperCase()">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Contact <span style="color:red">*</span></label>
                                                                <input type="text" required class="form-control rounded @error('contact') is-invalid @enderror"  name="contact" value="{{ $user->contact }}" id="contact" placeholder="+227 20 73 33 84" onkeypress="isInputNumber(event)">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <h2>Coordonnées Interlocuteur</h2><hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Nom & Prénoms <span style="color:red">*</span></label>
                                                                <input type="text" class="form-control rounded @error('nom') is-invalid @enderror" name="nom" required value="{{ $user->name }}" placeholder="Entrer votre nom & prénoms" onkeyup="this.value=this.value.toUpperCase()">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Qualité <span style="color:red">*</span></label>
                                                                <input type="text" required class="form-control rounded @error('qualite') is-invalid @enderror"  name="qualite" value="{{ $user->qualite }}" placeholder="Qualité" onkeyup="this.value=this.value.toUpperCase()">
                                                            </div>
                                                        </div>
                                                    </div>                                                    
                                                    <h2>Effectif de l'entreprise</h2><hr>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Homme <span style="color:red">*</span></label>
                                                                <input type="text" required class="form-control rounded @error('nbrehomme') is-invalid @enderror"  name="nbrehomme" value="{{ $user->nbrehomme }}" placeholder="Nombre d'homme" onkeypress="isInputNumber(event)">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Femme <span style="color:red">*</span></label>
                                                                <input type="text" required class="form-control rounded @error('nbrfemme') is-invalid @enderror"  name="nbrfemme" value="{{ $user->nbrfemme }}" placeholder="Nombre de femme" onkeypress="isInputNumber(event)">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <h2>Autres Informations</h2><hr>
                                                    <div class="form-group">
                                                        <label>Activité <span style="color:red">*</span></label>
                                                        <input type="text" required class="form-control rounded @error('activite') is-invalid @enderror"  name="activite" value="{{ $user->activite }}" placeholder="Activité" onkeyup="this.value=this.value.toUpperCase()">
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Nationalité <span style="color:red">*</span></label>
                                                                <select class="form-control" name="nationalite_id">
                                                                    <option value="">Choisissez une nationalité</option>
                                                                    @foreach($nationalites as $nationalite)
                                                                        <option @if($user->nationalite_id == $nationalite->nationalite_id) selected @endif value="{{ $nationalite->nationalite_id }}">{{ $nationalite->nationalite_lib }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Région <span style="color:red">*</span></label>
                                                                <select id="single-select" name="region_id">
                                                                    <option value="">Choisissez une region</option>
                                                                    @foreach($regions as $region)
                                                                        <option @if($user->region_id == $region->region_id) selected @endif value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Branche d'activité <span style="color:red">*</span></label>
                                                                <select id="automatic-selection" name="secteuractivite_id">
                                                                    <option value="">Choisissez une branche d'activité</option>
                                                                    @foreach($activites as $activite)
                                                                        <option @if($user->secteuractivite_id == $activite->secteuractivite_id) selected @endif value="{{ $activite->secteuractivite_id }}">{{ $activite->secteuractivitelib }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Statut <span style="color:red">*</span></label>
                                                                <select class="form-control" name="statutentreprise_id">
                                                                    <option value="">Choisissez un statut</option>
                                                                    @foreach($statuts as $statut)
                                                                        <option @if($user->statutentreprise_id == $statut->statutentreprise_id) selected @endif value="{{ $statut->statutentreprise_id }}">{{ $statut->statutentreprise_lib }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>N° CNSS</label>
                                                                <input type="text" class="form-control rounded"  name="ncnss" value="{{ $user->ncnss }}" placeholder="Entre le numéro CNSS" onkeyup="this.value=this.value.toUpperCase()">
                                                            </div>
                                                        </div>
                                                        <div class="col-md-6">
                                                            <div class="form-group">
                                                                <label>Situation <span style="color:red">*</span></label>
                                                                <select class="form-control" name="situationentreprise_id">
                                                                    <option value="">Choisissez une situation</option>
                                                                    @foreach($situations as $situation)
                                                                        <option @if($user->situationentreprise_id == $situation->situationentreprise_id) selected @endif value="{{ $situation->situationentreprise_id }}">{{ $situation->situationentreprise_lib }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                        </div>
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Logo entreprise <small>( Fichier autorisé : png, jpg, jpeg)</small></label>
                                                                <input type="file" class="form-control rounded @error('entreprise_logo') is-invalid @enderror"  name="entreprise_logo" value="{{ $user->entreprise_logo }}">
                                                                @if(!empty($user->entreprise_logo))
                                                                    <input type="hidden" name="ancien_image" value="{{ $user->entreprise_logo }}">
                                                                @endif
                                                            </div>
                                                        </div>
                                                    </div><hr>
                                                    <button class="btn btn-primary">Enregistrer les modifications</button>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="edit-password" class="tab-pane fade">
                                        <div class="pt-3">
                                            <div class="settings-form">
                                                <form class="_apply_form_form" method="POST" action="{{ route('entreprise.save.modifer.motpasse') }}"  enctype="multipart/form-data">   
                                                    @csrf                    
                                                    <div class="row">
                                                        <div class="col-md-12">
                                                            <div class="form-group">
                                                                <label>Mot de passe actuel <span style="color:red">*</span></label>
                                                                <input type="password" required class="form-control" id="current_password" name="current_password">                                                                
                                                            </div>
                                                        </div> 
                                                        <div class="col-md-12">                      
                                                            <div class="form-group">
                                                                <label>Nouveau mot de passe <span style="color:red">*</span></label>
                                                                <input type="password" required class="form-control" id="new_password" name="new_password">
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="row">
                                                        <div class="col-md-12">                        
                                                            <div class="form-group">
                                                                <label>Confirmer le nouveau mot de passe <span style="color:red">*</span></label>
                                                                <input type="password" required class="form-control" id="new_password_confirmation" name="new_password_confirmation">
                                                            </div> 
                                                        </div>
                                                    </div>                            
                                                    <div class="form-group">
                                                        <button class="btn btn-primary" type="submit">Modifier le mot de passe</button>
                                                    </div>                            
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <script>
        function isInputNumber(evt){
            
            var ch = String.fromCharCode(evt.which);
            
            if(!(/[0-9]/.test(ch))){
                evt.preventDefault();
            }        
        }
    </script>
@endsection