@extends('layouts.appp')

@section('title')
    <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('titre')
    <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('content')
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{route('home')}}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{ route('gestionoffre') }}">Gestion offres</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)"><?php echo html_entity_decode($offre->offretitre) ?></a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-lg-12">

            <div class="card">
                <div class="card-header"> Détails <strong>{{ \Carbon\Carbon::parse($offre->offre_datecrea)->format('d/m/Y') }}</strong> 
                    <span class="float-right">
                        <strong>Statut:</strong> 
                        @if($offre->offre_statut == "BROUILLON")
                            <span class="badge badge-danger light">Brouillon</span>
                        @elseif($offre->offre_statut == "VALIDE")
                            <span class="badge badge-warning light">Active</span>
                        @elseif($offre->offre_statut == "PUBLIE")
                            <span class="badge badge-success light">Publié</span>
                        @endif
                    </span> 
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><span style="font-weight:bold;">Titre : </span><?php echo html_entity_decode($offre->offretitre) ?></p>
                            <p><span style="font-weight:bold;">Métier : </span>{{ $offre->metier->metier_libelle }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><span style="font-weight:bold;">Année Expérience : </span>{{ $offre->offre_anneeexperience }}</p>
                            <p><span style="font-weight:bold;">Nbre de Poste : </span>{{ $offre->offrenombreposte }}</p>
                            <p><span style="font-weight:bold;">Contrat : </span>{{ $offre->contrat->typecontratlib }}</p>
                            <p><span style="font-weight:bold;">Diplôme : </span>{{ $offre->diplome->diplomelib }}</p>
                            <p><span style="font-weight:bold;">Date de publication : </span>{{ \Carbon\Carbon::parse($offre->offre_datecrea)->format('d/m/Y') }}</p>
                            <p><span style="font-weight:bold;">Date de clôture : </span>{{ \Carbon\Carbon::parse($offre->offre_datefin)->format('d/m/Y') }}</p>
                            <div class="jb-list-01-title d-inline"><span style="font-weight:bold;">Region : </span>
                                @foreach($offre->regions as $region)
                                    <span class="mr-2 mb-2 d-inline-flex px-2 py-1 rounded {{ $region->region_couleur }} text-capitalize">{{ $region->region_nom }}</span>
                                @endforeach 
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="card-header mb-3">
                        <h4 class="card-title">Liste des candidatures</h4>
                    </div>
                    <div class="table-responsive">
                        <table id="abonnement" class="display min-w850">
                            <thead>
                                <tr>
                                    <th></th>
                                    <th>Nom & Prénoms</th>
                                    <th>Téléphone</th>
                                    <th>Date Abonnement</th>
                                    <th class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($candidatures as $candidature)
                                    <tr>
                                        <td>
                                            @if(!empty($candidature->profil_photo))
                                                <img src="{{ asset('assets/img/profil/'.$candidature->profil_photo) }}" width="30" alt="">
                                            @else
                                                <img src="{{ asset('assets/img/profil/avatar.png') }}" width="20" alt="">
                                            @endif
                                        </td>
                                        <td>{{ $candidature->name }} {{ $candidature->prenoms }}</td>
                                        <td>{{ $candidature->telephone }}</td>
                                        <td>{{ \Carbon\Carbon::parse($candidature->candidature_datecrea)->format('d/m/Y') }}</td>
                                        <td class="text-center">
                                            @if($candidature->cv_joint !=null)
                                                <a href="{{ asset('cv/'.$candidature->cv_joint) }}" target="_blank" class="btn btn-info shadow btn-xs sharp mr-1" title="VOIR LE CV"><i class="fa fa-file-pdf-o"></i></a>
                                            @endif                                            <a href="{{ route('entreprise.valider.candidature',$candidature->candidature_id) }}" class="" title="VALIDER LA CANDIDATURE"><img src="{{ asset('assets/img/icons/validercone.png') }}" width="30"></a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection