@extends('layouts.appp')

@section('title')
    Liste des offres
@endsection

@section('titre')
    Liste des offres
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gérer les offres</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des offres</a></li>
            </ol>
        </div>
        <div class="row"> 
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des offres publiés</h4>
                        <a href="{{ route('entreprise.publieroffre') }}" class="btn btn-primary float-end"><i class="fa fa-plus-circle"></i> Nouvelle Offre</a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Titre de l'offre</th>
                                        <th>Status</th>
                                        <th>Date création</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($offres as $offre)
                                        <tr>
                                            <td>
                                                <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.Auth::user()->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                            </td>
                                            <td>
                                                <div class="cats-box rounded bg-white d-flex align-items-center">
                                                    <div class="cats-box-caption px-2">
                                                        <h6 class="fs-md mb-0 ft-medium"><?php echo html_entity_decode($offre->offretitre) ?></h6>
                                                        <div class="d-block mb-2 position-relative">
                                                            <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i></span>
                                                            <span class="badge badge-success text-white medium"><i class="lni lni-map-marker mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                @if($offre->offre_statut == "BROUILLON")
                                                    <span class="text-info">Brouillon</span>
                                                @elseif($offre->offre_statut == "VALIDE")
                                                    <span class="text-info">Active</span>
                                                @elseif($offre->offre_statut == "PUBLIE")
                                                    <span class="text-info">Publié</span>
                                                @endif
                                            </td>
                                            <td>{{ \Carbon\Carbon::parse($offre->offre_datecrea)->format('d/m/Y') }}</td>
                                            <td class="text-center"> 
                                                @if($offre->offre_statut == "BROUILLON")
                                                    <a href="{{ route('entreprise.detailsoffre',$offre->offre_id) }}" title="DÉTAILS DE L'OFFRE" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                    <a href="{{ route('modifieroffre',$offre->offre_id) }}" title="MODIFIER L'OFFRE"  class=""><img src="{{ asset('assets/img/icons/modifier.png') }}" class="img-fluid" width="25" alt=""></a>
                                                    <a href="javascript:void(0);" data-toggle="modal" data-target="#supprimeroffre{{$offre->offre_id}}" title="SUPPRIMER L'OFFRE"><img src="{{ asset('assets/img/icons/delete.png') }}" class="img-fluid" width="30" alt=""></a>
                                                @else
                                                    <a href="{{ route('entreprise.detailsoffre',$offre->offre_id) }}" title="DÉTAILS DE L'OFFRE" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                @endif                                             
                                            </td>                                               
                                        </tr>

                                        <div class="modal fade" id="supprimeroffre{{$offre->offre_id}}" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer l'offre d'emploi : <?php echo html_entity_decode($offre->offretitre) ?>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="{{ route('entreprise.supprimeroffre',$offre->offre_id) }}" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div> 
    </div>
@endsection