@extends('layouts.appp')

@section('title')
    Liste des offres expirées
@endsection

@section('titre')
    Liste des offres expirées
@endsection

@section('content')
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gérer les offres</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des offres expirées</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des offres expirées</h4>
                        <a href="{{ route('entreprise.publieroffre') }}" class="btn btn-primary float-end"><i class="fa fa-plus-circle"></i> Nouvelle Offre</a>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th></th>
                                        <th>Titre de l'offre</th>
                                        <th>Date d'expiration</th>
                                        <th class="text-center">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($offres as $offre)
                                        <tr>
                                            <td>
                                                <div class="text-center"><img src="{{ asset('assets/img/entreprise/'.Auth::user()->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
                                            </td>
                                            <td>
                                                <div class="cats-box rounded bg-white d-flex align-items-center">
                                                    <div class="cats-box-caption px-2">
                                                        <h6 class="fs-md mb-0 ft-medium"><?php echo html_entity_decode($offre->offretitre) ?></h6>
                                                        <div class="d-block mb-2 position-relative">
                                                            <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i></span>
                                                            <span class="badge badge-success text-white medium"><i class="lni lni-map-marker mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>{{ \Carbon\Carbon::parse($offre->offre_datefin)->format('d/m/Y') }}</td>
                                            <td class="text-center">
                                                <a href="{{ route('entreprise.detailsoffreexpiree',$offre->offre_id) }}" title="DÉTAILS DE L'OFFRE" class=""><img src="{{ asset('assets/img/icons/details.png') }}" width="25"></a>
                                                <span class="" title="RELANCER L'OFFRE" data-toggle="modal" data-target="#RelancerOffre{{ $offre->id }}"><img src="{{ asset('assets/img/icons/relancer.png') }}" width="25"></span>                                         
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="RelancerOffre{{ $offre->id }}">
                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title">Relancer l'offre : <?php echo html_entity_decode($offre->offretitre) ?></h5>
                                                        <button type="button" class="close" data-dismiss="modal"><span>&times;</span>
                                                        </button>
                                                    </div>
                                                    <form method="POST" action="{{ route('relanceroffrenouveau',$offre->offre_id) }}" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="modal-body">
                                                            <label>Nouvelle date de clôture</label>
                                                            <input type="date" name="datefin" class="form-control" value="{{ old('datefin') }}" min="<?php echo date('Y-m-d'); ?>" required>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="submit" class="btn btn-info">Relancer l'offre</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection