@extends('layouts.appp')

@section('title')
    Modifier : <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('titre')
    Modifier : <?php echo html_entity_decode($offre->offretitre) ?>
@endsection

@section('content')
<script>
    window.addEventListener('DOMContentLoaded', (event) => {
      // Cacher le champ de liensoumission par défaut
      const liensoumissionInput = document.querySelector('input[name="liensoumission"]');
      liensoumissionInput.style.display = 'none';

      // Écouter les changements de sélection du champ soumission
      const soumissionSelect = document.querySelector('select[name="soumission"]');
      soumissionSelect.addEventListener('change', (event) => {
        const selectedValue = event.target.value;

        // Afficher ou cacher le champ liensoumission en fonction de la sélection
        if (selectedValue === 'PAR MAIL' || selectedValue === 'LIEN SITE WEB') {
          liensoumissionInput.style.display = 'block';
        } else {
          liensoumissionInput.style.display = 'none';
        }
      });

      // Valider le champ liensoumission lors de la soumission du formulaire
      const form = document.querySelector('form');
      form.addEventListener('submit', (event) => {
        const selectedValue = soumissionSelect.value;
        const liensoumissionValue = liensoumissionInput.value.trim();

        if (selectedValue === 'PAR MAIL' && !isValidEmail(liensoumissionValue)) {
          event.preventDefault(); // Empêcher la soumission du formulaire
          displayErrorMessage('Entrer une adresse email valide');
        } else if (selectedValue === 'LIEN SITE WEB' && !isValidURL(liensoumissionValue)) {
          event.preventDefault(); // Empêcher la soumission du formulaire
          displayErrorMessage('Entrer une URL valide');
        }
      });

      // Fonction pour afficher un message d'erreur
      function displayErrorMessage(message) {
        const errorContainer = document.querySelector('.error-message');
        errorContainer.textContent = message;
      }

      // Fonction pour valider une adresse email
      function isValidEmail(email) {
        // Logique de validation d'email (exemple simple)
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
      }

      // Fonction pour valider une URL
      function isValidURL(url) {
        // Logique de validation d'URL (exemple simple)
        const urlRegex = /^(http|https):\/\/[^ "]+$/;
        return urlRegex.test(url);
      }
    });
</script>
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gérer les offres</a></li>
            <li class="breadcrumb-item"><a href="{{ route('gestionoffre') }}">Liste des offres</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Modification de l'offre</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Modifier : <?php echo html_entity_decode($offre->offretitre) ?></h4>
                    <a href="{{ route('gestionoffre') }}" class="btn btn-primary float-end"><i class="fa fa-tasks"></i> Liste Offres</a>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form method="POST" action="{{ route('SaveModifierOffre', $offre->offre_id) }}">
                            @csrf
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label>Titre de l'offre</label>
                                    <input type="text" class="form-control @error('titre') is-invalid @enderror" name="titre" value="{{ $offre->offretitre }}" placeholder="Exemple : Développeur Web *">
                                </div>
                            </div> 
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Lieu</label>
                                    <select id="multi-value-select" multiple="multiple" name="region_ids[]" required>
                                        <option value="">Choisir un ou des lieu(x)</option>
                                        @foreach($regions as $region)
                                            <option value="{{ $region->region_id }}" {{ in_array($region->region_id, old('region_ids', [])) || ($offre->regions->contains('region_id', $region->region_id)) ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Type de Contrat</label>
                                    <select id="contrat-select" class="form-control rounded @error('typecontrat_id') is-invalid @enderror" name="typecontrat_id">
                                        <option value="">Sélectionnez un type de contrat *</option>
                                        @foreach($typecontrat as $contrat)
                                            <option @if($offre->typecontrat_id == $contrat->typecontrat_id) selected @endif value="{{ $contrat->typecontrat_id }}" {{ old('typecontrat_id') == $contrat->typecontrat_id ? 'selected' : '' }}>{{ $contrat->typecontratlib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Type de métier </label>
                                    <select id="metier-select" class="form-control rounded @error('metier_id') is-invalid @enderror" name="metier_id">
                                        <option value="">Sélectionnez un métier *</option>
                                        @foreach($metiers as $metier)
                                            <option @if($offre->metier_id == $metier->metier_id) selected @endif value="{{ $metier->metier_id }}" {{ old('metier_id') == $metier->metier_id ? 'selected' : '' }}>{{ $metier->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Niveau d'étude</label>
                                    <select id="diplome-select" class="form-control rounded @error('diplome_id') is-invalid @enderror" name="diplome_id">
                                        <option value="">Sélectionnez une niveau d'étude</option>
                                        @foreach($diplomes as $diplome)
                                            <option @if($offre->diplome_id == $diplome->diplome_id) selected @endif value="{{ $diplome->diplome_id }}" {{ old('diplome_id') == $diplome->diplome_id ? 'selected' : '' }}>{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Année d'expérence</label>
                                    <input type="text" class="form-control rounded @error('annexperience') is-invalid @enderror" name="annexperience" value="{{$offre->offre_anneeexperience }}" placeholder="Année d'expérence">
                                </div>
                                <div class="col-md-6">
                                    <label>Nombre de Poste</label>
                                    <input type="text" onkeypress="isInputNumber(event)" class="form-control rounded @error('nombreposte') is-invalid @enderror" name="nombreposte" value="{{ $offre->offrenombreposte }}" placeholder="Nombre de poste">
                                </div> 
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Date de clôture</label>
                                    <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control rounded @error('datefin') is-invalid @enderror" name="datefin" value="{{ $offre->offre_datefin }}">
                                </div>
                                @if($offre->user_id != 1)
                                <div class="col-md-6">
                                    <label>Soumission par mail ou un lien</label>
                                    <select class="form-control" required name="soumission" required>
                                      <option value="">Soumet-on par mail ou un lien ?</option>
                                      <option @if($offre->offre_soumission == "PAR MAIL") selected @endif value="PAR MAIL" {{ old('soumission') == 'PAR MAIL' ? 'selected' : '' }}>Par email</option>
                                      <option @if($offre->offre_soumission == "LIEN SITE WEB") selected @endif value="LIEN SITE WEB" {{ old('soumission') == 'LIEN SITE WEB' ? 'selected' : '' }}>Lien site Web</option>
                                      <option @if($offre->offre_soumission == "ANPE") selected @endif value="ANPE" {{ old('soumission') == 'ANPE' ? 'selected' : '' }}>ANPE</option>
                                    </select>
                                </div>
                                @endif
                            </div>
                            @if($offre->user_id != 1)
                            <div class="form-group">
                                <input type="text" class="form-control" value="{{ $offre->offre_liensoumission }}" name="liensoumission" placeholder="Entrer le mail ou lien de soumission">
                            </div>
                            @endif
                            <div class="form-group">
                                <label>Description</label>
                                <textarea id="summernote" class="form-control" name="description"><?php echo html_entity_decode($offre->offredescription) ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Mission</label>
                                <textarea class="form-control" id="exampleMission" name="mission" rows="3"><?php echo html_entity_decode($offre->offre_mission) ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Profil</label>
                                <textarea id="OffreProfil" name="profil"><?php echo html_entity_decode($offre->offre_profil) ?></textarea>
                            </div>
                            <div class="form-group">
                                <label>Composition du dossier</label>
                                <textarea id="CompositionDossier" name="dossier"><?php echo html_entity_decode($offre->offre_dossier) ?></textarea>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Enregistrer les modifications</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection