@extends('layouts.appp')

@section('title')
    Publier une offre
@endsection

@section('titre')
    Publier une offre
@endsection

@section('content')
<script>
document.addEventListener('DOMContentLoaded', function() {
  var soumissionSelect = document.getElementById('soumission-select');
  var liensoumissionGroup = document.getElementById('liensoumission-group');
  var liensoumissionInput = document.querySelector('input[name="liensoumission"]');
  var liensoumissionError = document.getElementById('liensoumission-error');

  soumissionSelect.addEventListener('change', function() {
    var selectedOption = soumissionSelect.value;

    if (selectedOption === 'ANPE') {
      liensoumissionGroup.style.display = 'none';
      liensoumissionInput.removeAttribute('required');
      liensoumissionInput.value = '';
      liensoumissionError.textContent = '';
    } else {
      liensoumissionGroup.style.display = 'block';
      liensoumissionInput.setAttribute('required', 'required');
      
      if (selectedOption === 'PAR MAIL') {
        liensoumissionInput.setAttribute('type', 'email');
        liensoumissionError.textContent = 'Entrer un email valide';
      } else if (selectedOption === 'LIEN SITE WEB') {
        liensoumissionInput.setAttribute('type', 'url');
        liensoumissionError.textContent = 'Entrer une URL valide';
      } else {
        liensoumissionInput.setAttribute('type', 'text');
        liensoumissionError.textContent = '';
      }
    }
  });

  soumissionSelect.dispatchEvent(new Event('change'));
});
</script>
<div class="container-fluid">
    <div class="page-titles">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
            <li class="breadcrumb-item"><a href="javascript:void(0)">Gérer les offres</a></li>
            <li class="breadcrumb-item active"><a href="javascript:void(0)">Publier une offre</a></li>
        </ol>
    </div>
    <div class="row">
        <div class="col-xl-12 col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Enregistrer une nouvelle offre</h4>
                    <a href="{{ route('gestionoffre') }}" class="btn btn-primary float-end"><i class="fa fa-tasks"></i> Liste Offres</a>
                </div>
                <div class="card-body">
                    <div class="basic-form">
                        <form method="POST" action="{{ route('SavePublierOffre') }}">
                            @csrf
                            <div class="row mb-3">
                                <div class="col-md-12">
                                    <label>Titre de l'offre</label>
                                    <input type="text" class="form-control @error('titre') is-invalid @enderror" required name="titre" value="{{ old('titre') }}" placeholder="Exemple : Développeur Web *">
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Lieu</label>
                                    <select id="multi-value-select" multiple="multiple" name="region_ids[]" required>
                                        <option value="">Choisir un ou des lieu(x) *</option>
                                        @foreach($regions as $region)
                                            <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Type de Contrat</label>
                                    <select id="contrat-select" class="form-control rounded @error('typecontrat_id') is-invalid @enderror" required name="typecontrat_id">
                                        <option value="">Sélectionnez un type de contrat *</option>
                                        @foreach($typecontrat as $contrat)
                                            <option value="{{ $contrat->typecontrat_id }}" {{ old('typecontrat_id') == $contrat->typecontrat_id ? 'selected' : '' }}>{{ $contrat->typecontratlib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Type de métier </label>
                                    <select id="metier-select" class="form-control rounded @error('metier_id') is-invalid @enderror" name="metier_id">
                                        <option value="">Sélectionnez un métier *</option>
                                        @foreach($metiers as $metier)
                                            <option value="{{ $metier->metier_id }}" {{ old('metier_id') == $metier->metier_id ? 'selected' : '' }}>{{ $metier->metier_libelle }}</option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-md-6">
                                    <label>Niveau d'étude</label>
                                    <select id="diplome-select" class="form-control rounded @error('diplome_id') is-invalid @enderror" required name="diplome_id">
                                        <option value="">Sélectionnez une niveau d'étude</option>
                                        @foreach($diplomes as $diplome)
                                            <option value="{{ $diplome->diplome_id }}" {{ old('diplome_id') == $diplome->diplome_id ? 'selected' : '' }}>{{ $diplome->diplomelib }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Année d'expérence</label>
                                    <input type="text" class="form-control rounded @error('annexperience') is-invalid @enderror" name="annexperience" value="{{ old('annexperience') }}" placeholder="Année d'expérence">
                                </div>
                                <div class="col-md-6">
                                    <label>Nombre de Poste</label>
                                    <input type="text" onkeypress="isInputNumber(event)" class="form-control rounded @error('nombreposte') is-invalid @enderror" name="nombreposte" value="{{ old('nombreposte') }}" placeholder="Nombre de poste">
                                </div> 
                            </div>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label>Date de clôture</label>
                                    <input type="date" min="<?php echo date('Y-m-d'); ?>" class="form-control rounded @error('datefin') is-invalid @enderror" name="datefin" value="{{ old('datefin') }}">
                                </div>
                                <div class="col-md-6">
                                    <label>Soumission</label>
                                    <select class="form-control" required name="soumission" required id="soumission-select">
                                      <option value="">Par quoi soumettre l'offre ?</option>
                                      <option value="PAR MAIL" {{ old('soumission') == 'PAR MAIL' ? 'selected' : '' }}>Par email</option>
                                      <option value="LIEN SITE WEB" {{ old('soumission') == 'LIEN SITE WEB' ? 'selected' : '' }}>Lien site Web</option>
                                      <option value="ANPE" {{ old('soumission') == 'AUCUN' ? 'selected' : '' }}>ANPE</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group" id="liensoumission-group">
                              <label>Lien ou mail de soumission</label>
                              <input type="text" class="form-control" name="liensoumission" placeholder="Entrer le mail ou le lien de soumission">
                              <span id="liensoumission-error" class="text-danger"></span>
                            </div>
                            <div class="form-group">
                                <label>Description</label>
                                <textarea id="summernote" class="form-control" name="description">{{ old('description') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label>Mission</label>
                                <textarea class="form-control" id="exampleMission" name="mission" rows="3">{{ old('mission') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label>Profil</label>
                                <textarea id="OffreProfil" name="profil">{{ old('profil') }}</textarea>
                            </div>
                            <div class="form-group">
                                <label>Composition du dossier</label>
                                <textarea id="CompositionDossier" name="dossier">{{ old('dossier') }}</textarea>
                            </div>
                            <div class="form-group">
                                <button type="submit" class="btn btn-primary">Publier l'offre</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>            
    function isInputNumber(evt){
        
        var ch = String.fromCharCode(evt.which);
        
        if(!(/[0-9]/.test(ch))){
            evt.preventDefault();
        }        
    }    
</script>
@endsection