@extends('layouts.app')

@section('title')
    Création de compte employeur
@endsection

@section('content')
<script type="text/javascript" src="{{ asset('js/jquery.validate.js') }}"></script>
<script type="text/javascript" src="{{ asset('js/additional-methods.js') }}"></script>
<style>
    .login-lien a{
        color: orange;
        font-size: 20px;
        font-weight: bold;
    }
    .login-lien a:hover{
        color: green;
    }
    #personal_information, #company_information{
        display:none;
    }
    .has-error, #politiqueconfidentialite{
        color: red !important;
        font-style: italic;
        margin-top: 3px;
    }
</style>
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Création de compte employeur</h1>
                </div>                
            </div>
        </div>
    </div>
</div>
<section class="space min">
    <div class="container">        
        <div class="row align-items-center">
            <div class="col-lg-10 col-md-10 mx-auto">
                <div class="pricing_wrap">
                    <form class="_apply_form_form" method="POST" action="{{ route('register') }}" id="myform" enctype="multipart/form-data">   
                        @csrf  
                        <input type="hidden" name="code" value="2">
                        <fieldset id="account_information" class="">
                            <legend class="text-center">Etape 1 : Information Générale</legend><hr>
                            <div class="row">
                                <div class="col-md-12">  
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Designation <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control @error('raisonsociale') is-invalid @enderror"  name="raisonsociale" value="{{ old('raisonsociale') }}" placeholder="Raison sociale" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Adresse <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control @error('adresse') is-invalid @enderror"  name="adresse" value="{{ old('adresse') }}" placeholder="Adresse" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Contact <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control @error('contact') is-invalid @enderror"  name="contact" id="contact" value="{{ old('contact') }}" placeholder="+227 20 73 33 84" onkeypress="isInputNumber(event)">
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Nom & Prénoms Interlocuteur <span style="color:red">*</span></label>
                                        <input type="text" class="form-control @error('nom') is-invalid @enderror" name="nom" required value="{{ old('nom') }}" placeholder="Entrer votre nom & prénoms" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Contact Interlocuteur</label>
                                        <input type="text" class="form-control" name="contactinterlo" id="numero" value="{{ old('contactinterlo') }}" placeholder="+227 20 73 33 84" onkeypress="isInputNumber(event)">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Qualité <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control @error('qualite') is-invalid @enderror"  name="qualite" value="{{ old('qualite') }}" placeholder="Qualité" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Homme <span style="color:red">*</span></label>
                                        <input type="text" class="form-control" name="nbrehomme" value="{{ old('nbrehomme') }}" placeholder="Nombre d'homme" onkeypress="isInputNumber(event)">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Femme <span style="color:red">*</span></label>
                                        <input type="text" class="form-control" name="nbrfemme" value="{{ old('nbrfemme') }}" placeholder="Nombre de femme" onkeypress="isInputNumber(event)">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Activité <span style="color:red">*</span></label>
                                        <input type="text" required class="form-control @error('activite') is-invalid @enderror"  name="activite" value="{{ old('activite') }}" placeholder="Activité" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>
                            </div> 
                            <p><center><a class="btn btn-md theme-bg text-light next">Suivant <i class="lni lni-arrow-right-circle ml-2"></i></a></center></p>
                        </fieldset>
                        <fieldset id="company_information" class="">
                            <legend><center>Etape 2 : Information Entreprise</center></legend><hr>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Nationalité <span style="color:red">*</span></label>
                                        <select class="form-control" name="nationalite_id">
                                            <option value="">Choisissez une nationalité</option>
                                            @foreach($nationalites as $nationalite)
                                                <option value="{{ $nationalite->nationalite_id }}" {{ old('nationalite_id') == $nationalite->nationalite_id ? 'selected' : '' }}>{{ $nationalite->nationalite_lib }}</option>
                                            @endforeach
                                        </select>
                                    </div> 
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Région <span style="color:red">*</span></label>
                                        <select class="form-control" name="region_id">
                                            <option value="">Choisissez une region</option>
                                            @foreach($regions as $region)
                                                <option value="{{ $region->region_id }}" {{ old('region_id') == $region->region_id ? 'selected' : '' }}>{{ $region->region_nom }}</option>
                                            @endforeach
                                        </select>
                                    </div> 
                                </div>
                            </div> 
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Branche d'activité <span style="color:red">*</span></label>
                                        <select class="form-control" name="secteuractivite_id">
                                            <option value="">Choisissez une branche d'activité</option>
                                            @foreach($activites as $activite)
                                                <option value="{{ $activite->secteuractivite_id }}" {{ old('secteuractivite_id') == $activite->secteuractivite_id ? 'selected' : '' }}>{{ $activite->secteuractivitelib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div> 
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Situation de l'entreprise <span style="color:red">*</span></label>
                                        <select class="form-control" name="situationentreprise_id" id="situationentreprise_id">
                                            <option value="">Choisissez une situation de l'entreprise</option>
                                            @foreach($situations as $situation)
                                                <option value="{{ $situation->situationentreprise_id }}" {{ old('situationentreprise_id') == $situation->situationentreprise_id ? 'selected' : '' }}>{{ $situation->situationentreprise_lib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Statut <span style="color:red">*</span></label>
                                        <select class="form-control" name="statutentreprise_id" id="statutentreprise_id">
                                            <option value="">Choisissez un statut</option>
                                            @foreach($statuts as $statut)
                                                <option value="{{ $statut->statutentreprise_id }}" {{ old('statutentreprise_id') == $statut->statutentreprise_id ? 'selected' : '' }}>{{ $statut->statutentreprise_lib }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>  
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">N° CNSS</label>
                                        <input type="text" class="form-control"  name="ncnss" value="{{ old('ncnss') }}" placeholder="Entre le numéro CNSS" onkeyup="this.value=this.value.toUpperCase()">
                                    </div>
                                </div>                               
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Logo</label>
                                        <input type="file" class="form-control" id="entreprise_logo" name="entreprise_logo">
                                    </div>                            
                                </div>    
                            </div>
                            <div class="jbd-02 px-3 py-3 br-top">
                                <div class="jbd-02-flex d-flex align-items-center justify-content-between">
                                    <div class="jbd-02-social">
                                        <p><a class="btn btn-md bg-dark text-light hover-theme" id="previous"><i class="lni lni-arrow-left-circle mr-2"></i> Précédent</a></p>
                                    </div>
                                    <div class="jbd-02-aply">
                                        <div class="jbl_button mb-2">
                                            <a class="btn btn-md theme-bg text-light fs-sm ft-medium next">Suivant <i class="lni lni-arrow-right-circle ml-2"></i></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>  
                        <fieldset id="personal_information" class="">
                            <legend><center>Etape 3 : Information du compte</center></legend><hr>
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Adresse email</label>
                                        <input type="email" class="form-control" id="email" name="email" placeholder="Adresse email">
                                    </div>                            
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Mot de passe</label>
                                        <input type="password" class="form-control" id="password" name="password" placeholder="Mot de passe">
                                    </div>                            
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label class="text-dark mb-1 ft-medium medium">Confirmer mot de passe</label>
                                        <input type="password" class="form-control" id="conf_password" name="conf_password" placeholder="Confirmer mot de passe">
                                    </div>
                                </div>
                            </div>                                
                            <div class="jbd-02 px-3 py-3 br-top">
                                <div class="jbd-02-flex d-flex align-items-center justify-content-between">
                                    <div class="jbd-02-social">
                                        <p><a class="btn btn-md bg-dark text-light hover-theme" id="previous"><i class="lni lni-arrow-left-circle mr-2"></i> Précédent</a></p>
                                    </div>
                                    <div class="jbd-02-aply">
                                        <div class="jbl_button mb-2">
                                            <button type="submit" class="btn btn-md theme-bg text-light fs-sm ft-medium">Valider <i class="fas fa-check small ml-2"></i></button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </fieldset>                                                
                    </form>
                </div>
            </div>
        </div>        
    </div>
</section>
<script type = "text/javascript">
    $(document).ready(function () {

        // Custom method to validate nom
        /*$.validator.addMethod("nomRegex", function (value, element) {
            return this.optional(element) || /^[a-zA-Z0-9]*$/i.test(value);
        }, "Le nom d'utilisateur ne doit contenir que des lettres, des chiffres");*/

      $(".next").click(function (){
         var form = $("#myform");
         form.validate({
            errorElement: 'span',
            errorClass: 'help-block',
            highlight: function (element, errorClass, validClass) {
               $(element).closest('.form-group').addClass("has-error");
            },
            unhighlight: function (element, errorClass, validClass) {
               $(element).closest('.form-group').removeClass("has-error");
            },
            rules: {
               nom: {
                  required: true,
                  minlength: 4,
               },
               adresse: {
                  required: true,
                  minlength: 4,
               },
               raisonsociale: {
                  required: true,
                  minlength: 4,
               },
               qualite: {
                  required: true,
               },
               activite: {
                  required: true,
                  minlength: 4,
               },
                contact: {
                  required: true,
                  minlength: 8,
                  maxlength: 13,
               },
               nationalite_id: {
                  required: true,
               },
               region_id: {
                  required: true,
               },
               situationentreprise_id: {
                  required: true,
               },
                secteuractivite_id: {
                  required: true,
               },
                statutentreprise_id: {
                  required: true,
               },
               password: {
                  required: true,
                  minlength: 6,
               },
               conf_password: {
                  required: true,
                  equalTo: '#password',
               },
               email: {
                  required: true,
                  minlength: 6,
                  email: true,
               },
               entreprise_logo: {
                  extension: "png|jpg|jpeg"
               },

            },
            messages: {
               nom: {
                  required: "Le nom & prénoms est obligatoire",
                  minlength: "Le nom doit être d'au moins 3 caractères",
               },
               adresse: {
                  required: "L'adresse est obligatoire",
                  minlength: "L'adresse doit être d'au moins 3 caractères",
               },
               raisonsociale: {
                  required: "La raison sociale est obligatoire",
                  minlength: "La raison sociale doit être d'au moins 3 caractères",
               },
               qualite: {
                  required: "La qualité de l'interlocuteur est obligatoire",
               },
               activite: {
                  required: "L'activité partiquée par l'entreprise est obligatoire",
                  minlength: "L'activité partiquée par l'entreprise doit être d'au moins 3 caractères",
               },
               contact: {
                  required: "Le contact est obligatoire",
                  minlength: "Le contact doit être d'au moins 8 caractères",
                  maxlength: "Le contact ne doit pas dépasser 13 caractères",
               },
               nationalite_id: {
                  required: "La nationalité de l'entreprise est obligatoire",
               },
               region_id: { 
                  required: "La région est obligatoire",
               },
               secteuractivite_id: {
                  required: "La branche d'activité de l'entreprise est obligatoire",
               },
               statutentreprise_id: {
                  required: "Le statut actuelle de l'entrprise est obligatoire",
               },
               situationentreprise_id: {
                  required: "La situation actuelle de l'entrprise est obligatoire",
               },
               password: {
                  required: "Mot de passe obligatoire",
                  minlength: "Entrer un mot de passe d'au moins 6 caractères",
               },
               conf_password: {
                  required: "Mot de passe obligatoire",
                  equalTo: "Le mot de passe ne correspond pas",
               },
               email: {
                  required: "L'adresse mail est obligatoire",
                  minlength: "Entrer une adresse mail d'au moins 6 caractères",
                  email: "L'adresse mail n'est pas valide",
               },
               entreprise_logo: {
                  extension: "Le logo de l'entreprise doit être une image de type PNG, JPG ou JPEG",
               },
            }
        });
        if(form.valid() === true){
            if($('#account_information').is(":visible")){
               current_fs = $('#account_information');
               next_fs = $('#company_information');
            }else if($('#company_information').is(":visible")){
               current_fs = $('#company_information');
               next_fs = $('#personal_information');
            }

            next_fs.show();
            current_fs.hide();
        }
      });

      $('#previous').click(function(){
        if($('#company_information').is(":visible")){
            current_fs = $('#company_information');
            next_fs = $('#account_information');
        }else if ($('#personal_information').is(":visible")){
            current_fs = $('#personal_information');
            next_fs = $('#company_information');
        }
        next_fs.show(); 
        current_fs.hide();
    });
   }); 
</script>
<script>
    function isInputNumber(evt){
        
        var ch = String.fromCharCode(evt.which);
        
        if(!(/[0-9]/.test(ch))){
            evt.preventDefault();
        }        
    } 
    
    function verifierValeur() {
        // récupération de la date de naissance entrée par l'utilisateur
        var datenaissance = document.getElementById("datenaissance").value;

        // conversion de la date de naissance en objet Date
        var dateNaissanceObj = new Date(datenaissance);

        // calcul de l'âge de l'utilisateur en années
        var age = (new Date().getTime() - dateNaissanceObj.getTime()) / (1000 * 60 * 60 * 24 * 365.25);

        // vérification que l'utilisateur a au moins 18 ans
        if (age < 18) {
            // affichage d'un message d'erreur
            alert("Vous devez avoir au moins 18 ans pour continuer.");
            document.getElementById("datenaissance").value = "";
            // annulation de l'envoi du formulaire
            return false;
        }
        return true;
    } 
</script>
<script>
    $(document).ready(function() {
        $('#pays_id').change(function() {
            var pays_id = $(this).val();
            //alert(pays_id);

            if(pays_id == 157){
                $('#cni').show();
                $('#etranger').hide();
            }else{
                $('#etranger').show();
                $('#cni').hide();
            }
        });
    });
</script>
@endsection