@extends('layouts.app')
@section('title')
    Conseil pour faire un entretien d'embauche
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">8 conseils pour réussir son entretien d'embauche</h1>
                    <nav class="transparent">
						<ol class="breadcrumb p-0">
							<li class="breadcrumb-item"><a href="{{ route('accueil') }}" style="color:#FFF !important">Accueil</a></li>
                            <li class="breadcrumb-item text-white">Conseils</li>
							<li class="breadcrumb-item active theme-cl" aria-current="page">Conseil pour faire un entretien d'embauche</li>
						</ol>
					</nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="bg-light py-5 position-relative">
    <div class="container">
        <div class="row">
            
            <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">
            
                <div class="bg-white rounded px-3 py-4 mb-4">
                    <div class="jbd-01 d-flex align-items-center justify-content-between">
                        <div class="jbd-flex d-flex align-items-center justify-content-start">                            
                            <div class="jbd-01-caption pl-3">
                                <h1>8 conseils pour réussir son entretien d'embauche</h1>
                                <p>Dress-code, langage, communication non-verbale... Au-delà de votre parcours professionnel et votre habilité à bien le présenter, les recruteurs sont également sensibles à votre attitude en entretien. Autant d'éléments à prendre en compte pour le jour J.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded mb-4">
                    <div class="jbd-01 px-3 py-4">                        
                        <div class="jbd-details mb-3">
                            <h5>1. Tourner 7 fois sa langue dans sa bouche avant de parler</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Nous avons tous des tics de langage. Mais entre une discussion informelle entre amis et un entretien d'embauche, certains sont à proscrire, d'autant que cela peut être horripilant. Les "hein", "heu", "quoi" qui ponctuent les phrases sont à bannir, et ce, même si vous êtes un peu stressé. De même que les fautes de français : plus jamais de "si j'avais su, j'aurais pas venu" !</p>
                                </div>
                            </div><br>
                            <h5>2. La forme, c'est le fond qui remonte à la surface</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Votre CV est béton, votre parcours professionnel colle parfaitement à l'annonce à laquelle vous postulez. Et pourtant, le jour de l'entretien, vous n'arrivez pas à convaincre le recruteur ? Pour qu'un discours soit entendu, qu'importe le fond, il faut y mettre les formes. En clair, il est nécessaire de maîtriser l'intonation de sa voix pour mieux vendre votre présentation. En effet, il est difficile de croire qu'un candidat est dynamique s'il le dit d'une voix trop "molle"... Pensez aussi à la manière dont vous vous tenez face à votre interlocuteur, à votre jeu de mains ainsi qu'à votre regard. Même si cela peut paraître secondaire, le recruteur sera forcément sensible à la manière dont vous vous comportez.</p>
                                </div>
                            </div><br>
                            <h5>3. Victime d'un mauvais dress code ?</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>En entretien vous êtes jugé à "55% sur votre apparence, à 38% sur votre gestuelle et à seulement 7% sur vos propos", explique Virginie le Cozic, directrice d'une agence de conseil en image. Si on peut regretter ce "diktat de l'apparence", une tenue adaptée en entretien est cependant un prérequis attendu du recruteur. A moins de travailler dans le milieu de la mode, le protocole veut que vous vous présentiez sous votre meilleur jour en entretien d'embauche. Pas besoin pour autant d'adopter la panoplie complète du cadre dynamique : soyez-vous mêmes, faites confiance à votre bon sens et à ce que vous connaissez de l'entreprise mais évitez les tenues clivantes.</p>
                                </div>
                            </div><br>
                            <h5>4. Soyez inflexible avec la ponctualité</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Jamais, ô grand jamais, vous ne devez être en retard à un entretien d'embauche, même si votre interlocuteur vous laisse ensuite poireauter. En cas d'imprévu, prévenez l'entreprise et faites votre mea culpa. Cela est considéré comme la moindre des politesses... Après l'entretien, vous pouvez même renouveler vos excuses par mail, pour faire comprendre à quel point cela ne fait pas partie de vos habitudes.</p>
                                </div>
                            </div><br>
                            <h5>5. De l'art de discourir spontanément</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Pour réussir son entretien d'embauche, il est nécessaire de l'avoir bien préparé. Sur la forme comme nous l'avons évoqué précédemment mais aussi sur le fond. Cela vous permettra d'être cohérent lors de votre présentation et de répondre du tac au tac aux questions du recruteur. Vous ne serez pas déstabilisé et vous pourrez alors lâcher vos fiches pour afficher un discours plus spontané. La confiance en soi est toujours payante : elle rassurera votre interlocuteur. Un bon point pour l'étape d'après !</p>
                                </div>
                            </div><br>
                            <h5>6. Parlez-moi de vous...</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Cette question piège demeure un classique de l'entretien d'embauche. Rien ne sert de stresser : le recruteur n'attend pas de vous un long monologue depuis votre naissance à aujourd'hui. Au contraire, le but est de tester votre capacité à synthétiser un discours clair en lien avec le poste et votre présence en entretien. Alors n'en faites pas des tonnes, soyez concis mais clair et vendeur... S'il a des questions à la fin de votre présentation, votre interlocuteur n'hésitera pas à vous les poser.</p>
                                </div>
                            </div><br>
                            <h5>7. Mon ancienne entreprise ? Tous des c... !</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>S'il est une chose à ne jamais faire, c'est bien de dire du mal de votre ancienne entreprise, ou de vos anciens collègues, hiérarchiques ou non. Même si c'est une des raisons pour lesquelles vous cherchez à partir, vous devrez légitimer votre actuel choix de carrière par un argument professionnel. Personne n'aime être critiqué et encore moins savoir qu'il pourra l'être...</p>
                                </div>
                            </div><br>
                            <h5>8. Au revoir, et merci</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Dernier point important lors d'un entretien d'embauche, la manière dont vous y mettez un terme. Si un recruteur vous demande à la toute fin si vous avez des questions, il est vital d'avoir noté - par écrit éventuellement - dans un coin de votre tête les points que vous souhaitez approfondir. Cela signifie que vous vous projetez déjà dans le poste et que vous prenez les choses à cœur. Enfin, pour conclure l'entretien, il est de rigueur de remercier votre interlocuteur, de lui dire au revoir et, encore mieux, de saluer les autres personnes qui vous ont accueilli. Sinon, le ou la personne à l'accueil aura vite fait de vous tailler un costard... Toutes ces personnes feront peut-être bientôt partie de votre quotidien !</p>
                                </div>
                            </div><br>
                        </div>                        
                    </div>
                </div>                
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">            
                <img src="{{ asset('assets/img/redactionlettremotivation.png') }}" style="width:400px">        
            </div>
        </div>
    </div>
</section>
@endsection