@extends('layouts.appp')

@section('content')
<div class="container">
    <div class="row">
        <div class="col-md-12">
            <canvas id="myChart"></canvas>
        </div>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    var ctx = document.getElementById('myChart').getContext('2d');
    var myChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['Janv', 'Févr', 'Mars', 'Avr', 'Mai', 'Juin', 'Juill', 'Août', 'Sept', 'Oct', 'Nov', 'Déc'],
            datasets: [{
                label: 'Comptes Traités',
                data: @json($data_users),
                fill: false,
                backgroundColor: 'rgba(1, 153, 0)',
                borderColor: 'rgba(1, 153, 0)',
                borderWidth: 1
            }, {
                label: 'Comptes non Traités',
                data: @json($data_user_brouillons),
                fill: false,
                backgroundColor: 'rgb(249, 57, 57)',
                borderColor: 'rgb(249, 57, 57)',
                borderWidth: 1
            }, {
                label: 'Candidatures en Attentes',
                data: @json($data_abonnements),
                fill: false,
                backgroundColor: 'rgba(248, 255, 0)',
                borderColor: 'rgba(248, 255, 0)',
                borderWidth: 1
            }, {
                label: 'Candidatures Approuvées',
                data: @json($data_contrats),
                fill: false,
                backgroundColor: 'rgba(4, 15, 136)',
                borderColor: 'rgba(4, 15, 136)',
                borderWidth: 1
            },

            ]
        },
        options: {
            scales: {
                yAxes: [{
                    ticks: {
                        beginAtZero: true
                    }
                }]
            }
        }
    });
</script>

@endsection

