@extends('layouts.appp')

@section('title')
    Tableau de bord
@endsection

@section('titre')
    Tableau de bord
@endsection

@section('content')

@if(Auth::user()->profil_id ==1)
<style>
    .position{
        font-size: 16px !important;
    }
</style>
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-12 col-xxl-12">    
            <div class="row">
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <a href="{{ route('gestioncandidat') }}">
                        <div class="card border-card">
                            <div class="card-body">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-success">
                                            @if($candidat > 1000)
                                                <?php
                                                    $candidat_premiers_caracteres = substr($candidat, 0, 2);
                                                    echo $candidat_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $candidat }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-success">
                                        <i class="fa fa-users"></i>
                                    </span>
                                </div>
                                <span class="position">Nombre de demandeur d'emploi</span>
                            </div>
                            <span class="line bg-success"></span>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <a href="{{ route('gestionemployeur') }}">
                        <div class="card border-card">
                            <div class="card-body">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-info">
                                            @if($employeur > 1000)
                                                <?php
                                                    $employeur_premiers_caracteres = substr($employeur, 0, 2);
                                                    echo $employeur_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $employeur }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-info">
                                        <i class="fa fa-users"></i>
                                    </span>
                                </div>                                  
                                <span class="position">Nombre de recruteur</span>
                            </div>
                            <span class="line bg-info"></span>
                        </div>
                    </a>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="{{ route('gestionoffreavalider') }}">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-primary">
                                            @if($offre_avalider > 1000)
                                                <?php
                                                    $offre_avalider_premiers_caracteres = substr($offre_avalider, 0, 2);
                                                    echo $offre_avalider_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $offre_avalider }} 
                                            @endif
                                        </h2>                                  
                                    </div>
                                    <span class="cd-icon bgl-primary">
                                        <i class="fa fa-graduation-cap"></i>
                                    </span>
                                </div>
                                <span class="position">Nombre d'offre à valider</span>
                            </a>
                        </div>
                        <span class="line bg-primary"></span>
                    </div>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="{{ route('candidatureavalider') }}">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-warning">
                                            @if($candidature_avalider > 1000)
                                                <?php
                                                    $candidature_avalider_premiers_caracteres = substr($candidature_avalider, 0, 2);
                                                    echo $candidature_avalider_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $candidature_avalider }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-warning">
                                        <i class="fa fa-graduation-cap"></i>
                                    </span>
                                </div>
                                 <span class="position">Nombre de demande d'emploi à valider</span>
                            </a>
                        </div>
                        <span class="line bg-warning"></span>
                    </div>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="javascript::void(0)">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-success">
                                            @if($candidat_femme > 1000)
                                                <?php
                                                    $candidat_femme_premiers_caracteres = substr($candidat_femme, 0, 2);
                                                    echo $candidat_femme_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $candidat_femme }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-success">
                                        <i class="fa fa-female"></i>
                                        <i class="fa fa-female"></i>
                                    </span>
                                </div>
                                <span class="position">Nombre de femmme demandeur d'emploi</span>
                            </a>
                        </div>
                        <span class="line bg-success"></span>
                    </div>
                </div>
                <div class="col-xl-4 col-xxl-4 col-lg-4 col-sm-4">
                    <div class="card border-card">
                        <div class="card-body">
                            <a href="javascript::void(0)">
                                <div class="media">
                                    <div class="media-body mr-3">
                                        <h2 class="text-danger">
                                            @if($candidat_homme > 1000)
                                                <?php
                                                    $candidat_homme_premiers_caracteres = substr($candidat_homme, 0, 2);
                                                    echo $candidat_homme_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $candidat_homme }} 
                                            @endif
                                        </h2>
                                    </div>
                                    <span class="cd-icon bgl-danger">
                                        <i class="fa fa-male"></i>
                                        <i class="fa fa-male"></i>
                                    </span>
                                </div>
                                <span class="position">Nombre d'homme demandeur d'emploi</span>
                            </a>
                        </div>
                        <span class="line bg-danger"></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Les derniers candidats sous contrats</h4>
                    <div class="float-end">
                        <a href="{{ route('gestioncontrat') }}" class="btn btn-info"><i class="fa fa-list"></i> Voir la liste</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped table-responsive-sm">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Nom & Prénoms</th>
                                    <th>Email</th>
                                    <th>Téléphone</th>
                                    <th>Type de contrat</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($dernierscontrats as $candidat)
                                <tr>
                                    <th>{{ $candidat->candidature_id }}</th>
                                    <td>{{ $candidat->name }} {{ $candidat->prenoms }}</td>
                                    <td>{{ $candidat->email }}</td>
                                    <td>{{ $candidat->telephone }}</td>
                                    <td><span class="badge badge-success">{{ $candidat->typecontratlib }}</span></td>
                                </tr>
                                @empty
                                    <tr>
                                        <td colspan="5" class="text-center">Aucun candidat n'est sous contrat actuellement</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endif

@if(Auth::user()->profil_id ==2)
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-9 col-xxl-8">    
            <div class="row">
                <div class="col-xl-6 col-xxl-6 col-lg-6 col-sm-6">
                    <div class="card border-card">
                        <div class="card-body">
                            <div class="media"> 
                                <a href="{{ route('listecandidature') }}">                               
                                    <div class="media-body mr-3">
                                        <h2 class="text-success">
                                            @if($abonne_nombre > 1000)
                                                <?php
                                                    $abonne_nombre_premiers_caracteres = substr($abonne_nombre, 0, 2);
                                                    echo $abonne_nombre_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $abonne_nombre }} 
                                            @endif
                                        </h2>
                                        <span class="position">Nombre de demandeur d'emploi</span>
                                    </div>
                                </a>
                                <span class="cd-icon bgl-success">
                                    <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M38.4998 10.4995H35.0002V38.4999H38.4998C40.4245 38.4999 42 36.9238 42 34.9992V13.9992C42 12.075 40.4245 10.4995 38.4998 10.4995Z" fill="#2BC155"/>
                                        <path d="M27.9998 10.4995V6.9998C27.9998 5.07515 26.4243 3.49963 24.5001 3.49963H17.4998C15.5757 3.49963 14.0001 5.07515 14.0001 6.9998V10.4995H10.5V38.4998H31.5V10.4995H27.9998ZM24.5001 10.4995H17.4998V6.99929H24.5001V10.4995Z" fill="#2BC155"/>
                                        <path d="M3.50017 10.4995C1.57551 10.4995 0 12.075 0 13.9997V34.9997C0 36.9243 1.57551 38.5004 3.50017 38.5004H6.99983V10.4995H3.50017Z" fill="#2BC155"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <span class="line bg-success"></span>
                    </div>
                </div>
                <div class="col-xl-6 col-xxl-6 col-lg-6 col-sm-6">
                    <div class="card border-card">
                        <div class="card-body">
                            <div class="media">
                                <a href="{{ route('gestionoffre') }}">
                                    <div class="media-body mr-3">
                                        <h2 class="text-secondary">
                                            @if($offre_nombre > 1000)
                                                <?php
                                                    $offre_nombre_premiers_caracteres = substr($offre_nombre, 0, 2);
                                                    echo $offre_nombre_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $offre_nombre }} 
                                            @endif
                                        </h2>                                  
                                        <span class="position">Nombre d'offres publiées</span>
                                    </div>
                                </a>
                                <span class="cd-icon bgl-secondary">
                                    <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M33.25 8.75H31.5V5.25C31.5 4.78587 31.3156 4.34075 30.9874 4.01256C30.6593 3.68437 30.2141 3.5 29.75 3.5C29.2859 3.5 28.8407 3.68437 28.5126 4.01256C28.1844 4.34075 28 4.78587 28 5.25V8.75H14V5.25C14 4.78587 13.8156 4.34075 13.4874 4.01256C13.1592 3.68437 12.7141 3.5 12.25 3.5C11.7859 3.5 11.3408 3.68437 11.0126 4.01256C10.6844 4.34075 10.5 4.78587 10.5 5.25V8.75H8.75C7.35761 8.75 6.02226 9.30312 5.03769 10.2877C4.05312 11.2723 3.5 12.6076 3.5 14V15.75H38.5V14C38.5 12.6076 37.9469 11.2723 36.9623 10.2877C35.9777 9.30312 34.6424 8.75 33.25 8.75Z" fill="#3F9AE0"/>
                                        <path d="M3.5 33.25C3.5 34.6424 4.05312 35.9777 5.03769 36.9623C6.02226 37.9469 7.35761 38.5 8.75 38.5H33.25C34.6424 38.5 35.9777 37.9469 36.9623 36.9623C37.9469 35.9777 38.5 34.6424 38.5 33.25V19.25H3.5V33.25Z" fill="#3F9AE0"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <span class="line bg-secondary"></span>
                    </div>
                </div>
                <div class="col-xl-12 col-xxl-12 col-lg-12 col-md-12">
                    <div class="card border-card">
                        <div class="card-body">
                            <div class="media">                                
                                <div class="media-body mr-3">
                                    <a href="{{ route('listecandidature') }}">
                                        <h2 class="text-warning">
                                            @if($abonne_nombre > 1000)
                                                <?php
                                                    $abonne_nombre_premiers_caracteres = substr($abonne_nombre, 0, 2);
                                                    echo $abonne_nombre_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $abonne_nombre }} 
                                            @endif
                                        </h2>
                                    </a>
                                    <a href="{{ route('listecandidature') }}">
                                        <span class="position">Consulter la CV THEQUE</span>
                                    </a>
                                </div>                                
                                <span class="cd-icon bgl-warning">
                                    <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M15.1812 22.0083C15.0651 21.9063 14.7969 21.6695 14.7015 21.5799C12.3755 19.3941 10.8517 15.9712 10.8517 12.1138C10.8517 5.37813 15.4869 0.0410156 21.0011 0.0410156C26.5152 0.0410156 31.1503 5.37813 31.1503 12.1138C31.1503 15.9679 29.6292 19.3884 27.3094 21.5778C27.2118 21.6699 26.9385 21.9116 26.8238 22.0125L26.8139 22.1799C26.8789 23.1847 27.5541 24.0553 28.5233 24.3626C35.7277 26.641 40.9507 32.0853 41.8277 38.538C41.9484 39.3988 41.6902 40.2696 41.1198 40.9254C40.5495 41.5813 39.723 41.9579 38.8541 41.9579C32.4956 41.9591 9.50675 41.9591 3.14821 41.9591C2.27873 41.9591 1.45183 41.5824 0.881272 40.9263C0.310711 40.2701 0.0524068 39.3989 0.172348 38.5437C1.05148 32.0851 6.27447 26.641 13.4778 24.3628C14.4504 24.0544 15.1263 23.1802 15.1885 22.1722L15.1812 22.0083Z" fill="#FF9B52"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <span class="line bg-warning"></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-xxl-4">
            <div class="row">
                <div class="col-xl-12">
                    <div class="card d-flex flex-xl-column flex-sm-column flex-md-row flex-column">
                        <div class="card-body text-center border-bottom profile-bx">
                            <div class="profile-image mb-4">
                                @if(empty(Auth::user()->entreprise_logo))
                                    <img src="{{ asset('assets/img/entreprise/'.Auth::user()->entreprise_logo) }}" class="rounded-circle" alt="">
                                @endif
                            </div>
                            <h4 class="fs-22 text-black mb-1">{{ Auth::user()->name }} {{ Auth::user()->prenoms }}</h4>
                        </div>
                        <div class="card-body col-xl-12 col-md-6 col-sm-12 pb-0">
                            <h4 class="fs-18 text-black mb-3">Dernières offres publiées</h4>
                            @foreach($offre_recentes as $offre)
                                <div class="media mb-4">
                                    <span class="p-3 bgl-primary mr-3 rounded">
                                        <img src="{{ asset('assets/img/entreprise/'.Auth::user()->entreprise_logo) }}" class="img-fluid" width="55" alt="">
                                    </span>
                                    <div class="media-body">
                                        <p class="fs-12 mb-1 text-black font-w500">{{ $offre->offretitre }}</p>
                                        <span class="fs-12">{{ \Carbon\Carbon::parse($offre->offre_datecrea)->format('d/m/Y') }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12">
            <div class="d-sm-flex align-items-center mb-sm-3 mt-sm-2 mt-2  mb-2">
                <h4 class="fs-20 text-black mr-auto mb-sm-0 mb-2">Liste des offres avec candidature</h4>
                <a href="{{ route('gestionoffre') }}" class="btn btn-outline-primary rounded mb-sm-0 mb-1">Voir plus</a>
            </div>
            <div class="testimonial-one owl-carousel">
                @foreach($offres as $offre)
                    <a href="{{ route('employeur.detailsoffre',$offre->offre_id) }}">
                        <div class="items">
                            <div class="card">
                                <div class="card-body"> 
                                    <div class="d-flex mb-3">
                                        <span class="text-black mr-auto font-w500">{{ $offre->offretitre }}</span>
                                    </div>
                                    <div class="d-flex mb-3">
                                        <span class="text-black mr-auto font-w500">
                                            {{ $offre->name }} {{ $offre->prenoms }}
                                        </span>
                                        <span>
                                            {{ \Carbon\Carbon::parse($offre->candidature_datecrea)->format('d/m/Y') }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </a>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endif

@if(Auth::user()->profil_id ==3)
<div class="container-fluid">
    <div class="row">
        <div class="col-xl-9 col-xxl-8">    
            <div class="row">
                <div class="col-xl-6 col-xxl-6 col-lg-6 col-sm-6">
                    <div class="card border-card">
                        <div class="card-body">
                            <div class="media">
                                <a href="{{ route('mescandidatures') }}">
                                    <div class="media-body mr-3">
                                        <h2 class="text-success">
                                            @if($mes_candidature_valide > 1000)
                                                <?php
                                                    $mes_candidature_valide_premiers_caracteres = substr($mes_candidature_valide, 0, 2);
                                                    echo $mes_candidature_valide_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $mes_candidature_valide }} 
                                            @endif
                                        </h2>
                                        <span class="position">Candidatures validés</span>
                                    </div>
                                </a>
                                <span class="cd-icon bgl-success">
                                    <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M38.4998 10.4995H35.0002V38.4999H38.4998C40.4245 38.4999 42 36.9238 42 34.9992V13.9992C42 12.075 40.4245 10.4995 38.4998 10.4995Z" fill="#2BC155"/>
                                        <path d="M27.9998 10.4995V6.9998C27.9998 5.07515 26.4243 3.49963 24.5001 3.49963H17.4998C15.5757 3.49963 14.0001 5.07515 14.0001 6.9998V10.4995H10.5V38.4998H31.5V10.4995H27.9998ZM24.5001 10.4995H17.4998V6.99929H24.5001V10.4995Z" fill="#2BC155"/>
                                        <path d="M3.50017 10.4995C1.57551 10.4995 0 12.075 0 13.9997V34.9997C0 36.9243 1.57551 38.5004 3.50017 38.5004H6.99983V10.4995H3.50017Z" fill="#2BC155"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <span class="line bg-success"></span>
                    </div>
                </div>
                <div class="col-xl-6 col-xxl-6 col-lg-6 col-sm-6">
                    <div class="card border-card">
                        <div class="card-body">
                            <div class="media">
                                <a href="{{ route('mescandidatures') }}">
                                    <div class="media-body mr-3">
                                        <h2 class="text-secondary">
                                            @if($mes_candidature > 1000)
                                                <?php
                                                    $mes_candidature_premiers_caracteres = substr($mes_candidature, 0, 2);
                                                    echo $mes_candidature_premiers_caracteres.'K';
                                                ?>
                                            @else   
                                                {{ $mes_candidature }} 
                                            @endif
                                        </h2>
                                        <span class="position">Candidatures</span>
                                    </div>
                                </a>
                                <span class="cd-icon bgl-secondary">
                                    <svg width="42" height="42" viewBox="0 0 42 42" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <path d="M33.25 8.75H31.5V5.25C31.5 4.78587 31.3156 4.34075 30.9874 4.01256C30.6593 3.68437 30.2141 3.5 29.75 3.5C29.2859 3.5 28.8407 3.68437 28.5126 4.01256C28.1844 4.34075 28 4.78587 28 5.25V8.75H14V5.25C14 4.78587 13.8156 4.34075 13.4874 4.01256C13.1592 3.68437 12.7141 3.5 12.25 3.5C11.7859 3.5 11.3408 3.68437 11.0126 4.01256C10.6844 4.34075 10.5 4.78587 10.5 5.25V8.75H8.75C7.35761 8.75 6.02226 9.30312 5.03769 10.2877C4.05312 11.2723 3.5 12.6076 3.5 14V15.75H38.5V14C38.5 12.6076 37.9469 11.2723 36.9623 10.2877C35.9777 9.30312 34.6424 8.75 33.25 8.75Z" fill="#3F9AE0"/>
                                        <path d="M3.5 33.25C3.5 34.6424 4.05312 35.9777 5.03769 36.9623C6.02226 37.9469 7.35761 38.5 8.75 38.5H33.25C34.6424 38.5 35.9777 37.9469 36.9623 36.9623C37.9469 35.9777 38.5 34.6424 38.5 33.25V19.25H3.5V33.25Z" fill="#3F9AE0"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                        <span class="line bg-secondary"></span>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-xxl-4">
            <div class="row">
                <div class="col-xl-12">
                    <div class="card d-flex flex-xl-column flex-sm-column flex-md-row flex-column">
                        <div class="card-body text-center border-bottom profile-bx">
                            <div class="profile-image mb-4">
                                @if(!empty(Auth::user()->profil_photo))
                                    <img src="{{ asset('assets/img/profil/'.Auth::user()->profil_photo) }}" class="rounded-circle" alt="">
                                @else
                                    <img src="{{ asset('assets/img/profil/avatar.png') }}" class="rounded-circle" alt="">
                                @endif
                            </div>
                            <h4 class="fs-22 text-black mb-1">{{ Auth::user()->name }} {{ Auth::user()->prenoms }}</h4>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12">
            <div class="d-sm-flex align-items-center mb-sm-3 mt-sm-2 mt-2  mb-2">
                <h4 class="fs-20 text-black mr-auto mb-sm-0 mb-2">Offres qui peuvent vous interressé</h4>
                <a href="{{route('offres')}}" class="btn btn-outline-primary rounded mb-sm-0 mb-1">Voir Plus</a>
            </div>
            <div class="testimonial-one owl-carousel">
                @foreach($offre_publies as $offre)
                    <div class="items">
                        <div class="card">
                            <div class="card-body"> 
                                <div class="media pb-4 border-bottom mb-4 align-items-center">
                                    <img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" style="width: 80px !important; border: 2px solid #ccc;">                                
                                    <div class="media-body">
                                        <h4 class="fs-20"><a href="{{ route('detailsuneoffre',[$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="text-black">{{ $offre->offretitre }}</a></h4>
                                        <div class="d-flex">
                                            <p class="mb-0 mr-auto">{{ $offre->raisonsociale }}</p>
                                            <a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn-link">+ Détails</a>
                                        </div>
                                    </div>
                                </div>
                                <div class="d-flex mb-3">
                                    <span class="text-black mr-auto font-w500">
                                        <svg class="mr-3" width="28" height="28" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M12 0C6.93398 0 2.8125 4.12148 2.8125 9.1875C2.8125 10.8091 3.24094 12.4034 4.05145 13.7979C4.24041 14.123 4.45162 14.4398 4.67934 14.7396L11.6008 24H12.3991L19.3207 14.7397C19.5483 14.4398 19.7595 14.1231 19.9485 13.7979C20.7591 12.4034 21.1875 10.8091 21.1875 9.1875C21.1875 4.12148 17.066 0 12 0ZM12 12.2344C10.32 12.2344 8.95312 10.8675 8.95312 9.1875C8.95312 7.50745 10.32 6.14062 12 6.14062C13.68 6.14062 15.0469 7.50745 15.0469 9.1875C15.0469 10.8675 13.68 12.2344 12 12.2344Z" fill="#A9A9A9"/>
                                        </svg>
                                    {{ $offre->pays_nom }}, {{ $offre->offre_ville }}</span>
                                    <span>{{ $offre->contrat->typecontratlib }}</span>
                                </div>
                            </div>
                        </div>
                    </div>
                @endforeach
            </div>
        </div>
    </div>
</div>
@endif

@endsection