<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">
<head>
    <meta charset="utf-8">
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>@yield('title') | {{ config('app.name') }}</title>
   
    <link rel='stylesheet' href="{{ asset('assets/bootstrap.min.css') }}">
    <link rel="icon" type="image/png" sizes="16x16" href="{{ asset('assets/img/logo-anpe.png') }}">
    <!-- Custom CSS -->
    <link href="{{ asset('assets/css/styles.css') }}" rel="stylesheet">
    <link href="{{ asset('assets/css/toastr.css') }}" rel="stylesheet" type="text/css">

    <link href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet" >
    <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">

    <!-- All Jquery -->
    <script src="{{ asset('assets/js/jquery.min.js') }}"></script>
    <script src="{{ asset('assets/js/popper.min.js') }}"></script>
    <script src="{{ asset('assets/js/bootstrap.min.js') }}"></script>
    <script src="{{ asset('assets/js/slick.js') }}"></script>
    <script src="{{ asset('assets/js/slider-bg.js') }}"></script>
    <script src="{{ asset('assets/js/smoothproducts.js') }}"></script>
    <script src="{{ asset('assets/js/snackbar.min.js') }}"></script>
    <script src="{{ asset('assets/js/jQuery.style.switcher.js') }}"></script>
    <script src="{{ asset('assets/js/custom.js') }}"></script> 

    <!-- /Notify JS files -->
    <script src="{{ asset('assets/js/sweetalert.min.js') }}"></script>
    <script src="{{ asset('assets/js/sweetalert2@11.js') }}"></script>
    <script src="{{ asset('assets/js/toastr.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom.js') }}"></script> 

    <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script src="dist/snb-gallery-brick.min.js" type="text/javascript"></script>
    <style>
        .nav-brand{
            margin-top:6px;
        }
        
        .nav-menu li a{
            border: 1px solid transparent;
            border-radius:5%; 
            padding: 10px; 
            margin-top: 15px;
        }
        .nav-menu li a:hover{
            border: 1px solid orange;
        }
		
		.sous-active{
			color:red !important;            
		}
		
		.img-fluid {
          max-width: none !important;
        }
    </style>
</head>
<body>
    <div class="preloader"></div>
    <div id="main-wrapper">
        <div class="header header-light dark-text" style="border-bottom: 2px solid #ccc;">
            <div class="container">
                <nav id="navigation" class="navigation navigation-landscape">
                    <div class="nav-header">
                        <a class="nav-brand" href="{{ route('accueil') }}">
                            <img src="{{ asset('assets/img/logo-anpe.png') }}" class="logo"  alt="ANPE-LOGO" width="60px" style="margin-top:-7px">
                        </a>
                        <div class="nav-toggle"></div>
                        <div class="mobile_nav">
                            <ul>
							@guest
                                @if (Route::has('login'))
									<li>
										<a href="{{ route('seconnecter') }}" lass="theme-cl fs-lg" title="Connexion">
											<i class="lni lni-user"></i>
										</a>
									</li>
								@endif

                                @if (Route::has('register'))
									<li>
										<a href="{{ route('inscription') }}" class="theme-cl fs-lg" title="Créer un compte" style="margin-top:4px;">
											<i class="fa fa-user-circle"></i>
										</a>
									</li>
								@endif
							@else
								<li>
									<a href="{{ route('home') }}" class="theme-cl fs-lg" title="Mon compte" style="margin-top:-10px;">
										<i class="fa fa-user-circle"></i>
									</a>
								</li>
							@endguest
                            </ul>
                        </div>
                    </div>
                    <div class="nav-menus-wrapper" style="transition-property: none;">
                        <ul class="nav-menu">
                            <li class="{{Request::is('/','accueil.html') ? 'active' : ''}}"><a href="{{ route('accueil') }}" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">Accueil</a></li>
                            <li class="@if(substr($_SERVER['REQUEST_URI'], 0,   17  ) == '/offres-d-emploi') active @endif @if(substr($_SERVER['REQUEST_URI'], 0, 26) == '/offre-par-type-de-contrat') active @endif @if(substr($_SERVER['REQUEST_URI'], 0, 27) == '/offre-par-secteur-activite') active @endif{{Request::is('offres-d-emploi.html','recherche-offres/resultat.html') ? 'active' : ''}}"><a href="{{ route('offres') }}" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">Offres d'emploi</a></li>
                            <li class="@if(substr($_SERVER['REQUEST_URI'], 0,  10) == '/actualite') active @endif @if(substr($_SERVER['REQUEST_URI'], 0,  20) == '/categorie-actualite') active @endif {{Request::is('actualites.html') ? 'active' : ''}}"><a href="{{ route('actualite') }}" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">Actualités</a></li>
                            <li class="{{Request::is('services/programme-d-aide-a-l-insertion-professionnelle-des-jeunes.html','services/techniques-de-recherche-d-emploi.html','services/contrat-de-stage-d-initiation-a-la-vie-professionnelle.html','services/contrat-de-reconversion-professionnelle.html','services/programme-d-aide-a-la-creation-d-entreprises.html','services/carte-anpe.html') ? 'active' : ''}}"><a href="javascript::void(0)" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">Services</a> 
                                <ul class="nav-dropdown nav-submenu">
                                    <li><a href="{{ route('paij') }}">Programme d'aide à l'insertion professionnelle des jeunes (PAIJ)</a></li>
                                    <li><a href="{{ route('tre') }}">Les techniques de recherche d'emploi (TRE)</a></li>
                                    <li><a href="{{ route('cosivip') }}">Le contrat de stage d'initiation à la vie professionnelle (COSIVIP)</a></li>
                                    <li><a href="{{ route('crp') }}">Le contrat de reconversion professionnelle (CRP)</a></li>
                                    <li><a href="{{ route('pace') }}">Programme d'aide à la création d'entreprises (PACE)</a></li>
                                    <li><a href="{{ route('carteanpe') }}">Carte ANPE</a></li>
                                </ul>
                            </li> 
							<li class="{{Request::is('conseils/conseil-pour-rediger-un-cv.html','conseils/conseil-pour-rediger-une-lettre-de-motivation.html','conseils/conseil-pour-faire-un-entretien-embauche.html') ? 'active' : ''}}"><a href="javascript::void(0)" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">Conseils</a>
								<ul class="nav-dropdown nav-submenu">
									<li><a href="{{ route('redigeruncv') }}">Conseil pour rédiger un CV</a></li>
									<li><a href="{{ route('redigerlettremotivation') }}">Conseil pour rédiger une lettre de motivation</a></li>
									<li><a href="{{ route('entretienembauche') }}">Conseil pour faire un entretien d'embauche</a></li>
								</ul>
							</li>                        
                            <li class="{{Request::is('a-propos/presentation.html','a-propos/nos-antennes.html','a-propos/publications.html') ? 'active' : ''}}"><a href="javascript::void(0)" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">A propos</a>
                                <ul class="nav-dropdown nav-submenu">
                                    <li><a href="{{ route('presentation') }}">Présentation</a></li>
                                    <li><a href="{{ route('nosantennes') }}">Nos Agences</a></li>
                                    <li><a href="{{ route('publications') }}">Publications</a></li>
                                </ul>
                            </li>
                            <li class="{{Request::is('contact.html') ? 'active' : ''}}"><a href="{{ route('contact') }}" style="font-size:14px !important; text-transform: uppercase !important; font-weight: bold !important;">Contact</a></li> 							
                        </ul>
                        
                        <ul class="nav-menu nav-menu-social align-to-right" style="margin-top:5px">
                            @guest
                                @if (Route::has('login'))
                                    <li>
                                        <a href="{{ route('seconnecter') }}" class="theme-cl ft-medium" style="border: 2px solid #39BC6D; border-radius:5%; padding: 12px; margin-top: 10px; background: #39BC6D; color: #fff !important;">
                                            <i class="lni lni-user mr-2"></i>Se connecter
                                        </a>
                                    </li>
                                @endif

                                @if (Route::has('register'))
                                    <li>
                                        <a href="{{ route('inscription') }}" class="theme-cl ft-medium" style="border: 2px solid #39BC6D; border-radius:5%; padding: 12px; margin-top: 10px; background: #39BC6D; color: #fff !important;">
                                            <i class="fa fa-user-circle mr-2"></i>S'inscrire
                                        </a>
                                    </li>
                                @endif
                            @else
                                <li>
                                    <a href="{{ route('home') }}" class="theme-cl ft-medium" style="border: 2px solid orange; border-radius:5%; padding: 12px; margin-top: 10px; background: orange; color: #fff !important;"><i class="fa fa-user-circle mr-2"></i>Mon Compte</a>
                                </li>
                            @endguest
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
        <div class="clearfix"></div>            
        @yield('content')
        <footer class="dark-footer skin-dark-footer text-white style-2">
            <div class="footer-middle">
                <div class="container">
                    <div class="row">
                        
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                            <div class="footer_widget">
                                <img src="{{ asset('assets/img/logo-anpe.png') }}" class="img-footer small mb-2"  alt="ANPE-LOGO">
                                <div class="address mt-3">
                                    +227 20202020<br>www.anpe-niger.ne
                                </div>
                                <div class="address mt-2">
                                    <ul class="list-inline">
                                        <li class="list-inline-item"><a href="https://www.facebook.com/profile.php?id=100063818243158&mibextid=LQQJ4d" target="_blank" class="theme-cl"><i class="lni lni-facebook-filled"></i></a></li>
                                        <li class="list-inline-item"><a href="https://twitter.com/nigeranpe?s=11&t=uohPwLttnCBCpWU1B8bqmA" target="_blank" class="theme-cl"><i class="lni lni-twitter-filled"></i></a></li>
                                        <li class="list-inline-item"><a href="mailto:anpe.niger16@gmail.com" target="_blank" class="theme-cl"><i class="lni lni-google"></i></a></li>
                                        <li class="list-inline-item"><a href="https://www.instagram.com/p/CpChK3Usqlb/?utm_source=ig_web_copy_link" target="_blank" class="theme-cl"><i class="lni lni-instagram-filled"></i></a></li>
                                        <li class="list-inline-item"><a href="https://www.linkedin.com/company/agence-nationale-pour-la-promotion-de-l-emploi/" target="_blank" class="theme-cl"><i class="lni lni-linkedin-original"></i></a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                            <div class="footer_widget">
                                <h4 class="widget_title">A propos de nous</h4>
                                <ul class="footer-menu">
                                    <li><a href="{{ route('accueil') }}">Accueil</a></li>
                                    <li><a href="{{ route('offres') }}">Offres d'emploi</a></li>
                                    <li><a href="{{ route('presentation') }}">Présentation de l'ANPE</a></li>
                                    <li><a href="{{ route('actualite') }}">Actualités</a></li>
                                    <li><a href="{{ route('redigeruncv') }}">Conseil pour rédiger un CV</a></li>
                                    <li><a href="{{ route('redigerlettremotivation') }}">Conseil pour rédiger une lettre de motivation</a></li>
                                    <li><a href="{{ route('entretienembauche') }}">Conseil pour faire un entretien d'embauche</a></li>
                                </ul>
                            </div>
                        </div>
                        
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                            <div class="footer_widget">
                                <h4 class="widget_title">Candidat</h4>
                                <ul class="footer-menu">
                                    <li><a href="{{ route('demandeur.nouveau.cv') }}">Créer un cv</a></li>
                                    <li><a href="{{ route('demandeur.candidature.attente') }}">Mes candidatures</a></li>
                                    <li><a href="{{ route('offres') }}">S'abonner à une offre</a></li>
                                </ul>
                            </div>
                        </div>
                                
                        <div class="col-xl-3 col-lg-3 col-md-3 col-sm-12">
                            <div class="footer_widget">
                                <h4 class="widget_title">Employeur</h4>
                                <ul class="footer-menu">
                                    <!--li><a href="#">Conseil pour récruter</a></li-->
                                    <li><a href="{{ route('entreprise.listecandidature') }}">Rechercher des candidat en toute armonie</a></li>
                                    <li><a href="{{ route('entreprise.listecandidatureapprouvee') }}">Voir les CV</a></li>
                                    <li><a href="{{ route('entreprise.publieroffre') }}">Publier une offre</a></li>
                                </ul>
                            </div>
                        </div>
                            
                    </div>
                </div>
            </div>
            
            <div class="footer-bottom br-top">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="col-lg-12 col-md-12 text-center">
                            <p class="mb-0">Copyright © <?php echo gmdate("Y"); ?> ANPE propulsé par <a href="#" style="color:orange">EMERZONE</a></p>
                        </div>
                    </div>
                </div>
            </div>
        </footer>
        <a id="back2Top" class="top-scroll" title="Back to top" href="#"><i class="ti-arrow-up"></i></a>
    </div>
    <script>
        @if(Session::has('info_error'))
            toastr.error("{{ Session::get('info_error') }}", "MESSAGE D'ERREUR")
        @endif


        @if(Session::has('info_warning'))
            toastr.warning("{{ Session::get('info_warning') }}", "MESSAGE D'ERREUR")
        @endif


        @if(Session::has('status'))
            toastr.success("{{ Session::get('status') }}", "MESSAGE")
        @endif

        @if(Session::has('info_succes'))
            toastr.success("{{ Session::get('info_succes') }}", "MESSAGE")
        @endif

        @if(Session::has('info_erreur'))
            toastr.error("{{ Session::get('info_erreur') }}", "MESSAGE D'ERREUR")
        @endif

        @if(Session::has('erreur'))
            toastr.error("{{ Session::get('erreur') }}", "MESSAGE D'ERREUR")
        @endif

        @if(Session::has('session_expired'))
            toastr.primary("{{ Session::get('session_expired') }}", "CONNEXION EXPIREE")
        @endif
        
        @if($errors->any())
            @foreach($errors->all() as $error)
                toastr.error("{{ $error }}", "MESSAGE D'ERREUR")
            @endforeach
        @endif
    </script>
    <script>
        /* Description */
        $('#summernote').summernote({
            height: 200,
            toolbar: [
                ['insert', ['hr', 'summernoteGallery']],
                ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
                'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
                ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
                ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
                ['extensions', ['summernoteGallery']],
            ],
            summernoteGallery: {
                source: {
                    // data: data,
                    url: location.origin+location.pathname+'/server/example.json',
                    responseDataKey: 'data',
                    nextPageKey: 'links.next',
                },
                modal: {
                    loadOnScroll: true,
                    noImageSelected_msg: 'No image was selected, please select one by clicking it!',
                },
                buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
            }
        });
    </script>
</body>
</html>
