@extends('layouts.app')
@section('title')
    Lists des offres recherchées par contrat
@endsection

@section('content')
<style>
	.active{
		color:orange !important;
	}
</style>
<!-- ======================= Searchbar Banner ======================== -->
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">offres d’emploi</h1>
                </div>
				<form class="bg-white rounded p-1" action="{{ route('recherche') }}">
					<div class="row no-gutters">
						<div class="col-xl-4 col-lg-4 col-md-4 col-sm-12 col-12">
							<div class="form-group mb-0 position-relative">
								<input type="text" class="form-control lg left-ico" name="t" placeholder="Intitulé du poste, mot-clé" />
								<i class="bnc-ico lni lni-search-alt"></i>
							</div>
						</div>
						<div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12">
							<div class="form-group mb-0 position-relative">
								<select class="custom-select lg b-0" name="r">
								  <option value="">Région</option>
								  @foreach($regions as $region)
								  	<option value="{{ $region->region_id }}">{{ $region->region_nom }}</option>
								  @endforeach
								</select>
							</div>
						</div>
						<div class="col-xl-3 col-lg-3 col-md-3 col-sm-12 col-12">
							<div class="form-group mb-0 position-relative">
								<select class="custom-select lg b-0" name="m">
								  <option value="">Métier</option>
								  @foreach($metiers as $metier)
								  	<option value="{{ $metier->metier_id }}">{{ $metier->metier_libelle }}</option>
								  @endforeach
								</select>
							</div>
						</div>
						<div class="col-xl-2 col-lg-2 col-md-2 col-sm-12 col-12">
							<div class="form-group mb-0 position-relative">
								<button class="btn full-width custom-height-lg theme-bg text-white fs-md" type="submit">Rechercher</button>
							</div>
						</div>
					</div>
				</form>                 
            </div>
        </div>
    </div>
</div>

<!-- ============================ Offres Section Début ================================== -->
<section class="bg-light">
	<div class="container">
		<div class="row">
			<div class="col-lg-4 col-md-12 col-sm-12">
				<div class="bg-white rounded">							
				
					<div class="sidebar_header d-flex align-items-center justify-content-between px-4 py-3 br-bottom">
						<h4 class="ft-medium fs-lg mb-0">Filtre de recherche</h4>
					</div>
					<div class="sidebar-widgets collapse miz_show" id="search_open" data-parent="#search_open">
						
						<div class="search-inner">										
							<div class="filter_wraps">
								<div class="single_search_boxed px-4 pt-0 br-bottom">
									<div class="widget-boxed-header">
										<h4>
											<a href="#metiers" class="ft-medium fs-md pb-0" data-toggle="collapse" aria-expanded="true" role="button">Travails par type de métier </a>
										</h4>
										
									</div>
									<div class="widget-boxed-body collapse show" id="metiers" data-parent="#metiers">
										<div class="side-list no-border">
											<div class="single_filter_card">
												<div class="card-body p-0">
													<div class="inner_widget_link">
														<ul class="no-ul-list filter-list">
															@foreach($metiers as $metier)
																<li>
																	<a href="{{ route('offreparmetier',$metier->metier_id) }}">
																		<p style="font-size:16px"><i class="fa fa-check-circle mr-2"></i>{{ $metier->metier_libelle }}</p>
																	</a>
																</li>
															@endforeach
														</ul>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>
								<div class="single_search_boxed px-4 pt-0 br-bottom">
									<div class="widget-boxed-header">
										<h4>
											<a href="#contrats" data-toggle="collapse" aria-expanded="false" role="button" class="ft-medium fs-md pb-0 collapsed">Travails par type de contrat</a>
										</h4>
										
									</div>
									<div class="widget-boxed-body collapse" id="contrats" data-parent="#contrats">
										<div class="side-list no-border">
											<div class="single_filter_card">
												<div class="card-body p-0">
													<div class="inner_widget_link">
														<ul class="no-ul-list filter-list">
															@foreach($contrats as $contrat)
																<li>
																	<a href="{{ route('offreparcontrat',[$contrat->typecontrat_id, Stdfn::clean_url($contrat->typecontratlib)]) }}" @if($typecontrat->typecontrat_id == $contrat->typecontrat_id) class="active" @endif>
																		<p style="font-size:16px"><i class="fa fa-check-circle mr-2"></i>{{ $contrat->typecontratlib }}</p>
																	</a>
																</li>
															@endforeach
														</ul>
													</div>
												</div>
											</div>
										</div>
									</div>
								</div>											
							</div>
						</div>							
					</div>
				</div>						
			</div>			
			<div class="col-lg-8 col-md-12 col-sm-12">
				@forelse($offres as $offre)
					<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
						<div class="jbr-wrap text-left border rounded">
							<div class="cats-box mlb-res rounded bg-white d-flex align-items-center justify-content-between px-3 py-3">
								<div class="cats-box rounded bg-white d-flex align-items-center">
									<div class="text-center"><img src="{{ asset('assets/img/entreprise/'.$offre->entreprise_logo) }}" class="img-fluid" width="55" alt=""></div>
									<div class="cats-box-caption px-2">
										<h5 class="ft-medium mb-1" style="font-size:16px">
											<a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}">
												<?php echo html_entity_decode($offre->offretitre) ?>
											</a>
										</h5>
										<div class="d-block mb-2 position-relative">
											<span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>
												@foreach($offre->region_offre as $region)
													<span class="mr-2 mb-2 d-inline-flex px-2 py-1 rounded {{ $region->region_couleur }} text-capitalize">{{ $region->region_nom }}</span>
												@endforeach 
											</span>
											<span class="text-muted mr-2"><i class="lni lni-briefcase mr-1"></i>{{ $offre->contrat->typecontratlib }}</span>
											<span class="text-success ml-2 theme-cl"><i class="fa fa-clock mr-1"></i>
												@php
													$datejour = \Carbon\Carbon::today();
													$datefin = \Carbon\Carbon::createFromFormat('Y-m-d', $offre->offre_datefin);
													$joursrestant = $datejour->diffInDays($datefin);
													if($joursrestant < 1){
														echo('Expire dans quelques heures');
													}
													if($joursrestant >= 1){
														echo('Expire dans '.$joursrestant. ' jours');
													}                                                        
												@endphp   
											</span>
										</div>
									</div>
								</div>
								<div class="text-center mlb-last"><a href="{{ route('detailsuneoffre', [$offre->offre_id, Stdfn::clean_url($offre->offretitre)]) }}" class="btn btn-md theme-bg ft-medium text-light apply-btn fs-sm rounded">Détails<i class="lni lni-arrow-right-circle ml-1"></i></a></div>
							</div>
						</div>
					</div>
				@empty
					<div class="row align-items-center">
						<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12 col-12">
							<div class="alert alert-primary text-center" style="font-size:22px; font-weight:bold">
								Il n'y a aucune offre publiée pour l'instant
							</div>
						</div>
					<div>
				@endforelse
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12">
						<ul class="pagination">
							<li class="">{{ $offres->links() }}</li>
						</ul>
					</div>
				</div>
				
			</div>
			
		</div>
	</div>
</section>
<!-- ============================ Offres Section Fin ================================== -->
@endsection