@extends('layouts.app')
@section('title')
    Programme d’Aide à l’Insertion Professionnelle des Jeunes (PAIJ)
@endsection

@section('content')
<style>
    #map{
        height: 400px;
        width: 100%;
    }
    
    .img-fluid {
      max-width: 100% !important;
      height: auto !important;
    }
</style>
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h2 class="ft-bold mb-4">Programme d’Aide à l’Insertion Professionnelle des Jeunes (PAIJ)</h2>
                    <nav class="transparent">
						<ol class="breadcrumb p-0">
							<li class="breadcrumb-item"><a href="{{ route('accueil') }}" style="color:#FFF !important">Home</a></li>
                            <li class="breadcrumb-item text-white">Services</li>
							<li class="breadcrumb-item active theme-cl" aria-current="page">PAIJ</li>
						</ol>
					</nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="middle">
    <div class="container">
        <div class="row align-items-start justify-content-between">
            <div class="col-12 col-md-12 col-lg-12 col-xl-12">
                <div class="row align-items-start">
                    <div class="abt-cdt d-block full-width mb-4">
                        <h3 style="text-align:center !important">Améliorer l’employabilité des jeunes et promouvoir leur insertion dans la vie active.</h3>
                        <p></p>
                        <p></p>
                    </div>
                    <div class="abt-cdt d-block full-width mb-4">
                        <h4 class="ft-medium mb-1 fs-md">Contrat de Stages d’Initiation à la Vie Professionnelle (COSIVIP)</h4>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                    <div class="d-flex align-items-center">
                                      <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                        <i class="fas fa-check small"></i>
                                      </div>
                                      <h6 class="mb-0 ml-3 text-muted fs-sm">Publics cibles : Les diplômés de l’enseignement supérieur, technique et professionnel à la recherche d’un premier emploi</h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="abt-cdt d-block full-width mb-4">
                        <h4 class="ft-medium mb-1 fs-md">Contrat de Reconversion Professionnelle (CRP)</h4>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                    <div class="d-flex align-items-center">
                                      <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                        <i class="fas fa-check small"></i>
                                      </div>
                                      <h6 class="mb-0 ml-3 text-muted fs-sm">Publics cibles : Les diplômés de l’enseignement supérieur, technique et professionnel et des travailleurs ayant perdu leur emploi</h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="abt-cdt d-block full-width mb-4">
                        <h4 class="ft-medium mb-1 fs-md">Programme d’Aide à la Création d’Entreprise (PACE)</h4>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                    <div class="d-flex align-items-center">
                                      <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                        <i class="fas fa-check small"></i>
                                      </div>
                                      <h6 class="mb-0 ml-3 text-muted fs-sm">Publics cibles : Les jeunes désireux de s’installer à leur propre compte par la création d’emploi indépendant ou de micro entreprise</h6>
                                    </div>
                                </div>
                                <div class="exslio-list mt-3">
                                    <ul>
                                        <li>
                                            <div class="esclio-110 bg-light rounded px-3 py-3">
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">CONDITIONS D’ACCES</h4>
                                                <div class="esclio-110-decs full-width mt-3">
                                                    <p><i class="fas fa-check small mr-1"></i>Etre de nationalité nigérienne</p>
                                                    <p><i class="fas fa-check small mr-1"></i>S’inscrire auprès des services de l’ANPE</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Conclure un contrat avec l’Agence</p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="abt-cdt d-block full-width mb-4">
                        <h4 class="ft-medium mb-1 fs-md">Le Contrat de Stage d’Initiation à la Vie Professionnelle (COSIVIP)</h4>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="exslio-list mt-3">
                                    <ul>
                                        <li>
                                            <div class="esclio-110 bg-light rounded px-3 py-3">
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">PRESENTATION</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Outil d’acquisition d’une première expérience pour les jeunes diplômés.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">OBJECTIF</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Renforcer l’employabilité des jeunes diplômés et inciter les entreprises à les recruter.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">PUBLICS VISES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Les jeunes de nationalité nigérienne, diplômés de l’enseignement supérieur, technique ou professionnel, primo demandeurs d’emploi.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">CONDITIONS D’ACCES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p><i class="fas fa-check small mr-1"></i>Etre de nationalité nigérienne</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Avoir un âge compris entre 18 et 35 ans</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Etre titulaire d’un diplôme de l’enseignement supérieur, technique ou professionnel</p>
                                                    <p><i class="fas fa-check small mr-1"></i>S’inscrire auprès des services de l’ANPE</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Conclure un contrat avec l’Agence</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">ENTREPRISES ELIGIBLES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Toute entreprise du secteur parapublic ou privé, établie sur le territoire national.</p>
                                                    <p style="font-style: italic; font-weight: bold;">Durée du stage : Douze (12) mois</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">AVANTAGES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Une allocation mensuelle est servie aux bénéficiaires ainsi qu’une couverture sociale contre les risques professionnels.</p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="abt-cdt d-block full-width mb-4">
                        <h4 class="ft-medium mb-1 fs-md">Le Contrat de Reconversion Professionnelle (CRP)</h4>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="exslio-list mt-3">
                                    <ul>
                                        <li>
                                            <div class="esclio-110 bg-light rounded px-3 py-3">
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">PRESENTATION</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Il est destiné à répondre à la question majeure de l’employabilité des chercheurs d’emploi, en mettant en place des formations/emplois.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">OJECTIF</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Améliorer les aptitudes des jeunes et des chômeurs de longue durée, pour qu’ils répondent aux besoins en compétences des entreprises nigériennes.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">PUBLICS VISES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p><i class="fas fa-check small mr-1"></i>Les jeunes diplômés de l’enseignement supérieur, technique et professionnel, âgés de 15 et 35 ans à la recherche d’un premier emploi dont le profil requiert une formation complémentaire</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Les chômeurs de longue durée rencontrant des difficultés de réinsertion dans la vie active et inscrits à l’ANPE depuis un (1) an.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">CONDITIONS D’ACCES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p><i class="fas fa-check small mr-1"></i>Etre de nationalité nigérienne</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Etre diplômé de l’enseignement supérieur, technique et professionnel, âgés de 15 et 35 ans à la recherche d’un premier emploi dont le profil requiert une formation complémentaire</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Etre chômeur de longue durée rencontrant des difficultés d’insertion durant au moins un (1) an</p>
                                                    <p><i class="fas fa-check small mr-1"></i>S’inscrire auprès des services de l’ANPE</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Conclure un contrat avec l’Agence</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">DUREE DES FORMATIONS</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Elles ne peuvent excéder six (6) mois</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">AVANTAGES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Une allocation journalière est servie par l’ANPE durant la période de la formation.</p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="abt-cdt d-block full-width mb-4">
                        <h4 class="ft-medium mb-1 fs-md">Programme d’Aide à la Création d’Entreprise (PACE))</h4>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="exslio-list mt-3">
                                    <ul>
                                        <li>
                                            <div class="esclio-110 bg-light rounded px-3 py-3">
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">PRESENTATION</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Il s’adresse à des jeunes en vue de les aider à s’insérer par la création d’un travail indépendant ou d’une micro entreprise.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">OJECTIF</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Accompagner des jeunes diplômés en vue de les aider à s’insérer dans la vie active par la création d’un travail indépendant ou d’une micro entreprise.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">PUBLICS VISES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Sont éligibles, les jeunes diplômés, désirant s’installer à leur propre compte, qu’ils aient ou non, une idée du projet.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">CONDITIONS D’ACCES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p><i class="fas fa-check small mr-1"></i>Etre de nationalité nigérienne</p>
                                                    <p><i class="fas fa-check small mr-1"></i>S’inscrire auprès des services de l’ANPE</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Avoir une idée ou un projet de création d’entreprise</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">AVANTAGES</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>Les bénéficiaires de formation entrepreneuriale perçoivent, au cours des sessions de formation, une allocation journalière, servie par l’ANPE.</p>
                                                </div>
                                                <h4 class="mb-0 ft-medium fs-md" style="font-weight:bold">MOYENS D’ACCOMPAGNEMENT</h4>
                                                <div class="esclio-110-decs full-width">
                                                    <p>L’ANPE, à travers ses structures centrales et régionales compétentes, offre aux jeunes visés par cet instrument :</p>
                                                    <p><i class="fas fa-check small mr-1"></i>La participation à des sessions de formation entrepreneuriale en vue de détecter des idées d’entreprises</p>
                                                    <p><i class="fas fa-check small mr-1"></i>Un appui technique aux jeunes porteurs d’idées de projets identifiés pour l’élaboration de leurs plans d’affaire</p>
                                                    <p><i class="fas fa-check small mr-1"></i>La recherche de sources de financement de leurs projets identifiés auprès des structures de crédits ou de financement des micros entreprises ainsi que les partenaires publics et les associations spécialisées dans l’emploi indépendant</p>
                                                </div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection