@extends('layouts.app')
@section('title')
    Présentation
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Présentation de l'ANPE</h1>
                    <nav class="transparent">
						<ol class="breadcrumb p-0">
							<li class="breadcrumb-item"><a href="{{ route('accueil') }}" style="color:#FFF !important">Home</a></li>
                            <li class="breadcrumb-item text-white">A propos</li>
							<li class="breadcrumb-item active theme-cl" aria-current="page">Présentation</li>
						</ol>
					</nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="middle">
    <div class="container">
		<h2 class="ft-medium mb-4 text-center">Mot du Directeur Général</h2>
        <div class="row align-items-center justify-content-between">        
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <div class="abt_caption">                    
                    <p class="mb-2">La Politique Nationale de l’Emploi (PNE), adoptée en mars 2009 est née de la vision des pouvoirs publics à créer un cadre harmonieux et cohérent pour la mise en œuvre efficiente des programmes et stratégies sectoriels en faveur de l’emploi.</p>
                    <p class="mb-2">L’objectif poursuivi, à travers la mise en œuvre de la PNE, est de créer les conditions d’accès à l’emploi productif, en plaçant la création d’emplois au centre des objectifs de développement économique et social aux niveaux national, régional et local, pour permettre la réduction durable de la pauvreté.</p>
                    <p class="mb-2">L’Agence Nationale pour la Promotion de l’Emploi (ANPE) est une institution qui œuvre pour l’atteinte de ces objectifs cités ci-dessus. L’Agence Nationale pour la Promotion de l’Emploi (ANPE), a connu en 2017 et 2018 une mutation par la réforme de ses statuts qui consacre son passage d’un Etablissement Public à caractère Administratif (EPA) à un Etablissement Public à caractère Social (EPS). Ce nouveau régime juridique place d’une part, l’ANPE au diapason des services publics d’emploi modernes et d’autre part, la soutient à remplir efficacement ses missions.</p>
                    <p class="mb-2"><strong>L’ANPE, UN INSTRUMENT DE L’EMPLOI AU SERVICE DE TOUS !</strong></p>
                </div>
            </div>
            
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <div class="abt_caption">
                    <img src="{{ asset('assets/img/directeur.jpg') }}" class="img-fluid rounded" alt="" />
                </div>
            </div>
            
        </div>
    </div>
</section>
<section class="middle gray">
    <div class="container">
        <div class="row align-items-center justify-content-between">
            
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <div class="abt_caption">
                    <img src="{{ asset('assets/img/logo-anpe.png') }}" class="img-fluid rounded" alt="" />
                </div>
            </div>
            
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <div class="abt_caption">
                    <h2 class="ft-medium mb-4">Présentation de l'ANPE</h2>
                    <p class="mb-2">L’Agence Nationale pour la Promotion de l’Emploi (ANPE) est un Etablissement Public à caractère Social (EPS), créée par <strong>le Décret N°2017-798/PRN/MET/PS du 06 octobre 2017</strong>.</p>
                    <p class="mb-2">Ses statuts ont été approuvés par le Décret <strong>N°2018-226/PRN/MET/PS du 30 mars 2018</strong>.</p>
                    <p class="mb-2">De juin 1996 à septembre 2017, l’Agence était un Etablissement Public à caractère Administratif (EPA).</p>
                    <p class="mb-2">Sa mutation en un Etablissement Public à caractère Social est guidée par un souci de permettre à l’ANPE d’être l’institution leader en matière de promotion de l’emploi au Niger.</p>
                    <p class="mb-2">L’ANPE, placée sous la tutelle technique du Ministère chargé de l’Emploi, est administrée par un Conseil d’Administration (CA) tripartite composée de : <br>
                        <div class="position-relative row">
                            <div class="col-lg-12 col-md-12 col-12">
                                <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                    <div class="d-flex align-items-center">
                                      <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                        <i class="fas fa-check small"></i>
                                      </div>
                                      <h6 class="mb-0 ml-3 text-muted fs-sm">4 représentants de l’Etat ;</h6>
                                    </div>
                                </div>
                                <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                    <div class="d-flex align-items-center">
                                      <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                        <i class="fas fa-check small"></i>
                                      </div>
                                      <h6 class="mb-0 ml-3 text-muted fs-sm">4 représentants des employeurs ;</h6>
                                    </div>
                                </div>
                                <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                    <div class="d-flex align-items-center">
                                      <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                        <i class="fas fa-check small"></i>
                                      </div>
                                      <h6 class="mb-0 ml-3 text-muted fs-sm">4 représentants des travailleurs.</h6>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </p>
                    <p class="mb-2"></p>
                </div>
            </div>
            
        </div>
    </div>
</section>
<section class="middle">
    <div class="container">
        <div class="row align-items-center justify-content-between">        
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <div class="abt_caption">
                    <p class="mb-2">L’Agence poursuit une mission de service public d’emploi. Elle assure l’intermédiation sur le marché de l’emploi, la promotion de l’emploi et l’insertion professionnelle des demandeurs d’emploi.</p>
                    <p class="mb-2" style="margin-left:20px"><strong>A ce titre, elle est chargée :</strong></p>
                    <div class="position-relative row">
                        <div class="col-lg-12 col-md-12 col-12">
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Accueillir, conseiller et accompagner les demandeurs d’emploi et les employeurs ;</h6>
                                </div>
                            </div>
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Assurer le placement des demandeurs d’emploi au sein des entreprises ;</h6>
                                </div>
                            </div>
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Viser les contrats de travail et d’apprentissage des travailleurs nigériens et étrangers ;</h6>
                                </div>
                            </div>
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Délivrer des cartes de travail ;</h6>
                                </div>
                            </div>
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Délivrer des attestations de soumission aux marchés publics ;</h6>
                                </div>
                            </div>
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Collecter, analyser et diffuser des données sur les offres et les demandes d’emploi ;</h6>
                                </div>
                            </div>
                            <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                <div class="d-flex align-items-center">
                                  <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                    <i class="fas fa-check small"></i>
                                  </div>
                                  <h6 class="mb-0 ml-3 text-muted fs-sm">Exécuter des programmes d’insertion, de réinsertion et de reconversion professionnelle ainsi que le financement des projets d’auto emploi…</h6>
                                </div>
                            </div>
                        </div>
                    </div>
                    <p class="mb-2"></p>
                </div>
            </div>
            
            <div class="col-xl-6 col-lg-6 col-md-6 col-sm-12">
                <div class="abt_caption">
                    <img src="{{ asset('assets/img/presentation.jpg') }}" class="img-fluid rounded" alt="">
                </div>
            </div>
            <div class="col-md-12">
                <br>
                Pour mener à bien sa mission, l’ANPE dispose de <strong>huit (8)</strong> Agences Régionales, reparties dans les Chefs lieux des régions (<strong>Agadez</strong>, <strong>Diffa</strong>, <strong>Dosso</strong>, <strong>Maradi</strong>, <strong>Niamey</strong>, <strong>Tahoua</strong>, <strong>Tillabéry</strong> et <strong>Zinder</strong>).
            </div>            
        </div>
    </div>
</section>
@endsection