<?php
    use Carbon\Carbon;
?>
@extends('layouts.app')
@section('title')
    Nos publications
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Documenthèque</h1>
                    <nav class="transparent">
                        <ol class="breadcrumb p-0">
                            <li class="breadcrumb-item"><a href="{{ route('accueil') }}" style="color:#FFF !important">Home</a></li>
                            <li class="breadcrumb-item text-white">A propos</li>
                            <li class="breadcrumb-item active theme-cl" aria-current="page">Publications</li>
                        </ol>
                    </nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="middle bg-light">
    <div class="container">
        <div class="row align-items-center justify-content-between"> 
            <div class="col-xl-12 col-lg-12 col-md-12">
                <div class="mb-4 tbl-lg rounded overflow-hidden">
                    <div class="table-responsive bg-white">
                        <table class="table">
                            <thead class="thead-dark">
                                <tr>
                                  <th scope="col">Titre</th>
                                  <th scope="col" class="text-center">Taille</th>
                                  <th scope="col" class="text-center">Date de publication</th>
                                  <th scope="col" class="text-center">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($publications as $publication)
                                    <tr>
                                        <td>
                                            <div class="cats-box rounded bg-white d-flex align-items-center">
                                                <div class="text-center">
                                                    @if($publication->publication_extension == "pdf")
                                                        <img src="{{ asset('assets/img/pdf-icon.png') }}" class="img-fluid" width="55" alt="">
                                                    @elseif($publication->publication_extension == "xlsx")
                                                        <img src="{{ asset('assets/img/excel-icon.png') }}" class="img-fluid" width="55" alt="">
                                                    @elseif($publication->publication_extension == "docx")
                                                        <img src="{{ asset('assets/img/word-icon.png') }}" class="img-fluid" width="55" alt="">
                                                    @endif
                                                </div>
                                                <div class="cats-box-caption px-2">
                                                    <h4 class="fs-md mb-0 ft-medium"><?php echo html_entity_decode($publication->publication_libelle) ?></h4>
                                                    <!--div class="d-block mb-2 position-relative">
                                                        <span class="text-muted medium"><i class="lni lni-map-marker mr-1"></i>Liverpool, London</span>
                                                        <span class="muted medium ml-2 theme-cl"><i class="lni lni-briefcase mr-1"></i>Full Time</span>
                                                    </div-->
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">{{ number_format($publication->publication_taille, 3, '.', '') }} Mo</td>
                                        <td class="text-center">
                                            @php
                                
                                                $date_publication = $publication->publication_datecreation;

                                                $date = Carbon::parse($date_publication)->locale('fr_FR')->translatedFormat('d F Y');

                                                echo $date;
                                            @endphp
                                        </td>
                                        <td class="text-center">
                                            <div class="dash-action">
                                               <a href="{{ asset('assets/fichiers/'.$publication->publication_fichier) }}" target="_blank" class="px-2 py-1 medium bg-light-success rounded text-success"><i class="lni lni-download mr-1"></i>Télécharger le fichier</a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="4">
                                            <center>Il n'y a aucune publication</center>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="col-lg-12 col-md-12 col-sm-12">
                <ul class="pagination">
                    <li class="page-item">{{ $publications->links() }}</li>
                </ul>
            </div>
        </div>
    </div>
</section>
@endsection