@extends('layouts.app')
@section('title')
    Conseil pour rediger une lettre de motivation
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">10 astuces pour écrire votre lettre de motivation</h1>
                    <nav class="transparent">
						<ol class="breadcrumb p-0">
                            <li class="breadcrumb-item"><a href="{{ route('accueil') }}" style="color:#FFF !important">Accueil</a></li>
							<li class="breadcrumb-item text-white">Conseils</li>
							<li class="breadcrumb-item active theme-cl" aria-current="page">Conseil pour rediger une lettre de motivation</li>
						</ol>
					</nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="bg-light py-5 position-relative">
    <div class="container">
        <div class="row">
            
            <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">
            
                <div class="bg-white rounded px-3 py-4 mb-4">
                    <div class="jbd-01 d-flex align-items-center justify-content-between">
                        <div class="jbd-flex d-flex align-items-center justify-content-start">                            
                            <div class="jbd-01-caption pl-3">
                                <h1>Conseil pour rediger une lettre de motivation</h1>
                                <p>Vous êtes stressé à l’idée de devoir écrire une lettre de motivation ? Vous avez peur de la page blanche ? Pas de panique ! On vous délivre quelques astuces pour vous lancer et vous démarquer auprès des recruteurs.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded mb-4">
                    <div class="jbd-01 px-3 py-4">                        
                        <div class="jbd-details mb-3">
                            <h5>1. Montrez votre connaissance de l’entreprise</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Avant de vous lancer dans la rédaction, prenez le temps de faire quelques recherches sur l’entreprise, en visitant son site Internet, par exemple. Vous pourrez ensuite produire un petit résumé qui parle de son actualité, son organisation, ses valeurs, sa stratégie… Vous montrez ainsi que vous connaissez l’entreprise et que vous avez compris le besoin du recruteur.</p>
                                </div>
                            </div><br>
                            <h5>2. Parlez de vous</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Dans cette partie, vous expliquez en quoi votre profil correspond aux attentes du recruteur, avec des exemples et des références à votre parcours. Mettez en valeur vos expériences professionnelles les plus pertinentes par rapport au poste visé. N’hésitez pas à utiliser des verbes d’action : j’ai participé, j’ai réalisé, j’ai géré…</p>
									<p>Valorisez vos compétences par rapport au poste à pourvoir, en illustrant chaque affirmation. Si vous pensez qu’une compétence spécifique fait de vous le meilleur candidat, expliquez pourquoi en donnant un exemple de situation où cette compétence a été utile. Inutile de détailler votre parcours complet ou de paraphraser votre CV puisque celui-ci complète votre candidature. La lettre de motivation doit faire le lien entre votre CV et les attentes du recruteur.</p>
								</div>
                            </div><br>
                            <h5>3. Démontrez les bénéfices d’une future collaboration</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Le troisième paragraphe vous permet d’expliquer ce que vous pourriez apporter à l’entreprise et en quoi votre recrutement serait une opportunité pour elle. C’est le moment d’exprimer vos motivations, vos ambitions et de créer des connexions entre l’entreprise et votre profil.</p>
                                </div>
                            </div><br><br>
							<h5>Reprenez les éléments mentionnés dans l’annonce</h5>
							<div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Il est essentiel de personnaliser votre lettre de motivation. Pour cela, prenez le temps d’analyser l’offre d’emploi, afin de pouvoir y répondre point par point dans votre lettre. N’hésitez pas à inclure tous les renseignements demandés dans l’annonce.</p>
                                </div>
                            </div><br>
                            <h5>4. Une lettre pour chaque candidature</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Créez votre lettre à partir d’une page blanche : retravailler une ancienne lettre, c’est prendre le risque de laisser des informations qui ne sont pas pertinentes vis-à-vis de l’offre. Le contenu doit être différent pour chaque candidature : ton, vocabulaire et arguments doivent s’adapter à l’annonce à laquelle vous postulez. Vous pouvez vous inspirez de vos précédentes lettres, mais obligez-vous à personnaliser chaque lettre en fonction de l’interlocuteur et du poste visé.</p>
                                </div>
                            </div><br>
                            <h5>5. Adaptez le ton et le style</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Répondez en utilisant le même ton, vocabulaire et style que ceux employés dans l’annonce, afin de montrer votre adéquation avec l’entreprise. Si vous sentez que cette dernière a une certaine ouverture d’esprit vis-à-vis de la créativité, vous pouvez faire preuve d’originalité dans le style ou dans la forme.</p>
                                    <p>De manière générale, rédigez votre lettre dans un langage professionnel et respectueux. N’utilisez pas un vocabulaire trop familier, mais ne tombez pas non plus dans un style trop ampoulé. Adoptez un ton neutre, clair et direct.</p>
                                </div>
                            </div><br>
                            <h5>6. Compétences et qualités</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Inutile de faire l’inventaire de l’ensemble de vos compétences. Que vous parliez de vos softs skills ou de vos compétences techniques, mentionnez uniquement celles qui sont demandées pour le poste, cela vous évitera de vous éparpillez. De même, ne cherchez pas à vous survendre ou à « gonfler » vos compétences, tout sera vérifié lors de l’entretien. Faites-vous connaître tel que vous êtes auprès du recruteur, c’est ce qui l’intéresse.</p>
                                </div>
                            </div><br><br>
                            <h5>Donnez envie d’être lu</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Quelques principes de base permettent de faciliter la lecture et de retenir l’attention du recruteur.</p>
                                </div>
                            </div><br>
                            <h5>7. Soyez direct et concis</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Employez des phrases courtes qui facilitent l’intégration des informations par le lecteur. Évitez les répétitions et diversifiez votre vocabulaire en utilisant des synonymes. Les recruteurs lisent trop de lettres de candidats « compétents », « dynamiques », « ouverts » ou « sérieux ».</p>
                                    <p>Bannissez l’emploi du conditionnel ! Ce temps indique un souhait, une hypothèse et renvoie indirectement l'image de quelqu'un peu sûr de lui. Optez plutôt pour le présent et le futur, qui vont donner un ton dynamique à votre lettre : « je souhaite rejoindre votre entreprise » plutôt que « je souhaiterais rejoindre votre entreprise ».</p>
                                </div>
                            </div><br>
                            <h5>8. Soignez la mise en page</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Privilégiez une mise en page aérée, qui incite à la lecture, avec des paragraphes facilement identifiables et à peu près de la même longueur. Votre lettre doit tenir sur une seule page.</p>
                                    <p>Reprenez la structure classique de la lettre de motivation pour que le recruteur retrouve facilement toutes les informations utiles : votre identité et vos coordonnées à gauche, celles de votre interlocuteur à droite, puis l’objet de votre lettre, reprenant le titre du poste et la référence de l’annonce.</p>
                                    <p>Utilisez une seule police de caractère, ni trop petite, ni trop grosse et facile à lire, comme Times New Roman ou Arial 12 points, par exemple.</p>
                                </div>
                            </div><br>
                            <h5>9. Phrase d’accroche et formule de politesse</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Outre les trois principales parties, commencez avec une formule d’appel (« Madame, Monsieur ») et utilisez une phrase d’accroche pour l’entrée en matière, celle-ci peut reprendre en partie le contenu de l’annonce. Soyez percutant afin de capter l’attention de votre interlocuteur : « J’ai découvert votre offre avec intérêt grâce à… » ou « J’admire votre société pour sa capacité à… », par exemple.</p>
                                    <p>Avant de prendre congé, incitez le recruteur à vous recevoir en entretien, en indiquant que vous êtes à sa disposition pour toutes informations complémentaires.</p>
                                    <p>Concluez par une formule de politesse : « Veuillez agréer, Madame, Monsieur… ».</p>
                                </div>
                            </div><br>
                            <h5>10. Vérifiez l’orthographe et la grammaire</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Les correcteurs automatiques sur ordinateur ne sont pas suffisants. Relisez-vous attentivement plusieurs fois et faites relire votre lettre par une autre personne pour chasser les fautes d’orthographe, de grammaire et de frappe. Une candidature dont la lettre contient des fautes est rapidement éliminée, même si elle correspond au poste à pourvoir.</p>
                                </div>
                            </div><br>
                        </div>                        
                    </div>
                </div>
                
            </div>
            
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">            
                <img src="{{ asset('assets/img/lettre_motivation.jpg') }}" style="width:400px">        
            </div>
            
        </div>
    </div>
</section>
@endsection