@extends('layouts.app')
@section('title')
    Comment créer un CV
@endsection

@section('content')
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">10 conseils pour votre CV</h1>
                    <nav class="transparent">
						<ol class="breadcrumb p-0">
							<li class="breadcrumb-item"><a href="{{ route('accueil') }}" style="color:#FFF !important">Home</a></li>
                            <li class="breadcrumb-item text-white">Conseils</li>
							<li class="breadcrumb-item active theme-cl" aria-current="page">Comment créer un CV</li>
						</ol>
					</nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<section class="bg-light py-5 position-relative">
    <div class="container">
        <div class="row">
            
            <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">
            
                <div class="bg-white rounded px-3 py-4 mb-4">
                    <div class="jbd-01 d-flex align-items-center justify-content-between">
                        <div class="jbd-flex d-flex align-items-center justify-content-start">                            
                            <div class="jbd-01-caption pl-3">
                                <h1>10 conseils pour votre CV</h1>
                                <p>Pour que votre CV soit le plus efficace possible, il existe un certain nombre de règles à respecter. Mise en page, orthographe, contenu... Nous vous dévoilons 10 conseils pour votre CV qui vous aideront à optimiser votre profil et votre recherche d’emploi.</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="bg-white rounded mb-4">
                    <div class="jbd-01 px-3 py-4">                        
                        <div class="jbd-details mb-3">
                            <h5>1. Restez concis</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>En réalisant un CV, vous avez pour objectif de présenter au mieux votre profil de façon à être sélectionné par les recruteurs. Il paraît alors évident que vous ayez envie d’y inclure le plus d’informations possible pour rassurer les employeurs potentiels sur vos compétences et/ou expériences. Nous vous suggérons néanmoins de rester bref. Sachez que les recruteurs reçoivent de nombreux curriculums vitae pour chaque offre publiée, sans compter les candidatures spontanées. Pour pouvoir gérer ce flux de profils, ils ne disposent que de très peu de temps. Par conséquent, le temps moyen accordé à un CV n’est que de quelques secondes. Si vous envoyez un document de plusieurs pages avec de gros blocs de texte, il y a de fortes chances que celui-ci atterrisse dans la pile des candidatures qui seront mises de côté.</p>
                                    <p>Sélectionnez les informations les plus pertinentes de votre parcours et les éléments essentiels de votre profil pour créer un CV concis et percutant.</p>
                                </div>
                            </div><br>
                            <h5>2. Respectez l’ordre antéchronologique</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Peu importe si vous choisissez de créer un CV chronologique, fonctionnel ou antéchronologique, les informations énumérées dans les rubriques de votre document devront être présentées en respectant un ordre antéchronologique. Cela signifie que vous indiquerez les différents éléments en partant de plus récent. Vous pouvez être tenté de citer différentes informations en suivant une autre façon de faire. Nous vous recommandons tout de même de respecter l’ordre antéchronologique.</p>
                                    <p>C'est en effet la règle pour les CV, y déroger pourrait rendre plus difficile la lecture de votre profil et ainsi refroidir les recruteurs.</p>
                                </div>
                            </div><br>
                            <h5>3. Soyez honnêtes</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Vous avez peu ou pas d’expérience, ou peut-être des trous à masquer sur votre CV ? Dans certaines circonstances, il peut être tentant de mentir ou d’exagérer plus ou moins légèrement la réalité. Quelle que soit la raison qui vous inciterait à embellir votre CV, abstenez-vous ! Les recruteurs sont formés à détecter les incohérences ainsi qu’à vous questionner lors de l’entretien si vous passez le filtre du tri des CV. Aussi attrayante que puisse être cette idée, oubliez-là et concentrez-vous plutôt sur une rédaction de qualité qui mettra en avant vos atouts. Lors de l’entretien, vous aurez également la possibilité de répondre clairement aux interrogations.</p>
                                    <p>Tous les candidats ont des parcours différents et, si vous correspondez aux besoins de l’entreprise, votre honnêteté jouera en votre faveur.</p>
                                </div>
                            </div><br>
                            <h5>4. Créez un CV ciblé</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>L'objectif d’un bon CV est de montrer à tous ceux qui le liront que vous possédez le profil idéal pour remplir les fonctions listées dans l’offre d’emploi. Votre document ne doit donc pas laisser la place au doute, surtout si on prend en compte le nombre important de concurrents desquels vous devez vous différencier. Certains candidats ont pour habitude d’envoyer des curriculums vitae généralistes qu’ils adressent sans aucune modification, indépendamment du poste visé. C'est une erreur récurrente qui ne fera qu’augmenter vos chances de voir votre candidature rejetée. Pour montrer aux recruteurs et aux employeurs potentiels que vous êtes la personne idéale pour le poste, prenez le temps de rédiger un CV ciblé. Dans ce dernier, vous devrez adapter le contenu en ayant en tête les besoins exprimés dans l’offre.</p>
                                    <p>Pour y parvenir, un CV général pourrait vous aider. Ainsi, il vous suffirait de lister l’intégralité de votre parcours, de vos expériences professionnelles et de tout autre élément qui pourrait s’avérer être des atouts pour votre candidature. Ensuite, vous pourrez aisément créer votre CV ciblé en sélectionnant les informations pertinentes pour le poste visé.</p>
                                </div>
                            </div><br>
                            <h5>5. Optez pour un ton direct</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Le contenu de votre CV est primordial, mais si la rédaction manque d’impact, il ne sera pas mis en valeur et les recruteurs ne prendront pas forcément le temps nécessaire pour le parcourir. Utiliser la voix active, un ton direct et des mentions de résultats permettra d'apporter du dynamisme à votre document, ce qui le rendra plus efficace pour transmettre les informations que vous souhaitez souligner. Par ailleurs, insérer des listes à puces donnera également un ton plus direct à votre contenu, tout en permettant aux lecteurs de votre CV de pouvoir trouver des éléments facilement d’un coup d’œil.</p>
                                </div>
                            </div><br>
                            <h5>6. Oubliez votre jargon professionnel</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Nous avons tous tendance à adopter les acronymes de notre secteur d’activité ainsi que certains termes fréquemment utilisé dans notre quotidien professionnel. Rien de plus normal lorsque nous passons notre temps avec des personnes qui partagent le même environnement et les mêmes connaissances. Néanmoins, il faut pourtant garder en tête que tous les recruteurs ne sont pas forcément des spécialistes de votre métier en particulier. Bien qu’ils soient en mesure de déceler si vos compétences et expériences conviennent aux besoins de l’entreprise, ils n’ont pas forcément connaissance des multiples sigles que vous utilisez avec vos collègues.</p>
                                    <p>Prenez donc le temps de détailler les acronymes et d’employer des termes compréhensibles lorsque vous envoyez votre candidature. Cela vaut également pour les noms de diplômes !</p>
                                </div>
                            </div><br>
                            <h5>7. Pensez aux rubriques optionnelles</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Contrairement à ce que vous pourriez penser, vos activités extra-professionnelles, vos expériences de bénévolat ou encore les sports que vous pratiquez peuvent être intéressants pour votre profil. Vous postulez chez un équipementier automobile et vous faites partie d’un club de restauration de véhicules anciens ? Ne manquez surtout pas l’occasion de le mentionner sur votre CV ! Même si votre hobby n’est pas directement lié à votre activité, s’il vous permet d’acquérir des compétences qui seraient utiles dans votre poste, ne faites pas l’impasse dessus. Par contre, il convient d’indiquer de préférence les activités en cours ou récentes.</p>
                                </div>
                            </div><br>
                            <h5>8. Choisissez les bons mots-clés</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>La plupart des recruteurs travaillent aujourd’hui avec des ATS, qui sont des logiciels leur permettant d’opérer un tri automatique des CV en fonction de certains mots-clés préalablement définis. Bien que cela puisse paraître désavantageux, vous pouvez réussir à en tirer profit en y prêtant attention. Pour ce faire, lisez attentivement l’offre d’emploi à laquelle vous souhaitez postuler. Dégagez les mots-clés qui s’y trouvent et intégrez-les à votre CV. Autre astuce, consultez le site internet de l’entreprise, en particulier la rubrique RH ou encore les réseaux sociaux. Vous pourrez constater un vocabulaire propre dont vous pourrez vous inspirer pour le contenu de votre CV ciblé.</p>
                                    <p>L'intégration de mots-clés vous servira non seulement pour être pré-sélectionné par les ATS, mais aussi pour figurer parmi les résultats de recherches de profils effectuées sur les sites d’emploi.</p>
                                </div>
                            </div><br>
                            <h5>9. Orthographe et grammaire irréprochables</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Si vous vous êtes assuré de disposer d’un contenu de bonne qualité et d’une mise en page agréable, vous pourrez mettre en valeur vos compétences et qualités pour le poste. Par contre, si à la lecture de votre CV les recruteurs découvrent des fautes d’orthographes et des erreurs grammaticales, vous ne passerez pas la prochaine étape. N'oubliez pas que le CV est votre première opportunité de présenter votre profil aux recruteurs, mais également de vous démarquer des autres candidats. Vous ne pouvez donc pas vous permettre de soumettre un document qui donnerait l’impression que vous n’accordez pas d’importance à votre candidature.</p>
                                </div>
                            </div><br>
                            <h5>10. Faites relire votre CV</h5>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <p>Malgré tout le soin que vous pourrez apporter à la rédaction de votre CV, personne n’est à l’abri de coquilles ou d’erreurs. C'est bien pour cela que le métier de correcteur existe ! Alors n’hésitez pas à solliciter une personne de confiance qui pourra lire votre curriculum vitae avec le recul nécessaire pour vous apporter des corrections ou des suggestions pertinentes pour votre candidature.</p>
                                </div>
                            </div><br>
                        </div>                        
                    </div>
                </div>

                <div class="bg-white rounded px-3 py-4 mb-4">
                    <div class="jbd-01 d-flex align-items-center justify-content-between">
                        <div class="jbd-flex d-flex align-items-center justify-content-start">
                            <div class="jbd-01-thumb">
                                <img src="{{ asset('assets/img/iconcv.png') }}" class="img-fluid" width="90" alt="" />
                            </div>
                            <div class="jbd-01-caption pl-3">
                                <div class="tbd-title"><h4 class="mb-0 ft-medium fs-md">Faire un CV en ligne</h4></div>
                                <div class="jbl_location mb-3">Télécharger simple et facile un CV professionnel en quelques minutes.</div>
                            </div>
                            <div class="jbd-01-right text-right ml-5 hide-1023">
                                <div class="jbl_button mb-2"><a href="{{ route('demandeur.nouveau.cv') }}" class="btn btn-success text-white rounded theme-cl fs-sm ft-medium">Créer un CV</a></div>
                            </div>
                        </div>
                    </div>
                </div>
                
            </div>
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">            
                <img src="{{ asset('assets/img/rediger-un-cv.png') }}" style="width:400px">        
            </div>
        </div>
    </div>
</section>
@endsection