@extends('layouts.app')

@section('title')
    Connexion a mon compte
@endsection

@section('content')
<!-- ======================= Searchbar Banner ======================== -->
<div class="py-5" style="background:#03343b url({{ asset('assets/img/landing-bg.png') }}) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-8 col-lg-10 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4">Connexion à son compte</h1>
                </div>                
            </div>
        </div>
    </div>
</div>
<!-- ======================= Searchbar Banner ======================== -->

<!-- ============================ Job Details Start ================================== -->
<section class="bg-light py-5 position-relative">
    <div class="container">
        <div class="row">           
            <div class="col-xl-8 col-lg-8 col-md-8 col-sm-12">                
                <div class="bg-white rounded mb-4" style="padding-bottom: 10px;">
                    <div class="jb-apply-form bg-white rounded py-3 px-4 box-static">
                        <h2>Connexion</h2><hr>                        
                        <form class="_apply_form_form" method="POST" action="{{ route('login') }}">   
                            @csrf                             
                            <div class="form-group">
                                <label class="text-dark mb-1 ft-medium medium">Adresse Email ou Téléphone <span style="color:red">*</span></label>
                                <input id="login" type="text" class="form-control @error('login') is-invalid @enderror" name="login" value="{{ old('login') }}" required autofocus placeholder="Entrer votre adresse email ou le numéro de téléphone">
                            </div>                              
                            <div class="form-group">
                                <label class="text-dark mb-1 ft-medium medium">Mot de passe <span style="color:red">*</span></label>
                                <input type="password" class="form-control" name="password" placeholder="********">
                            </div>
                            <div class="form-group">
                                <div class="d-flex align-items-center justify-content-between">
                                    <div class="flex-1">
                                        <a href="{{ route('inscription') }}">Créer un compte</a>
                                    </div>  
                                    <div class="eltio_k2">
                                        <a href="{{ route('password.request') }}">Mot de passe oublié ?</a>
                                    </div>  
                                </div>
                            </div>                             
                            <div class="form-group">
                                <button type="submit" class="btn btn-md rounded theme-bg text-light ft-medium fs-sm full-width">Je me connecte</button>
                            </div>                         
                        </form>
                    </div> 
                </div>                
            </div>            
            <!-- Sidebar -->
            <div class="col-xl-4 col-lg-4 col-md-4 col-sm-12">
                <div class="bg-white rounded mb-4">
                    <div class="jbd-01 px-3 py-4">                        
                        <div class="jbd-details mb-3">
                            <h3>Téléphone</h3>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                        <div class="d-flex align-items-center">
                                          <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                            <i class="fa fa-phone small"></i>
                                          </div>
                                          <h6 class="mb-0 ml-3 text-muted fs-sm">+227 20733384</h6>
                                        </div>
                                    </div>
                                    <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                        <div class="d-flex align-items-center">
                                          <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                            <i class="fa fa-phone small"></i>
                                          </div>
                                          <h6 class="mb-0 ml-3 text-muted fs-sm">+227 20737031</h6>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>                        
                        <div class="jbd-details mb-3">
                            <h3>Contact</h3>
                            <div class="position-relative row">
                                <div class="col-lg-12 col-md-12 col-12">
                                    <div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                        <div class="d-flex align-items-center">
                                          <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                            <i class="fa fa-envelope small"></i>
                                          </div>
                                          <h6 class="mb-0 ml-3 text-muted fs-sm">anpe.niger16@gmail.com</h6>
                                        </div>
                                    </div>
                                    <!--div class="mb-2 mr-4 ml-lg-0 mr-lg-4">
                                        <div class="d-flex align-items-center">
                                          <div class="rounded-circle bg-light-success theme-cl p-1 small d-flex align-items-center justify-content-center">
                                            <i class="fa fa-envelope small"></i>
                                          </div>
                                          <h6 class="mb-0 ml-3 text-muted fs-sm">sales@niger.com</h6>
                                        </div>
                                    </div-->
                                </div>
                            </div>
                        </div>                      
                    </div>                    
                    <div class="jbd-02 px-3 py-3 br-top">
                        <div class="jbd-02-flex d-flex align-items-center justify-content-between">
                            <div class="jbd-02-social">
                                <ul class="jbd-social">
                                    <li><a href=" https://www.facebook.com/profile.php?id=100063818243158&mibextid=LQQJ4d" target="_blank"><i class="ti-facebook"></i></a></li>
                                    <li><a href="https://twitter.com/nigeranpe?s=11&t=uohPwLttnCBCpWU1B8bqmA" target="_blank"><i class="ti-twitter"></i></a></li>
                                    <li><a href="anpe.niger16@gmail.com" target="_blank"><i class="ti-google"></i></a></li>
                                    <li><a href="https://www.linkedin.com/company/agence-nationale-pour-la-promotion-de-l-emploi/" target="_blank"><i class="ti-linkedin"></i></a></li>
                                    <li><a href="https://www.instagram.com/p/CpChK3Usqlb/?utm_source=ig_web_copy_link" target="_blank"><i class="ti-instagram"></i></a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>             
        </div>
    </div>
</section>
<!-- ============================ Job Details End ================================== -->
@endsection