<?php
 
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\WelcomeController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\NewsLetterController;
use App\Http\Controllers\ActualiteController;
use App\Http\Controllers\ContactController;
use App\Http\Controllers\Administrateur\AdministrateurController;
use App\Http\Controllers\Entreprise\EntrepriseController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ConfirmPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\Auth\VerificationController;
use App\Http\Controllers\DemandeurEmploi\DemandeurEmploiController;
use App\Http\Controllers\PostulerOffreController;  
    
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
| 
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
| 
*/  


Route::get('/',[WelcomeController::class,'welcome'])->name('welcome');
Route::get('/accueil.html',[WelcomeController::class,'Accueil'])->name('accueil');
Route::get('/offres-d-emploi/{offre_id}-{titre}.html',[WelcomeController::class,'DetailsuneOffre'])->name('detailsuneoffre');
Route::get('/offres-d-emploi.html',[WelcomeController::class,'Offres'])->name('offres');
Route::get('/recherche-offres/resultat.html',[WelcomeController::class,'Recherche'])->name('recherche');
Route::get('/offre-par-type-de-contrat/{typecontrat_id}-{titre}.html',[WelcomeController::class,'OffreParContrat'])->name('offreparcontrat');
Route::get('/offre-par-secteur-activite/{metier_id}.html',[WelcomeController::class,'OffreparMetier'])->name('offreparmetier');
Route::get('/actualites.html', [ActualiteController::class, 'Actualite'])->name('actualite');
Route::get('/actualite/{actualite_id}-{titre}.html', [ActualiteController::class, 'DetailsActualite'])->name('detailsactualite');
Route::get('/categorie-actualite/{categorie_id}.html', [ActualiteController::class, 'DetailsCategorie'])->name('detailscategorie');
Route::post('/save-commentaire/{actualite_id}', [ActualiteController::class, 'SaveCommentaire'])->name('SaveCommentaire');
Route::get('conseils/conseil-pour-rediger-un-cv.html',[WelcomeController::class,'RedigerUnCV'])->name('redigeruncv');
Route::get('conseils/conseil-pour-rediger-une-lettre-de-motivation.html',[WelcomeController::class,'RedigerLettreMotivation'])->name('redigerlettremotivation'); 
Route::get('conseils/conseil-pour-faire-un-entretien-embauche.html',[WelcomeController::class,'EntretienEmbauche'])->name('entretienembauche');
Route::get('/services/programme-d-aide-a-l-insertion-professionnelle-des-jeunes.html',[WelcomeController::class,'PAIJ'])->name('paij');
Route::get('/services/techniques-de-recherche-d-emploi.html',[WelcomeController::class,'TRE'])->name('tre');
Route::get('/services/contrat-de-stage-d-initiation-a-la-vie-professionnelle.html',[WelcomeController::class,'COSIVIP'])->name('cosivip');
Route::get('/services/contrat-de-reconversion-professionnelle.html',[WelcomeController::class,'CRP'])->name('crp');
Route::get('/services/programme-d-aide-a-la-creation-d-entreprises.html',[WelcomeController::class,'PACE'])->name('pace');
Route::get('/services/carte-anpe.html',[WelcomeController::class,'CARTEANPE'])->name('carteanpe');
Route::get('/politique-de-confidentialite.html',[WelcomeController::class,'PolitiqueConfidentialite'])->name('politiqueconfidentialite');

Route::get('/a-propos/presentation.html',[WelcomeController::class,'Presentation'])->name('presentation');
Route::get('/a-propos/nos-agences.html',[WelcomeController::class,'NosAntennes'])->name('nosantennes');
Route::get('/a-propos/publications.html',[WelcomeController::class,'Publications'])->name('publications');
 
Route::get('/contact.html',[ContactController::class,'Contact'])->name('contact'); 
Route::post('/send-contact',[ContactController::class,'SendContact'])->name('send.contact');
Route::post('/save-newsletter', [NewsLetterController::class, 'SaveNewsletter'])->name('save.newsletter');

//Inscription & Connexion Employeur / Candidat
Route::get('/inscription.html', [WelcomeController::class, 'Inscription'])->name('inscription');
Route::get('/creer-un-compte/demandeur-emploi.html', [WelcomeController::class, 'DemandeurEmploiCompteCreate'])->name('creationcomptedemandeuremploi');
Route::get('/creer-un-compte/entreprise.html', [WelcomeController::class, 'EntrepriseCompteCreate'])->name('creationcompteentreprise');
Route::get('/se-connecter.html', [WelcomeController::class, 'SeConnecter'])->name('seconnecter');

Route::post('/checkPhoneNumber', [WelcomeController::class, 'checkPhoneNumber'])->name('users.telephone');

Auth::routes();

Route::get('/home', [HomeController::class, 'index'])->name('home');

Route::get('/postuler/{offre_id}-{offre}.html', [PostulerOffreController::class, 'PostuleraOffre'])->name('postuler.offre');


/*
|--------------------------------------------------------------------------
| Routes Administrateur
|--------------------------------------------------------------------------
*/
Route::get('/gestion-employeur/liste-employeurs-a-valider.html', [AdministrateurController::class, 'EntrepriseaValider'])->name('admin.valider.entreprise');
Route::get('/gestion-employeur/liste-employeurs-a-valider/{details}-{titre}.html', [AdministrateurController::class, 'EntrepriseDetailsValider'])->name('admin.detailsvalider.entreprise');
Route::get('/gestion-employeur/liste-des-employeurs.html', [AdministrateurController::class, 'EntrepriseListe'])->name('admin.liste.entreprise');
Route::get('/gestion-employeur/creer-un-compte-employeur.html', [AdministrateurController::class, 'EntrepriseCreerCompte'])->name('admin.creer.entreprise');
Route::post('/gestion-employeur/save-creer-un-compte-employeur.html', [AdministrateurController::class, 'SaveEntrepriseCreerCompte'])->name('admin.save.creer.entreprise');
Route::get('/gestion-employeur/modifier-compte/{id}-{titre}.html', [AdministrateurController::class, 'EntrepriseModifierCompte'])->name('admin.modifier.entreprise');
Route::post('/gestion-employeur/save-modifier-compte/{id}', [AdministrateurController::class, 'SaveEntrepriseModifierCompte'])->name('admin.save.modifier.entreprise');
Route::get('/gestion-employeur/liste-des-employeur/details/{id}-{titre}.html', [AdministrateurController::class, 'EntrepriseDetails'])->name('admin.entreprise.details');
Route::post('/gestion-employeur/valider-compte-entreprise/{id}', [AdministrateurController::class, 'EntrepriseValiderCompte'])->name('admin.entreprise.validercompte');
Route::get('/gestion-employeur/supprimer/{id}', [AdministrateurController::class, 'EntrepriseSupprimer'])->name('admin.entreprise.supprimer');
Route::get('/gestion-employeur/employeurs-a-valider/{id}-{titre}.html', [AdministrateurController::class, 'EntrepriseValider'])->name('admin.entreprise.valider');
Route::post('/gestion-employeur/save-employeurs-a-valider/{id}', [AdministrateurController::class, 'SaveEntrepriseValider'])->name('admin.save.entreprise.valider');
Route::get('/gestion-employeur/liste-des-employeur/export-excel', [AdministrateurController::class, 'EntrepriseExportExcel'])->name('admin.entreprise.exprot-excel');
Route::get('/gestion-employeur/liste-des-employeur/export-pdf', [AdministrateurController::class, 'EntrepriseExportPDF'])->name('admin.entreprise.exprot-pdf');
Route::get('/gestion-employeur/employeurs-a-valider/export-excel', [AdministrateurController::class, 'EntrepriseNonValiderExportExcel'])->name('admin.valider.exprot-excel');
Route::get('/gestion-employeur/employeurs-a-valider/export-pdf', [AdministrateurController::class, 'EntrepriseNonValiderExportPDF'])->name('admin.valider.exprot-pdf');
Route::get('/gestion-employeur/details-employeur/message/{candidature_id}.html', [AdministrateurController::class, 'MessageFinContrat'])->name('admin.rapelle.entreprise');
Route::get('/gestion-employeur/fermer-compte/{id}', [AdministrateurController::class, 'FermerCompte'])->name('admin.fermer.compte');
Route::get('/gestion-employeur/activer-compte/{id}', [AdministrateurController::class, 'ActiverCompte'])->name('admin.activer.compte');

Route::get('/gestion-offres/offres-a-valider.html', [AdministrateurController::class, 'OffreaValider'])->name('admin.valider.offre');
Route::get('/gestion-offres/offres-a-valider/details/{offre_id}-{titre}.html', [AdministrateurController::class, 'DetailsOffreaValider'])->name('admin.details.offreavalider');
Route::get('/gestion-offres/liste-des-offres.html', [AdministrateurController::class, 'OffreListe'])->name('admin.liste.offre');
Route::get('/gestion-offres/offres-expirees.html', [AdministrateurController::class, 'OffreExpiree'])->name('admin.offre.expiree');
Route::get('/gestion-offres/publier-offre/{offre_id}.html', [AdministrateurController::class, 'ValiderPublierOffre'])->name('admin.valider.offrepublie');
Route::post('/gestion-offres/publier-valider-offre/{offre_id}.html', [AdministrateurController::class, 'PublierValiderOffre'])->name('admin.offre.publiervalider');
Route::get('/gestion-offres/publier-une-offre-d-emploi.html', [AdministrateurController::class, 'PublierOffreEmploi'])->name('admin.publier.offreemploi');
Route::get('/gestion-offres/publier-une-offre-d-emploi-pour-un-employeur.html', [AdministrateurController::class, 'EmployeurPublierOffreEmploi'])->name('admin.publier.employeuroffreemploi');
Route::post('/gestion-offres/save-publier-une-offre-employeur', [AdministrateurController::class, 'EmployeurSavePublierOffreEmploi'])->name('admin.employeursavepublieroffreemploi');
Route::get('/gestion-offres/modifier-offre/{offre_id}-{titre}.html', [AdministrateurController::class, 'ModifierOffreEmploi'])->name('admin.publier.modifieroffreemploi');
Route::post('/gestion-offres/relancer-offre/{offre_id}', [AdministrateurController::class, 'RelancerOfre'])->name('admin.publier.relanceroffre');
Route::post('/gestion-offres/save-publier-une-offre-d-emploi', [AdministrateurController::class, 'SavePublierOffreEmploi'])->name('admin.savepublieroffreemploi');
Route::get('/gestion-offres/modifier-offre-d-emploi/{offre_id}.html', [AdministrateurController::class, 'ModifierPublierOffreEmploi'])->name('admin.modifieroffreemploi');
Route::post('/save-modifier-offre-d-emploi/{offre_id}', [AdministrateurController::class, 'SaveModifierPublierOffreEmploi'])->name('admin.savemodifieroffreemploi');
Route::get('/gestion-offres/liste-des-offres/details-offre/{offre_id}.html', [AdministrateurController::class, 'DetailsdeOffre'])->name('admin.details.offre');
Route::get('/gestion-offres/liste-offres-a-valider/supprimer-offre/{offre_id}', [AdministrateurController::class, 'SupprimerAdminOffre'])->name('admin.supprimer.offre');
Route::get('/gestion-offres/liste-offres-a-valider/export-excel', [AdministrateurController::class, 'ExportOffreaValiderExcel'])->name('admin.export-offre-avalider.excel');
Route::get('/gestion-offres/liste-offres-a-valider/export-pdf', [AdministrateurController::class, 'ExportOffreaValiderPDF'])->name('admin.export-offre-avalider.pdf');
Route::get('/gestion-offres/liste-offres/export-excel', [AdministrateurController::class, 'ExportOffreExcel'])->name('admin.export-offre.excel');
Route::get('/gestion-offres/liste-offres/export-pdf', [AdministrateurController::class, 'ExportOffrePDF'])->name('admin.export-offre.pdf');
Route::get('/gestion-offres/liste-offres-expirees/export-excel', [AdministrateurController::class, 'ExportOffreExpireeExcel'])->name('admin.export-offre-expiree.excel');
Route::get('/gestion-offres/liste-offres-expirees/export-pdf', [AdministrateurController::class, 'ExportOffreExpireePDF'])->name('admin.export-offre-expiree.pdf');
Route::get('/gestion-offres/activer-offre/{offre_id}', [AdministrateurController::class, 'ActiverOffre'])->name('admin.activer.offre');
Route::get('/gestion-offres/desactiver-offre/{offre_id}', [AdministrateurController::class, 'DesactiverOffre'])->name('admin.desactiver.offre');
 
Route::get('/gestion-des-demandeurs/liste-des-demandeurs-emploi.html', [AdministrateurController::class, 'ListeDemandeurEmploi'])->name('admin.liste.demandeur');
Route::get('/gestion-des-demandeurs/liste-des-demandeurs-a-valider.html', [AdministrateurController::class, 'ListeDemandeuraValider'])->name('admin.demandeur.sanscarte');
Route::get('/gestion-des-demandeurs/liste-des-demandeurs-a-valider/valider-compte/{id}-{titre}.html', [AdministrateurController::class, 'FormulaireValiderDemandeur'])->name('admin.valider.demandeur');
Route::get('/gestion-des-demandeurs/generer-la-carte/{id}', [AdministrateurController::class, 'GenererCarteDemandeur'])->name('admin.demandeur.generercarte');
Route::post('/gestion-des-demandeurs/generer-la-carte-valider/{id}', [AdministrateurController::class, 'GenererCarteActiverDemandeur'])->name('admin.demandeur.generercartevalider');
Route::get('/gestion-des-demandeurs/activer-compte/{id}', [AdministrateurController::class, 'ActiverCompteDemandeur'])->name('admin.activer.demandeur');
Route::get('/gestion-des-demandeurs/desactiver-compte/{id}', [AdministrateurController::class, 'DesactiverCompteDemandeur'])->name('admin.desactiver.demandeur');
Route::get('/gestion-des-demandeurs/supprimer-demandeur-emploi/{id}', [AdministrateurController::class, 'SupprimerDemandeurEmploi'])->name('admin.demandeur.supprimer');
Route::get('/gestion-des-demandeurs/liste-des-demandeurs-emploi/details/{id}-{titre}.html',[AdministrateurController::class,'DetailsDemandeurEmploi'])->name('admin.demandeur.details');
Route::get('/gestion-des-demandeurs/creer-un-compte-demandeur-emploi.html', [AdministrateurController::class, 'CreerCompteDemandeurEmploi'])->name('admin.demandeur.creercompte');
Route::get('/gestion-des-demandeurs/modifier-compte/{id}-{titre}.html', [AdministrateurController::class, 'ModifierCompteDemandeurEmploi'])->name('admin.demandeur.modifier');
Route::post('/gestion-des-demandeurs/save-creer-un-compte-demandeur-emploi', [AdministrateurController::class, 'SaveCreerCompteDemandeurEmploi'])->name('admin.demandeur.savecreercompte');
Route::post('/gestion-des-demandeurs/modifier-compte/{id}', [AdministrateurController::class, 'SaveModifierCompteDemandeurEmploi'])->name('admin.demandeur.savemodifiercompte');
Route::get('/gestion-des-demandeurs/liste-des-candidatures-a-valider.html', [AdministrateurController::class, 'CandidatureaValider'])->name('admin.candidature.avalider');
Route::get('/gestion-des-demandeurs/valider-demande-emploi/{candidature_id}.html', [AdministrateurController::class, 'ValidationCandidature'])->name('admin.candidature.valider');
Route::get('/gestion-des-demandeurs/supprimer-demande-emploi/{candidature_id}', [AdministrateurController::class, 'SupprimerCandidature'])->name('admin.candidature.supprimer');
Route::post('/save-validation-candidature/{candidature_id}', [AdministrateurController::class, 'SaveValidationduCandidat'])->name('admin.save.validercandidature');
Route::get('/gestion-des-demandeurs/liste-des-candidatures-anpe.html', [AdministrateurController::class, 'DemandeEmploiANPE'])->name('admin.demande.candidatureanpe');
Route::get('/gestion-des-demandeurs/liste-des-candidatures.html', [AdministrateurController::class, 'ListeDemandeEmploi'])->name('admin.liste.candidature');
Route::get('/gestion-des-demandeurs/liste-des-candidatures/{candidature_id}.html', [AdministrateurController::class, 'ValiderCandidature'])->name('admin.valider.candidature');
Route::post('/gestion-des-demandeurs/liste-des-candidatures/valider/{candidature_id}', [AdministrateurController::class, 'AdminValiderCandidature'])->name('admin.savevalider.candidature');
Route::get('/gestion-des-demandeurs/denamdeur-emploi-export-excel', [AdministrateurController::class, 'ExportDemandeurEmploiExcel'])->name('admin.demandeur-emploi-export.excel');
Route::get('/gestion-des-demandeurs/denamdeur-emploi-export-pdf', [AdministrateurController::class, 'ExportDemandeurEmploiPDF'])->name('admin.demandeur-emploi-export.pdf');
Route::get('/gestion-des-demandeurs/candidature-export-pdf', [AdministrateurController::class, 'ExportCandidaturePDF'])->name('admin.candidature-export.pdf');
Route::get('/gestion-des-demandeurs/candidature-export-excel', [AdministrateurController::class, 'ExportCandidatureExcel'])->name('admin.candidature-export.excel');
Route::get('/gestion-des-demandeurs/candidature-valider-export-pdf', [AdministrateurController::class, 'ExportCandidatureValidePDF'])->name('admin.candidature-valider-export.pdf');
Route::get('/gestion-des-demandeurs/candidature-valider-export-excel', [AdministrateurController::class, 'ExportCandidatureValideExcel'])->name('admin.candidature-valider-export.excel');
Route::get('/gestion-des-demandeurs/demandeur-carte-expiree.html', [AdministrateurController::class, 'DemandeurCarteExpiree'])->name('admin.demandeur.carte.expiree');
Route::get('/gestion-des-demandeurs/demandeur-carte-expiree/details/{id}-{titre}.html', [AdministrateurController::class, 'DetailsDemandeurCarteExpiree'])->name('admin.details.carte.expiree');
Route::post('/gestion-des-demandeurs/post-renouvele-compte-expiree/{id}', [AdministrateurController::class, 'PostRenouvelerCarte'])->name('admin.postrenouveler.carte.expiree');
Route::get('/gestion-des-demandeurs/renouveler-compte-expiree/{id}', [AdministrateurController::class, 'RenouvelerCarte'])->name('admin.renouveler.carte.expiree');
Route::get('/gestion-des-demandeurs/extraction-des-profils-de-candidatures.html', [AdministrateurController::class, 'ListeProfilCandidature'])->name('admin.profil.candidature');
Route::get('/gestion-des-demandeurs/extraction-des-profils-de-candidatures-excel', [AdministrateurController::class, 'ExtrationDonnees'])->name('admin.extraction.donnees');

Route::get('/gestion-des-agents/liste-des-agents.html', [AdministrateurController::class, 'ListeUtilisateur'])->name('admin.liste.utilisateur');
Route::get('/gestion-des-agents/creer-compte-agent.html', [AdministrateurController::class, 'CreerCompteUtilisateur'])->name('admin.compte.utilisateur');
Route::post('/gestion-des-agents/save-compte.html', [AdministrateurController::class, 'SaveCompteUtilisateur'])->name('admin.save-compte.utilisateur');
Route::get('/profil/{profil_id}/actions', [AdministrateurController::class, 'getActions']);
Route::get('/gestion-des-agents/details-utilisateur/{id}-{titre}.html', [AdministrateurController::class, 'DetailsCompteUtilisateur'])->name('admin.details.utilisateur');
Route::get('/gestion-des-agents/modifier-utilisateur/{id}-{titre}.html', [AdministrateurController::class, 'ModifierCompteUtilisateur'])->name('admin.modifier.utilisateur');
Route::post('/gestion-des-agents/save-modifier/{id}', [AdministrateurController::class, 'SaveModifierCompteUtilisateur'])->name('admin.save-modifier.utilisateur');
Route::get('/gestion-des-agents/supprimer/{id}', [AdministrateurController::class, 'SupprimerUtilisateur'])->name('admin.supprimer.utilisateur');
Route::get('/gestion-des-agents/export-pdf', [AdministrateurController::class, 'ExportUtilisateurPDF'])->name('admin.export-utilisateur.pdf');
Route::get('/gestion-des-agents/export-excel', [AdministrateurController::class, 'ExportUtilisateurExcel'])->name('admin.export-utilisateur.excel');
Route::get('/gestion-des-agents/activer-compte/{id}', [AdministrateurController::class, 'ActiverUtilisateur'])->name('admin.activer-compte.utilisateur');
Route::get('/gestion-des-agents/desactiver-compte/{id}', [AdministrateurController::class, 'DesctiverUtilisateur'])->name('admin.desactiver-compte.utilisateur');
Route::get('/gestion-des-agents/activer-action-autorisee/{id}/{action_autorisee_id}', [AdministrateurController::class, 'ActiverActionAutorisee'])->name('admin.activer-action-autorisee');
Route::get('/gestion-des-agents/desactiver-action-autorisee/{id}/{action_autorisee_id}', [AdministrateurController::class, 'DesactiverActionAutorisee'])->name('admin.desactiver-action-autorisee');

Route::get('/gestion-de-la-cv-theque/liste-des-demandes-cv-theque.html', [AdministrateurController::class, 'ListeCVTheque'])->name('admin.liste.cvtheque');
Route::post('/valider-cv-theque', [AdministrateurController::class, 'ValiderCVTheque'])->name('admin.valider.cvtheque');

Route::get('/gestion-articles/liste-des-articles.html', [AdministrateurController::class, 'ListeArticle'])->name('admin.liste.article');
Route::get('/gestion-articles/liste-des-articles/details/{actualite_id}-{libelle}.html', [AdministrateurController::class, 'DetailsArticle'])->name('admin.details.article');
Route::get('/gestion-articles/publier-un-article.html', [AdministrateurController::class, 'PublierArticle'])->name('admin.publier.article');
Route::post('/gestion-articles/save-article', [AdministrateurController::class, 'SaveArticle'])->name('admin.save.article');
Route::get('/gestion-articles/modifier/{actualite_id}-{libelle}.html', [AdministrateurController::class, 'ModifierArticle'])->name('admin.modifier.article');
Route::post('/gestion-articles/save-modifier-article/{actualite_id}', [AdministrateurController::class, 'SaveModifierArticle'])->name('admin.save-modifier.article');
Route::get('/gestion-articles/supprimer-article/{actualite_id}', [AdministrateurController::class, 'SupprimerArticle'])->name('admin.supprimer.article');
Route::get('/gestion-articles/liste-des-articles-expires.html', [AdministrateurController::class, 'ListeArticleExpire'])->name('admin.liste.article.expire');
Route::post('/gestion-articles/liste-des-articles-expires/{actualite_id}', [AdministrateurController::class, 'RelancerArticleExpire'])->name('admin.relancer.article.expire');

Route::get('/gestion-articles/activer-article/{actualite_id}', [AdministrateurController::class, 'ActiveArticle'])->name('admin.activer.article');
Route::get('/gestion-articles/desactiver-article/{actualite_id}', [AdministrateurController::class, 'DesactiveArticle'])->name('admin.desactiver.article');
Route::get('/gestion-articles/commentaire-a-valider.html', [AdministrateurController::class, 'CommentaireaValider'])->name('admin.commentaire.avalider');
Route::get('/gestion-articles/valider-commentaire/{commentaire_id}', [AdministrateurController::class, 'ValiderCommentaire'])->name('admin.valider.commentaire');
Route::get('/gestion-articles/supprimer-commentaire/{commentaire_id}', [AdministrateurController::class, 'SupprimerCommentaire'])->name('admin.supprimer.commentaire');
Route::get('/gestion-articles/liste-des-commentaires.html', [AdministrateurController::class, 'ListeCommentaire'])->name('admin.liste.commentaire');
Route::get('/gestion-articles/activer-commentaire/{commentaire_id}', [AdministrateurController::class, 'ActiverCommentaire'])->name('admin.activer.commentaire');
Route::get('/gestion-articles/desactiver-commentaire/{commentaire_id}', [AdministrateurController::class, 'DesactiverCommentaire'])->name('admin.desactiver.commentaire');

Route::get('/publier-des-fichiers/liste-des-fichiers-publies', [AdministrateurController::class, 'ListePublication'])->name('admin.liste.publication');
Route::post('/publication-de-fichiers/save-fichier', [AdministrateurController::class, 'SavePublication'])->name('admin.save.publication');
Route::post('publier-des-fichiers/modifier-fichier/{publication_id}', [AdministrateurController::class, 'ModifierPublication'])->name('admin.modifier.publication');
Route::get('/publication-de-fichiers/activer-publication/{publication_id}', [AdministrateurController::class, 'ActiverPublication'])->name('admin.activer.publication');
Route::get('/publication-de-fichiers/desactiver-publication/{publication_id}', [AdministrateurController::class, 'DesactiverPublication'])->name('admin.desactiver.publication');
Route::get('/publication-de-fichiers/supprimer-fichier/{publication_id}', [AdministrateurController::class, 'SupprimerPublication'])->name('admin.supprimer.publication');

Route::get('/statistiques/statistiques-journalieres.html', [AdministrateurController::class, 'StatistiqueJournalieres'])->name('admin.statistiques.journalieres');
Route::get('/statistique/statitisques-mensuelles.html', [AdministrateurController::class, 'StatistiqueMensuelles'])->name('admin.statistiques.mensuelles');
Route::get('/statistique/statitisques-annuelles.html', [AdministrateurController::class, 'Statistiques'])->name('admin.statistiques.annuelles');
Route::get('/statistique/excel-statitisques-journalieres-demp', [AdministrateurController::class, 'ExcelStatistiqueJournalieresDemp'])->name('admin.excel-statistiques.journalieres-demp');
Route::get('/statistique/excel-statitisques-journalieresemp', [AdministrateurController::class, 'ExcelStatistiqueJournalieresEmp'])->name('admin.excel-statistiques.journalieres-emp');
Route::get('/statistique/excel-statitisques-journalieres-offrepub', [AdministrateurController::class, 'ExcelStatistiqueJournalieresOffrePub'])->name('admin.excel-statistiques.journalieres-offrepub');
Route::get('/statistique/excel-statitisques-journalieres-offrebroui', [AdministrateurController::class, 'ExcelStatistiqueJournalieresOffreBroui'])->name('admin.excel-statistiques.journalieres-offrebroui');
Route::get('/statistique/excel-statitisques-mensuelles-emp', [AdministrateurController::class, 'ExcelStatistiqueMensuellesEmp'])->name('admin.excel-statistiques.mensuelles-emp');
Route::get('/statistique/excel-statitisques-mensuelles-demp', [AdministrateurController::class, 'ExcelStatistiqueMensuellesDemp'])->name('admin.excel-statistiques.mensuelles-demp');
Route::get('/statistique/excel-statitisques-mensuelles-offrepub', [AdministrateurController::class, 'ExcelStatistiqueMensuellesOffrePub'])->name('admin.excel-statistiques.mensuelles-offrepub');
Route::get('/statistique/excel-statitisques-mensuelles-offrebroui', [AdministrateurController::class, 'ExcelStatistiqueMensuellesOffreBroui'])->name('admin.excel-statistiques.mensuelles-offrebroui');
Route::get('/statistique/excel-statitisques-annuelles-emp', [AdministrateurController::class, 'ExcelStatistiqueAnnuellesEmp'])->name('admin.excel-statistiques.annuelles-emp');
Route::get('/statistique/excel-statitisques-annuelles-demp', [AdministrateurController::class, 'ExcelStatistiqueAnnuellesDemp'])->name('admin.excel-statistiques.annuelles-demp');
Route::get('/statistique/excel-statitisques-annuelles-offrepub', [AdministrateurController::class, 'ExcelStatistiqueAnnuellesOffrepub'])->name('admin.excel-statistiques.annuelles-offrepub');
Route::get('/statistique/excel-statitisques-annuelles-offrebroui', [AdministrateurController::class, 'ExcelStatistiqueAnnuellesOffrebroui'])->name('admin.excel-statistiques.annuelles-offrebroui');

Route::get('/administrateur/mon-compte.html',[AdministrateurController::class,'CompteAdmin'])->name('admin.compte');
Route::post('/save-modifier-admin-compte',[AdministrateurController::class,'SaveAdminModifierCompte'])->name('admin.save.modifer.compte');
Route::post('/save-modifier-password',[AdministrateurController::class,'SaveAdminModifierMotePasse'])->name('admin.save.password');

Route::get('/parametrage-de-base/categorie-article.html', [AdministrateurController::class, 'CategorieArticle'])->name('admin.categorie.article');
Route::post('/parametrage-de-base/save-categorie-article', [AdministrateurController::class, 'SaveCategorieArticle'])->name('admin.save.categorie');
Route::post('/parametrage-de-base/modifier-categorie-article/{categorie_id}', [AdministrateurController::class, 'ModifierCategorieArticle'])->name('admin.modifier.categorie');
Route::get('/parametrage-de-base/supprimer-categorie-article/{categorie_id}', [AdministrateurController::class, 'SupprimerCategorieArticle'])->name('admin.supprimer.categorie');
Route::get('/parametrage-de-base/activer-categorie-article/{categorie_id}', [AdministrateurController::class, 'ActiverCategorieArticle'])->name('admin.activer.categorie');
Route::get('/parametrage-de-base/desactiver-categorie-article/{categorie_id}', [AdministrateurController::class, 'DesactiverCategorieArticle'])->name('admin.desactiver.categorie');

Route::get('/parametrage-de-base/diplome.html', [AdministrateurController::class, 'Diplomes'])->name('admin.diplome');
Route::post('/parametrage-de-base/save-diplome', [AdministrateurController::class, 'SaveDiplome'])->name('admin.save.diplome');
Route::post('/parametrage-de-base/modifier-diplome/{diplome_id}', [AdministrateurController::class, 'ModifierDiplome'])->name('admin.modifier.diplome');
Route::get('/parametrage-de-base/supprimer-diplome/{diplome_id}', [AdministrateurController::class, 'SupprimerDiplome'])->name('admin.supprimer.diplome');
Route::get('/parametrage-de-base/activer-diplome/{diplome_id}', [AdministrateurController::class, 'ActiverDiplome'])->name('admin.activer.diplome');
Route::get('/parametrage-de-base/desactiver-diplome/{diplome_id}', [AdministrateurController::class, 'DesactiverDiplome'])->name('admin.desactiver.diplome');
 
Route::get('/parametrage-de-base/secteur-d-activite.html', [AdministrateurController::class, 'SecteurActivite'])->name('admin.secteuractivite');
Route::post('/parametrage-de-base/save-secteur-d-activite', [AdministrateurController::class, 'SaveSecteurActivite'])->name('admin.save.secteuractivite');
Route::post('/parametrage-de-base/modifier-secteur-d-activite/{secteuractivite_id}', [AdministrateurController::class, 'ModifierSecteurActivite'])->name('admin.modifier.secteuractivite');
Route::get('/parametrage-de-base/supprimer-secteur-d-activite/{secteuractivite_id}', [AdministrateurController::class, 'SupprimerSecteurActivite'])->name('admin.supprimer.secteuractivite');
Route::get('/parametrage-de-base/activer-secteur-d-activite/{secteuractivite_id}', [AdministrateurController::class, 'ActiverSecteurActivite'])->name('admin.activer.secteuractivite');
Route::get('/parametrage-de-base/desactiver-secteur-d-activite/{secteuractivite_id}', [AdministrateurController::class, 'DesactiverSecteurActivite'])->name('admin.desactiver.secteuractivite');

Route::get('/parametrage-de-base/filiere.html', [AdministrateurController::class, 'Filiere'])->name('admin.filiere');
Route::post('/parametrage-de-base/save-filiere', [AdministrateurController::class, 'SaveFiliere'])->name('admin.save.filiere');
Route::post('/parametrage-de-base/modifier-filiere/{metier_id}', [AdministrateurController::class, 'ModifierFiliere'])->name('admin.modifier.filiere');
Route::get('/parametrage-de-base/supprimer-filiere/{metier_id}', [AdministrateurController::class, 'SupprimerFiliere'])->name('admin.supprimer.filiere');
Route::get('/parametrage-de-base/activer-filiere/{metier_id}', [AdministrateurController::class, 'ActiverFiliere'])->name('admin.activer.filiere');
Route::get('/parametrage-de-base/desactiver-filiere/{metier_id}', [AdministrateurController::class, 'DesactiverFiliere'])->name('admin.desactiver.filiere');

Route::get('/parametrage-de-base/situation-entreprise.html', [AdministrateurController::class, 'SituationActivite'])->name('admin.situationentreprise');
Route::post('/parametrage-de-base/save-situation-entreprise', [AdministrateurController::class, 'SaveSituationActivite'])->name('admin.save.situationentreprise');
Route::post('/parametrage-de-base/modifier-situation-entreprise/{situationentreprise_id}', [AdministrateurController::class, 'ModifierSituationActivite'])->name('admin.modifier.situationentreprise');
Route::get('/parametrage-de-base/supprimer-situation-entreprise/{situationentreprise_id}', [AdministrateurController::class, 'SupprimerSituationActivite'])->name('admin.supprimer.situationentreprise');
Route::get('/parametrage-de-base/activer-situation-entreprise/{situationentreprise_id}', [AdministrateurController::class, 'ActiverSituationActivite'])->name('admin.activer.situationentreprise');
Route::get('/parametrage-de-base/desactiver-situation-entreprise/{situationentreprise_id}', [AdministrateurController::class, 'DesactiverSituationActivite'])->name('admin.desactiver.situationentreprise');

Route::get('/parametrage-de-base/statut-entreprise.html', [AdministrateurController::class, 'StatutEntreprise'])->name('admin.statutentreprise');
Route::post('/parametrage-de-base/save-statut-entreprise', [AdministrateurController::class, 'SaveStatutEntreprise'])->name('admin.save.statutentreprise');
Route::post('/parametrage-de-base/modifier-statut-entreprise/{statutentreprise_id}', [AdministrateurController::class, 'ModifierStatutEntreprise'])->name('admin.modifier.statutentreprise');
Route::get('/parametrage-de-base/supprimer-statut-entreprise/{statutentreprise_id}', [AdministrateurController::class, 'SupprimerStatutEntreprise'])->name('admin.supprimer.statutentreprise');
Route::get('/parametrage-de-base/activer-statut-entreprise/{statutentreprise_id}', [AdministrateurController::class, 'ActiverStatutEntreprise'])->name('admin.activer.statutentreprise');
Route::get('/parametrage-de-base/desactiver-statut-entreprise/{statutentreprise_id}', [AdministrateurController::class, 'DesactiverStatutEntreprise'])->name('admin.desactiver.statutentreprise');

Route::get('/parametrage-de-base/type-de-contrat.html', [AdministrateurController::class, 'TypeContrat'])->name('admin.typecontrat');
Route::post('/parametrage-de-base/save-type-de-contrat', [AdministrateurController::class, 'SaveTypeContrat'])->name('admin.save.typecontrat');
Route::post('/parametrage-de-base/modifier-type-de-contrat/{typecontrat_id}', [AdministrateurController::class, 'ModifierTypeContrat'])->name('admin.modifier.typecontrat');
Route::get('/parametrage-de-base/supprimer-type-de-contrat/{typecontrat_id}', [AdministrateurController::class, 'SupprimerTypeContrat'])->name('admin.supprimer.typecontrat');
Route::get('/parametrage-de-base/activer-type-de-contrat/{typecontrat_id}', [AdministrateurController::class, 'ActiverTypeContrat'])->name('admin.activer.typecontrat');
Route::get('/parametrage-de-base/desactiver-type-de-contrat/{typecontrat_id}', [AdministrateurController::class, 'DesactiverTypeContrat'])->name('admin.desactiver.typecontrat');

Route::get('/parametrage-de-base/nationalite-entreprise.html', [AdministrateurController::class, 'Nationalite'])->name('admin.nationaliteentreprise');
Route::post('/parametrage-de-base/save-nationalite-entreprise', [AdministrateurController::class, 'SaveNationalite'])->name('admin.save.nationaliteentreprise');
Route::post('/parametrage-de-base/modifier-nationalite-entreprise/{nationalite_id}', [AdministrateurController::class, 'ModifierNationalite'])->name('admin.modifier.nationaliteentreprise');
Route::get('/parametrage-de-base/supprimer-nationalite-entreprise/{nationalite_id}', [AdministrateurController::class, 'SupprimerNationalite'])->name('admin.supprimer.nationaliteentreprise');
Route::get('/parametrage-de-base/activer-nationalite-entreprise/{nationalite_id}', [AdministrateurController::class, 'ActiverNationalite'])->name('admin.activer.nationaliteentreprise');
Route::get('/parametrage-de-base/desactiver-nationalite-entreprise/{nationalite_id}', [AdministrateurController::class, 'DesactiverNationalite'])->name('admin.desactiver.nationaliteentreprise');

Route::get('/parametrage-de-base/nationalite.html', [AdministrateurController::class, 'Pays'])->name('admin.pays');
Route::post('/parametrage-de-base/save-nationalite', [AdministrateurController::class, 'SavePays'])->name('admin.save.pays');
Route::post('/parametrage-de-base/modifier-nationalite/{pays_id}', [AdministrateurController::class, 'ModifierPays'])->name('admin.modifier.pays');
Route::get('/parametrage-de-base/supprimer-nationalite/{pays_id}', [AdministrateurController::class, 'SupprimerPays'])->name('admin.supprimer.pays');
Route::get('/parametrage-de-base/activer-nationalite/{pays_id}', [AdministrateurController::class, 'ActiverPays'])->name('admin.activer.pays');
Route::get('/parametrage-de-base/desactiver-nationalite/{pays_id}', [AdministrateurController::class, 'DesactiverPays'])->name('admin.desactiver.pays');

Route::get('/parametrage-de-base/regions.html', [AdministrateurController::class, 'Region'])->name('admin.region');
Route::post('/parametrage-de-base/save-regions', [AdministrateurController::class, 'SaveRegion'])->name('admin.save.region');
Route::post('/parametrage-de-base/modifier-regions/{region_id}', [AdministrateurController::class, 'ModifierRegion'])->name('admin.modifier.region');
Route::get('/parametrage-de-base/supprimer-regions/{region_id}', [AdministrateurController::class, 'SupprimerRegion'])->name('admin.supprimer.region');
Route::get('/parametrage-de-base/activer-regions/{region_id}', [AdministrateurController::class, 'ActiverRegion'])->name('admin.activer.region');
Route::get('/parametrage-de-base/desactiver-regions/{region_id}', [AdministrateurController::class, 'DesactiverRegion'])->name('admin.desactiver.region');

Route::get('/parametrage-de-base/langues-locales.html', [AdministrateurController::class, 'LangueLocale'])->name('admin.languelocale');
Route::post('/parametrage-de-base/save-langues-locales', [AdministrateurController::class, 'SaveLangueLocale'])->name('admin.save.languelocale');
Route::post('/parametrage-de-base/modifier-langues-locales/{languelocal_id}', [AdministrateurController::class, 'ModifierLangueLocale'])->name('admin.modifier.languelocale');
Route::get('/parametrage-de-base/supprimer-langues-locales/{languelocal_id}', [AdministrateurController::class, 'SupprimerLangueLocale'])->name('admin.supprimer.languelocale');
Route::get('/parametrage-de-base/activer-langues-locales/{languelocal_id}', [AdministrateurController::class, 'ActiverLangueLocale'])->name('admin.activer.languelocale');
Route::get('/parametrage-de-base/desactiver-langues-locales/{languelocal_id}', [AdministrateurController::class, 'DesactiverLangueLocale'])->name('admin.desactiver.languelocale');

Route::get('/parametrage-de-base/langues-internationales.html', [AdministrateurController::class, 'LangueInternationale'])->name('admin.langueinter');
Route::post('/parametrage-de-base/save-langues-internationales', [AdministrateurController::class, 'SaveLangueInternationale'])->name('admin.save.langueinter');
Route::post('/parametrage-de-base/modifier-langues-internationales/{langueinter_id}', [AdministrateurController::class, 'ModifierLangueInternationale'])->name('admin.modifier.langueinter');
Route::get('/parametrage-de-base/supprimer-langues-internationales/{langueinter_id}', [AdministrateurController::class, 'SupprimerLangueInternationale'])->name('admin.supprimer.langueinter');
Route::get('/parametrage-de-base/activer-langues-internationales/{langueinter_id}', [AdministrateurController::class, 'ActiverLangueInternationale'])->name('admin.activer.langueinter');
Route::get('/parametrage-de-base/desactiver-langues-internationales/{langueinter_id}', [AdministrateurController::class, 'DesactiverLangueInternationale'])->name('admin.desactiver.langueinter');

Route::get('/parametrage-de-base/sliders-images-accueil.html', [AdministrateurController::class, 'SlidersImagesAccueil'])->name('admin.sliders.images.accueil');
Route::post('/parametrage-de-base/save-sliders-images-accueil', [AdministrateurController::class, 'SaveSliderImagesAccueil'])->name('admin.save.sliders.images.accueil');
Route::post('/parametrage-de-base/modifier-sliders-images-accueil/{sliders_id}', [AdministrateurController::class, 'ModifierSliderImagesAccueil'])->name('admin.modifier.sliders.images.accueil');
Route::get('/parametrage-de-base/supprimer-sliders-images-accueil/{sliders_id}', [AdministrateurController::class, 'SupprimerSliderImagesAccueil'])->name('admin.supprimer.sliders.images.accueil');
Route::get('/parametrage-de-base/activer-sliders-images-accueil/{sliders_id}', [AdministrateurController::class, 'ActiverSliderImagesAccueil'])->name('admin.activer.sliders.images.accueil');
Route::get('/parametrage-de-base/desactiver-sliders-images-accueil/{sliders_id}', [AdministrateurController::class, 'DesactiverSliderImagesAccueil'])->name('admin.desactiver.sliders.images.accueil');
//Route::get('/', [AdministrateurController::class, ''])->name('');

/*
|--------------------------------------------------------------------------
| Routes Entreprise
|--------------------------------------------------------------------------
*/
Route::get('/gerer-les-offres/liste-des-offres.html', [EntrepriseController::class, 'GestionOffre'])->name('gestionoffre');
Route::get('/gerer-les-offres/liste-des-offres-expirees.html', [EntrepriseController::class, 'GestionOffreExpiree'])->name('gestionoffreexpiree');
Route::get('/gerer-les-offres/publier-une-offre.html', [EntrepriseController::class, 'PublierOffre'])->name('entreprise.publieroffre');
Route::post('save-publier-offre', [EntrepriseController::class, 'SavePublierOffre'])->name('SavePublierOffre');
Route::get('gerer-les-offres/liste-des-offres/modifier/{offre_id}.html', [EntrepriseController::class, 'ModifierOffre'])->name('modifieroffre');
Route::post('/save-modifier-offre/{offre_id}', [EntrepriseController::class, 'SaveModifierOffre'])->name('SaveModifierOffre');
Route::get('/gestion-des-offres/supprimer-offre-a-valider/{offre_id}.html', [EntrepriseController::class, 'SupprimerOffre'])->name('entreprise.supprimeroffre');
Route::get('/gerer-les-offres/liste-des-offres/details/{offre_id}.html', [EntrepriseController::class, 'DetailsdesOffre'])->name('entreprise.detailsoffre');
Route::get('/gerer-les-offres/liste-des-offres-expirees/details/{offre_id}.html', [EntrepriseController::class, 'DetailsdesOffreExpiree'])->name('entreprise.detailsoffreexpiree');
Route::post('/gerer-les-offres/relancer/{offre_id}', [EntrepriseController::class, 'RelancerOffreNouveau'])->name('relanceroffrenouveau');
Route::get('/les-candidatures/candidatures-a-valider.html', [EntrepriseController::class, 'ListeCandidatureaValider'])->name('entreprise.candidature.avalider');
Route::get('/les-candidatures/liste-des-candidatures.html', [EntrepriseController::class, 'ListeCandidature'])->name('entreprise.listecandidature');
Route::get('/les-candidatures/liste-des-candidatures-approuvees.html', [EntrepriseController::class, 'ListeCandidatureApprouvee'])->name('entreprise.listecandidatureapprouvee');
Route::get('/valider-candidature/{candidature_id}.html', [EntrepriseController::class, 'ValiderCandidature'])->name('entreprise.valider.candidature');
Route::post('/save-valider-candidature/{candidature_id}', [EntrepriseController::class, 'SaveValiderCandidature'])->name('save.validercandidature');
Route::get('/les-candidatures/liste-des-candidatures/details-du-candidat/{candidature_id}.html', [EntrepriseController::class, 'DetailsCandidat'])->name('details.candidature');
Route::get('/les-candidatures/liste-des-candidatures-approuvees/details-du-candidat/{candidature_id}.html', [EntrepriseController::class, 'DetailsCandidatApprouve'])->name('details.candidatureapprouvee');
Route::get('/mon-compte-employeur.html',[EntrepriseController::class,'CompteEntreprise'])->name('entreprise.compte');
Route::post('/edit-compte-employeur',[EntrepriseController::class,'EditComptEntreprise'])->name('entreprise.save.edit');
Route::post('/edit-password-compte-employeur',[EntrepriseController::class,'EditPasswordComptEntreprise'])->name('entreprise.save.modifer.motpasse');
Route::get('/cv-theque/rechercher-un-profil', [EntrepriseController::class, 'RechercherunProfil'])->name('entreprise.rechercher.profil');
Route::get('/cv-theque/resultat-rechercher-un-profil', [EntrepriseController::class, 'ResultatRechercherProfile'])->name('entreprise.profil.resultat');
Route::post('/cv-theque/demander-ce-profil', [EntrepriseController::class, 'DemanderProfil'])->name('entreprise.demander.profil');
Route::get('/cv-theque/listes-des-profils-recommandes', [EntrepriseController::class, 'ProfilRecommandes'])->name('entreprise.profil.recommande');
//Route::get('/', [EntrepriseController::class, ''])->name('');


/*
|--------------------------------------------------------------------------
| Routes Demandeur d'emploi
|--------------------------------------------------------------------------
*/
Route::get('/mon-cv.html',[DemandeurEmploiController::class,'MonCV'])->name('demandeur.moncv');
Route::get('/creer-un-nouveau-cv.html',[DemandeurEmploiController::class,'CreerNouveauCV'])->name('demandeur.nouveau.cv');
Route::post('/save-cv-en-ligne/{id}',[DemandeurEmploiController::class,'SaveNouveauCV'])->name('demandeur.save.nouveau.cv');
Route::get('/mes-candidatures/liste-des-candidatures-en-attente.html',[DemandeurEmploiController::class, 'MesCandidatureAttente'])->name('demandeur.candidature.attente');
Route::get('/mes-candidatures/liste-des-candidatures-validees.html',[DemandeurEmploiController::class, 'MesCandidatureValide'])->name('demandeur.candidature.valide');
Route::get('/mes-candidatures/liste-des-candidatures-approuvees.html',[DemandeurEmploiController::class, 'MesCandidatureApprouve'])->name('demandeur.candidature.approuve');
Route::get('/mon-compte-demandeur-emploi.html', [DemandeurEmploiController::class, 'MonCompteCandidate'])->name('demandeur.compte');
Route::post('/save-modifier-compte-demandeur-emploi/{id}', [DemandeurEmploiController::class, 'SaveModifierCompteCandidate'])->name('demandeur.save.modifer.compte');
Route::post('save-modifier-mot-passe',[DemandeurEmploiController::class,'SaveModifierMotePasse'])->name('demandeur.save.modifer.motpasse');
Route::get('/demandeur-emploi/reinitialiser-carte-anpe/{id}', [DemandeurEmploiController::class, 'DemandeReinitialisationCarte'])->name('demandeur.reinitialiser.carte');
Route::get('/details/{id}', [DemandeurEmploiController::class, 'DetailsDemandeur'])->name('details.demandeur');
Route::post('/demandeur-emploi/save-formations', [DemandeurEmploiController::class, 'SaveFormation'])->name('demandeur.saveformation');
Route::post('/demandeur-emploi/save-modifier-formation/{formation_id}', [DemandeurEmploiController::class, 'SaveModifierFormation'])->name('demandeur.savemodifierformation');
Route::get('/demandeur-emploi/supprimer-formation/{formation_id}', [DemandeurEmploiController::class, 'SupprimerFormation'])->name('demandeur.supprimerformation');
Route::post('/demandeur-emploi/save-experience-professionnelle', [DemandeurEmploiController::class, 'SaveExperienceProfessionnelle'])->name('demandeur.saveexperiencepro');
Route::post('/demandeur-emploi/save-experience-professionnelle/{experiencepro_id}', [DemandeurEmploiController::class, 'SaveModifierExperienceProfessionnelle'])->name('demandeur.savemodifierexperiencepro');
Route::get('/demandeur-emploi/supprimer-experience-professionnelle/{experiencepro_id}', [DemandeurEmploiController::class, 'SupprimerExperienceProfessionnelle'])->name('demandeur.supprimerexperiencepro');
Route::post('/demandeur-emploi/save-specialite', [DemandeurEmploiController::class, 'SaveSpecialite'])->name('demandeur.savespecialite');
Route::post('/demandeur-emploi/save-specialite/{specialite_id}', [DemandeurEmploiController::class, 'SaveModifierSpecialite'])->name('demandeur.savemodifierspecialite');
Route::get('/demandeur-emploi/supprimer-specialite/{specialite_id}', [DemandeurEmploiController::class, 'SupprimerSpecialite'])->name('demandeur.supprimerspecialite');
Route::post('/demandeur-emploi/save-centreinteret', [DemandeurEmploiController::class, 'SaveCentreInteret'])->name('demandeur.savecentreinteret');
Route::post('/demandeur-emploi/save-centreinteret/{centreint_langue_id}', [DemandeurEmploiController::class, 'SaveModifierCentreInteret'])->name('demandeur.savemodifiercentreinteret');
Route::get('/demandeur-emploi/supprimer-centreinteret/{centreint_langue_id}', [DemandeurEmploiController::class, 'SupprimerCentreInteret'])->name('demandeur.supprimercentreinteret');
Route::post('/demandeur-emploi/generer-cv', [DemandeurEmploiController::class, 'GenererCV'])->name('demandeur.generercv');
Route::get('/demandeur-d-emploi/details/{id}/{identifiant}', [DemandeurEmploiController::class, 'QrCodeLien'])->name('demandeur.qrcodelien');
Route::get('/ma-carte.html', [DemandeurEmploiController::class, 'MaCarte'])->name('demandeur.carte');
//Route::get('/', [DemandeurEmploiController::class, ''])->name('');
 
//Route mot de passe oublié et réinitialisation
Route::get('/mot-passe-oublie.html', [ForgotPasswordController::class, 'showLinkRequestForm'])->name('password.request');
Route::post('/password/email', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::get('/mot-passe-oublie/reinitialiser/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('/reset-password', [ResetPasswordController::class, 'reset'])->name('save.password.update');

