<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Models\User;

use App\Http\Controllers\MobileController;


/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/
/*
Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
*/

Route::middleware('auth:api')->get('/users', function (Request $request) {
    return App\Models\User::all();
});

Route::middleware('auth:api')->get(
    'test-123-xyz', function(){
        return auth()->user();
    }
);

Route::get('register-form-data', [MobileController::class, 'registerFormData']);

Route::get('diplomes_liste', [MobileController::class, 'diplomes_liste']);
Route::get('situations', [MobileController::class, 'getSituations']);

Route::get('metiers',  [MobileController::class,'metiers']);
Route::get('pays',  [MobileController::class,'pays']);
Route::get('regions',  [MobileController::class,'regions']);
Route::get('categories-professionelle',  [MobileController::class,'categoriePro']);
Route::get('niveaux-instruction',  [MobileController::class,'niveaux']);
Route::get('langues-internationnales',  [MobileController::class,'langeInter']);
Route::get('langues-locale',  [MobileController::class,'langueLocal']);


Route::post('register', [MobileController::class,'register']);
Route::post('login', [MobileController::class,'login']);
Route::get('unauthorize', [MobileController::class,'unauthorize'])->name('401');
    
Route::group(['middleware' => 'auth:api'], function () {
    
    Route::get('logout', [MobileController::class,'logout']);
    Route::get('user', [MobileController::class,'user']);

    Route::post('documents/cv/update', [MobileController::class,'updateCV']);

    Route::post('update_profile', [MobileController::class,'update_profile']);
    
    Route::post('alert_emploi', [MobileController::class,'alert_emploi']);
    
    Route::get('offres_all', [MobileController::class,'offres_all']);
    Route::get('offres/{user}/{type?}', [MobileController::class,'offres']);
    
    Route::post('postuler', [MobileController::class,'postuler']);

    Route::get('candidats', [MobileController::class,'candidats']);
    Route::get('candidats/recherche', [MobileController::class,'recherchecandidat']);


});
