

<?php $__env->startSection('title'); ?>
    Liste des articles
<?php $__env->stopSection(); ?>

<?php $__env->startSection('titre'); ?>
    Liste des articles
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?> 
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Gestion articles</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Liste des articles</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Liste des articles publiés</h4>
                    </div>
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.liste.article')); ?>" class="mb-10">
                            <div class="row">
                                <div class="col-md-5">
                                    <label>Catégorie Article</label>
                                    <select id="single-select" name="c">
                                        <option value="">Choissisez une catégorie</option>
                                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $categorie): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option <?php if($categorie_selected == $categorie->categorie_id): ?> selected <?php endif; ?> value="<?php echo e($categorie->categorie_id); ?>"><?php echo e($categorie->categorielib); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-md-5">
                                    <label>Date de clôture</label>
                                    <input type="date" value="<?php echo e($date_selected); ?>" name="d" class="form-control">
                                </div>
                                <div class="col-md-2">
                                    <label class="mt-3"></label>
                                    <button class="btn btn-info btn-block">Rechercher</button>
                                </div>
                            </div>
                        </form><hr>
                        <div class="table-responsive">
                            <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_ART")): ?>
                            <table id="example3" class="display min-w850">
                                <thead>
                                    <tr>
                                        <th class="d-none"></th>
                                        <th>Titre de l'actualite</th>
                                        <th>Cartégorie</th>
                                        <th>Publier par</th>
                                        <th>Enregistrer par</th>
                                        <th>Date de clôture</th>
                                        <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART")): ?>
                                        <th>Statut</th>
                                        <?php endif; ?>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $articles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $article): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td class="d-none"></td>
                                            <td>
                                                <?php
                                                    $titre = $article->actualite_titre;
                                                    $titre_affiche = substr($titre, 0, 56);
                                                    if($titre_affiche < $article->actualite_titre){
                                                        echo($titre_affiche).'...';
                                                    }
                                                    else{                                            
                                                        echo($article->actualite_titre);
                                                    }
                                                ?>
                                            </td>
                                            <td><span class="badge badge-success light"><?php echo e($article->categorielib); ?></span></td>
                                            <td><?php echo e($article->actualite_publiepar); ?></td>
                                            <td><?php echo e($article->name); ?> <?php echo e($article->prenoms); ?></td>
                                            <td><?php echo e(\Carbon\Carbon::parse($article->actualite_datefin)->format('d/m/Y')); ?></td>
                                            <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART")): ?>
                                            <td>
                                                <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                                                    <?php if($article->actualite_statut == "PUBLIE"): ?>
                                                        <a href="<?php echo e(route('admin.desactiver.article',$article->actualite_id)); ?>"><img src="<?php echo e(asset('assets/img/icons/active.png')); ?>" width="50"></a>  
                                                    <?php else: ?>
                                                        <a href="<?php echo e(route('admin.activer.article',$article->actualite_id)); ?>"><img src="<?php echo e(asset('assets/img/icons/desactive.png')); ?>" width="50"></a>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_ART")): ?>
                                                    <?php if($article->actualite_statut == "PUBLIE"): ?>
                                                        <a href="<?php echo e(route('admin.desactiver.article',$article->actualite_id)); ?>"><img src="<?php echo e(asset('assets/img/icons/active.png')); ?>" width="50"></a> 
                                                    <?php else: ?>
                                                        <span class="badge badge-warning">Non actif</span>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                                <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_ART")): ?>
                                                    <?php if($article->actualite_statut == "BROUILLON"): ?>
                                                        <a href="<?php echo e(route('admin.activer.article',$article->actualite_id)); ?>"><img src="<?php echo e(asset('assets/img/icons/desactive.png')); ?>" width="50"></a>
                                                    <?php else: ?>
                                                        <span class="badge badge-success">Actif</span>
                                                    <?php endif; ?>
                                                <?php endif; ?>
                                            </td>
                                            <?php endif; ?> 
                                            <td class="text-center">
                                                <a href="<?php echo e(route('admin.details.article',[$article->actualite_id, Stdfn::clean_url(html_entity_decode($article->actualite_titre))])); ?>" style="cursor: pointer;" title="DETAILS DE L'ARTICLE"><img src="<?php echo e(asset('assets/img/icons/details.png')); ?>" class="img-fluid" width="23"></a>
                                                <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")): ?>
                                                    <a href="<?php echo e(route('admin.modifier.article',[$article->actualite_id, Stdfn::clean_url(html_entity_decode($article->actualite_titre))])); ?>" title="MODIFIER L'ARTICLE" style="cursor:pointer"><img src="<?php echo e(asset('assets/img/icons/modifier.png')); ?>" class="img-fluid" width="25" alt=""></a>
                                                <?php endif; ?>
                                                <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "DEL_ART")): ?>
                                                    <span data-toggle="modal" data-target="#supprimeractualite<?php echo e($article->actualite_id); ?>" title="SUPPRIMER L'ARTICLE" data-id="<?php echo e($article->actualite_id); ?>" data-name="<?php echo e($article->actualite_titre); ?>"><img src="<?php echo e(asset('assets/img/icons/delete.png')); ?>" class="img-fluid" width="25" alt=""></span>
                                                <?php endif; ?>
                                            </td>                                               
                                        </tr>
                                        <div class="modal fade" id="supprimeractualite<?php echo e($article->actualite_id); ?>" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="staticBackdropLabel" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="staticBackdropLabel">CONFIRMATION DE SUPPRESSION</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        Vous êtes sur le point de supprimer l'article : <?php echo e($article->actualite_titre); ?>

                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" style="float: left !important;" class="btn btn-danger" data-dismiss="modal">Annuler</button>
                                                        <a href="<?php echo e(route('admin.supprimer.article',$article->actualite_id)); ?>" style="float: right !important;" class="btn btn-success">Confirmer</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.appp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anpe-app/resources/views/admin/article/liste.blade.php ENDPATH**/ ?>