<?php
    use Carbon\Carbon;
?>

<?php $__env->startSection('title'); ?>
    <?php echo e($actualite->actualite_titre); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<style type="text/css">
	.btn-success{
		border-radius: 5px;
	}
</style>
<div class="py-5" style="background:#03343b url(<?php echo e(asset('assets/img/landing-bg.png')); ?>) no-repeat;" data-overlay="0">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-11 col-lg-12 col-md-12 col-sm-12 col-12">
                <div class="banner_caption text-center mb-2">
                    <h1 class="ft-bold mb-4"><?php echo e($actualite->actualite_titre); ?></h1>
                    <nav class="transparent">
						<ol class="breadcrumb p-0">
							<li class="breadcrumb-item"><a href="<?php echo e(route('actualite')); ?>" style="color:#FFF !important">Retour</a></li>
							<li class="breadcrumb-item active theme-cl" aria-current="page">Détails</li>
						</ol>
					</nav>
                </div>               
            </div>
        </div>
    </div>
</div>
<?php if(!empty($actualite)): ?> 
<section>			
	<div class="container">
		<div class="row">
			<div class="col-lg-8 col-md-12 col-sm-12 col-12">
				<div class="article_detail_wrapss single_article_wrap format-standard">
					<div class="article_body_wrap">								
						<div class="article_featured_image">
							<img class="img-fluid" src="<?php echo e(asset('assets/img/actualite/'.$actualite->actualite_image)); ?>" alt="">
						</div>									
						<div class="article_top_info">
							<ul class="article_middle_info">
								<li><a href="#"><span class="icons"><i class="ti-user"></i></span><?php echo e($actualite->actualite_publiepar); ?></a></li>
								<li><a href="#"><span class="icons"><i class="ti-comment-alt"></i></span><?php echo e($commentaires->count()); ?> Commentaires</a></li>
							</ul>
						</div>
						<h2 class="post-title"><?php echo e($actualite->actualite_titre); ?></h2>
						<p><?php echo html_entity_decode($actualite->actualite_descrip) ?></p>
						<p><?php echo html_entity_decode($actualite->actualite_autre) ?></p>
						<hr>
						<?php if($actualite->actualite_temoign != null): ?>
							<h2 class="post-title">Témoignage</h2>
							<p>
								<?php echo html_entity_decode($actualite->actualite_temoign) ?>
							</p>
						<?php endif; ?>
					</div>
				</div>
				<div class="article_detail_wrapss single_article_wrap format-standard">								
					<div class="comment-area">
						<div class="all-comments">
							<h3 class="comments-title"><?php echo e($nombre_commentaire); ?> Commentaires</h3>
							<div class="comment-list">
								<ul>
									<?php $__currentLoopData = $commentaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commentaire): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
	    								
	    								<?php if($commentaire->name): ?>
	    									<li class="article_comments_wrap">
												<article>
													<div class="comment-details">
														<div class="comment-meta">
															<div class="comment-left-meta">
																<h4 class="author-name">
																	<img src="<?php echo e(asset('assets/img/profil/'.$commentaire->profil_photo)); ?>" class="img-fluid" style="width: 10%;">
																	<?php echo e($commentaire->name); ?> <?php echo e($commentaire->prenoms); ?> <span class="selected"></span><span style="float:right; font-size: 14px;">
																	<?php
		                                
						                                                $date_publication = $commentaire->commentaire_datecrea;

						                                                $date = Carbon::parse($date_publication)->locale('fr_FR')->translatedFormat('d F Y');

						                                                echo $date;
						                                            ?>
																</span></h4>
															</div>
														</div>
														<div class="comment-text">
															<p><?php echo html_entity_decode($commentaire->commentairelib) ?></p>
														</div><hr>
													</div>
												</article>
											</li>
	    								<?php else: ?>
											<li class="article_comments_wrap">
												<article>
													<div class="comment-details">
														<div class="comment-meta">
															<div class="comment-left-meta">
																<h4 class="author-name">
																	<img src="<?php echo e(asset('assets/img/icon.png')); ?>" class="img-fluid" style="width: 10%;">
																	<?php echo e($commentaire->commentairename); ?> <span class="selected"></span><span style="float:right; font-size: 14px;">
																	<?php
		                                
						                                                $date_publication = $commentaire->commentaire_datecrea;

						                                                $date = Carbon::parse($date_publication)->locale('fr_FR')->translatedFormat('d F Y');

						                                                echo $date;
						                                            ?>
																</span></h4>
															</div>
														</div>
														<div class="comment-text">
															<p><?php echo html_entity_decode($commentaire->commentairelib) ?></p>
														</div><hr>
													</div>
												</article>
											</li>
										<?php endif; ?>

									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</ul>
							</div>
						</div>
						<div class="comment-box submit-form">
							
						</div>
					</div>
				</div>	
			</div>
			<div class="col-lg-4 col-md-12 col-sm-12 col-12">
				<div class="single_widgets widget_thumb_post">
					<h3 class="reply-title">Poster un Commentaire</h3><hr>
					<div class="comment-form">
						<form method="POST" action="<?php echo e(route('SaveCommentaire',$actualite->actualite_id)); ?>">
							<?php echo csrf_field(); ?>
							<input type="hidden" name="actualite_id" value="<?php echo e($actualite->actualite_id); ?>">
							<div class="row">
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="form-group"> 
										<input type="text" class="form-control" name="nom" placeholder="Votre Nom" >
									</div>
								</div>
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="form-group">
										<input type="email" class="form-control" name="email" placeholder="Votre Email" >
									</div>
								</div>
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="form-group">
										<textarea name="commentaire" class="form-control" cols="30" rows="6" placeholder="Votre commentaire...." ></textarea>
									</div>
								</div>
								<div class="col-lg-12 col-md-12 col-sm-12">
									<div class="form-group">
										<button type="submit" class="btn theme-bg text-white">Envoyer</button>
									</div>
								</div>
							</div>
						</form>
					</div>
				</div>	
				<div class="row">
					<?php if($actualite_similaires->count() > 0): ?>		
						<?php $__currentLoopData = $actualite_similaires; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $actualite_simi): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>				
							<div class="col-xl-12 col-lg-12 col-md-12 col-sm-12">
								<div class="_blog_wrap">
									<div class="_blog_thumb mb-2">
										<a href="<?php echo e(route('detailsactualite',[$actualite_simi->actualite_id, Stdfn::clean_url($actualite_simi->actualite_titre)])); ?>" class="d-block"><img src="<?php echo e(asset('assets/img/actualite/'.$actualite_simi->actualite_image)); ?>" class="img-fluid rounded" alt="" /></a>
									</div>
									<div class="_blog_caption">
										<span class="text-muted">
											<?php		                                
                                                $date_publication = $actualite_simi->actualite_datecrea;

                                                $date = Carbon::parse($date_publication)->locale('fr_FR')->translatedFormat('d F Y');

                                                echo $date;
                                            ?>
										</span>
										<h5 class="bl_title lh-1">
											<a href="<?php echo e(route('detailsactualite',[$actualite_simi->actualite_id, Stdfn::clean_url($actualite_simi->actualite_titre)])); ?>">
												<?php
			                                        $titre = $actualite_simi->actualite_titre;
			                                        $titre_affiche = substr($titre, 0, 70);
			                                        if($titre_affiche < $actualite_simi->actualite_titre){
			                                            
			                                            echo html_entity_decode($titre_affiche).'...';
			                                        }
			                                        else{      
			                                            echo html_entity_decode($actualite_simi->actualite_titre);
			                                        }
			                                    ?>
											</a>
										</h5>
										<a href="<?php echo e(route('detailsactualite',[$actualite_simi->actualite_id, Stdfn::clean_url($actualite_simi->actualite_titre)])); ?>" class="fs-sm btn btn-success btn-block">En savoir plus..</a>
									</div>
								</div>
							</div>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
				</div>						
			</div>						
		</div>
	</div>						
</section>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anpe-app/resources/views/actualite/details.blade.php ENDPATH**/ ?>