<?php
   use App\Models\User;

   $carte_expiree = User::where(['profil_id'=>3])->whereRaw('date(user_validitecarte) <"'.gmdate("Y-m-d").'" ')->count();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="utf-8">
   <meta http-equiv="X-UA-Compatible" content="IE=edge">
   <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=0">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <meta name="description" content="Offre d'emploi au NIGER">
   <meta name="keywords" content="HTML, CSS, JavaScript, Python, Cyber Securite, Comptabilité, Banque, Medecine, Expertise, It-Consulting, Support IT, Formation">
   <meta name="author" content="JOB-BOARDER">
   <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>" />
   <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(config('app.name')); ?></title>
   <!-- Favicon icon -->
   <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('assets/img/logo-anpe.png')); ?>">
   <link href="<?php echo e(asset('vendor/bootstrap-select/dist/css/bootstrap-select.min.css')); ?>" rel="stylesheet">
   <link href="<?php echo e(asset('vendor/jqvmap/css/jqvmap.min.css')); ?>" rel="stylesheet">
    
   <link rel="stylesheet" href="<?php echo e(asset('vendor/chartist/css/chartist.min.css')); ?>">
   <link href="<?php echo e(asset('vendor/owl-carousel/owl.carousel.css')); ?>" rel="stylesheet">
   <link href="<?php echo e(asset('vendor/datatables/css/jquery.dataTables.min.css')); ?>" rel="stylesheet">
   <link rel="stylesheet" href="<?php echo e(asset('vendor/select2/css/select2.min.css')); ?>">
   <link href="<?php echo e(asset('css/style.css')); ?>" rel="stylesheet">
   <link href="<?php echo e(asset('vendor/jquery-smartwizard/dist/css/smart_wizard.min.css')); ?>" rel="stylesheet">
   <link href="<?php echo e(asset('assets/css/toastr.css')); ?>" rel="stylesheet" type="text/css">
   <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@100;300;400;500;700;900&display=swap" rel="stylesheet"> 
   <link href="<?php echo e(asset('css/font-awesome.min.css')); ?>" rel="stylesheet" >
   <link href="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.css" rel="stylesheet">
   <script src="<?php echo e(asset('js/apexcharts.min.js')); ?>"></script>
   <script src="<?php echo e(asset('js/jquery-3.6.0.min.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/datatables.js')); ?>"></script>
   <script src="<?php echo e(asset('js/chart.js')); ?>"></script>
   <style type="text/css">
      .nav-text{
         font-size: 14px !important; 
      }

      .has-arrow{
         margin-left: 2px;
      }

      .form-control {
         color: #000 !important;
         border: 1px solid #000;
      }

      label{
         color: #000 !important;
      }

      .container-fluid{
         padding-left: none !important;
      }
   </style>
</head>

<body>
    <div id="main-wrapper"> 
        <div class="nav-header">
            <a href="<?php echo e(route('welcome')); ?>" class="brand-logo">
                <img class="logo-abbr" src="<?php echo e(asset('assets/img/logo-anpe.png')); ?>" alt="">
                <h3 class="brand-title" style="margin-left: 12px;">ANPE</h3>
            </a>

            <div class="nav-control">
                <div class="hamburger">
                    <span class="line"></span><span class="line"></span><span class="line"></span>
                </div>
            </div>
        </div>
        <div class="header">
            <div class="header-content">
                <nav class="navbar navbar-expand">
                    <div class="collapse navbar-collapse justify-content-between">
                        <div class="header-left">
                            <div class="dashboard_bar">
                        <?php echo $__env->yieldContent('titre'); ?>
                            </div>
                        </div>
                        <ul class="navbar-nav header-right">
                            <li class="nav-item dropdown header-profile">
                                <a class="nav-link" href="javascript:void(0)" role="button" data-toggle="dropdown">
                           <div class="header-info">
                              <span class="text-black"><strong>
                                 <?php if(Auth::user()->profil_id ==2): ?>
                                    <?php echo html_entity_decode(Auth::user()->raisonsociale) ?>
                                 <?php else: ?>
                                    <?php echo e(Auth::user()->name); ?> <?php echo e(Auth::user()->prenoms); ?>

                                 <?php endif; ?>
                              </strong></span>
                           </div>
                                    <?php if(Auth::user()->role_id ==1): ?>
                                       <?php if(!empty(Auth::user()->profil_photo)): ?>
                                          <img src="<?php echo e(asset('assets/img/profil/'.Auth::user()->profil_photo)); ?>" width="20" alt="">
                                       <?php else: ?>
                                          <img src="<?php echo e(asset('assets/img/profil/avatar.png')); ?>" width="20" alt="">
                                       <?php endif; ?>
                                    <?php endif; ?>
                           <?php if(Auth::user()->profil_id ==2): ?>
                              <?php if(!empty(Auth::user()->entreprise_logo)): ?>
                                          <img src="<?php echo e(asset('assets/img/entreprise/'.Auth::user()->entreprise_logo)); ?>" width="20" alt=""/>
                                       <?php else: ?>
                                          <img src="<?php echo e(asset('assets/img/profil/avatar.png')); ?>" width="20" alt=""/>
                                       <?php endif; ?>
                                    <?php endif; ?>
                                    <?php if(Auth::user()->profil_id ==3): ?>
                                       <?php if(!empty(Auth::user()->profil_photo)): ?>
                                          <img src="<?php echo e(asset('assets/img/profil/'.Auth::user()->profil_photo)); ?>" width="20" alt="">
                                       <?php else: ?>
                                          <img src="<?php echo e(asset('assets/img/profil/avatar.png')); ?>" width="20" alt="">
                                       <?php endif; ?>
                                    <?php endif; ?>
                                </a>
                                <div class="dropdown-menu dropdown-menu-right">
                                    <!-- SOUS-MENU ADMIN -->
                                    <?php if(Auth::user()->role_id ==1 and Auth::user()->user_statut =="VALIDE"): ?>
                                    <a href="<?php echo e(route('admin.compte')); ?>" class="dropdown-item ai-icon" style="font-weight:bold;">
                                           <i class="fa fa-user-circle"></i>
                                           <span class="ml-2">Mon compte</span>
                                       </a>
                                    <?php endif; ?>
                                    <!-- SOUS-MENU ENTREPRISE -->
                                    <?php if(Auth::user()->profil_id ==2): ?>
                                       <a href="<?php echo e(route('entreprise.compte')); ?>" class="dropdown-item ai-icon" style="font-weight:bold;">
                                           <svg id="fa fa-user-circle" xmlns="http://www.w3.org/2000/svg" class="text-primary" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                           <span class="ml-2">Mon compte </span>
                                       </a>
                                    <?php endif; ?>
                                    <?php if(Auth::user()->profil_id ==3): ?>
                                       <a href="<?php echo e(route('demandeur.compte')); ?>" class="dropdown-item ai-icon" style="font-weight:bold;">
                                           <svg id="fa fa-user-circle" xmlns="http://www.w3.org/2000/svg" class="text-primary" width="18" height="18" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M20 21v-2a4 4 0 0 0-4-4H8a4 4 0 0 0-4 4v2"></path><circle cx="12" cy="7" r="4"></circle></svg>
                                           <span class="ml-2">Mon compte </span>
                                       </a>
                                    <?php endif; ?>
                                    <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="dropdown-item ai-icon" style="font-weight:bold;">
                                        <i class="fa fa-unlock-alt" style="color:red"></i>
                                        <span class="ml-2">Se déconnecter </span>
                                        <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                           <?php echo csrf_field(); ?>
                                       </form>
                                    </a>
                                </div>
                            </li>
                        </ul>
                    </div>
                </nav>
            </div>
        </div>
        <div class="deznav">
            <div class="deznav-scroll">
            <ul class="metismenu" id="menu">
              <li>
                  <a href="<?php echo e(route('home')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                     <i class="fa fa-home"></i>
                     <span class="nav-text" style="margin-left:-15px">Tableau de bord</span>
                  </a>
               </li>
               <?php if(Auth::user()->role_id == 1): ?>
                  <!-- Menu Administeur Gestionnaire de tout -->
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li><a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                           <i class="fa fa-user-md"></i>
                           <span class="nav-text" style="margin-left:-15px">Gestion des employeurs</span>
                        </a>
                              <ul aria-expanded="false">
                                  <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.creer.entreprise')); ?>">Créer un compte employeur</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.valider.entreprise')); ?>">Liste des employeurs à valider</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.entreprise')); ?>">Liste des employeurs</a></li>
                              </ul>
                          </li>
                  <?php endif; ?>                  
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                        <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                           <i class="fa fa-graduation-cap"></i>
                           <span class="nav-text" style="margin-left:-15px">Gestion des demandeurs</span>
                        </a>
                        <ul aria-expanded="false">
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demandeur.creercompte')); ?>">Créer un compte demadeur d'emploi</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demandeur.sanscarte')); ?>">Liste des demandeur à valider</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.demandeur')); ?>">Liste des demandeurs</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.profil.candidature')); ?>">Extraction des profils de candidatures</a></li>
                           <?php if($carte_expiree > 0): ?>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demandeur.carte.expiree')); ?>">Liste des demandeurs carte expirée</a></li>
                           <?php endif; ?>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.candidature.avalider')); ?>">Liste des candidatures à valider</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demande.candidatureanpe')); ?>">Liste des candidatures de l'ANPE</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.candidature')); ?>">Liste des candidatures</a></li>
                        </ul>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                          <li><a href="javascript:void()" class="has-arrow ai-icon" style="font-weight:bold;" aria-expanded="false">
                           <i class="flaticon-381-notepad"></i>
                           <span class="nav-text" style="margin-left:-15px">Gestion des offres</span>
                        </a>
                        <ul aria-expanded="false">
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.publier.offreemploi')); ?>">Publier une offre</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.publier.employeuroffreemploi')); ?>">Publier une offre pour employeur</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.valider.offre')); ?>">Offres à valider</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.offre')); ?>">Liste des offres</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.offre.expiree')); ?>">Offres expirées</a></li>
                        </ul>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                        <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                           <i class="flaticon-381-television"></i>
                           <span class="nav-text" style="margin-left:-15px">Gestion des articles</span>
                        </a>                    
                        <ul aria-expanded="false">
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.publier.article')); ?>">Publier un article</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.article')); ?>">Liste des articles</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.article.expire')); ?>">Liste des articles expirés</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.commentaire.avalider')); ?>">Commentaires à valider</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.commentaire')); ?>">Liste des commentaires</a></li>
                        </ul>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                        <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                           <i class="fa fa-users"></i>
                           <span class="nav-text" style="margin-left:-15px">Gestion des agents</span>
                        </a>
                        <ul aria-expanded="false">
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.compte.utilisateur')); ?>">Créer un compte agent</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.utilisateur')); ?>">Liste des agents</a></li>
                        </ul>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                           <a href="<?php echo e(route('admin.liste.cvtheque')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                           <i class="fa fa-book"></i>
                           <span class="nav-text" style="margin-left:-15px">Gestion de la cvthèque</span>
                        </a>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                           <a href="<?php echo e(route('admin.liste.publication')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                           <i class="fa fa-file-pdf-o"></i>
                           <span class="nav-text" style="margin-left:-15px">Publication des fichiers</span>
                        </a>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                        <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                           <i class="flaticon-381-controls-3"></i>
                           <span class="nav-text" style="margin-left:-15px">Statistiques</span>
                        </a>
                        <ul aria-expanded="false">
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statistiques.journalieres')); ?>">Statistiques journalières</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statistiques.mensuelles')); ?>">Statistiques mensuelles</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statistiques.annuelles')); ?>">Statistiques annuelles</a></li>
                        </ul>
                     </li>
                  <?php endif; ?>
                  <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT")): ?>
                     <li>
                        <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                           <i class="fa fa-gears"></i>
                           <span class="nav-text" style="margin-left:-15px">Paramétrage de base</span>
                        </a>
                        <ul aria-expanded="false">
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.sliders.images.accueil')); ?>">Sliders Images Accueil</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.typecontrat')); ?>">Type de contrat</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.nationaliteentreprise')); ?>">Nationalité entreprise</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.region')); ?>">Région</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.pays')); ?>">Nationalité</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.languelocale')); ?>">Langue locale</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.langueinter')); ?>">Langue internationale</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statutentreprise')); ?>">Statut Entreprise</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.situationentreprise')); ?>">Situation Entreprise</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.secteuractivite')); ?>">Secteurs d'activité</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.diplome')); ?>">Diplôme</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.filiere')); ?>">Filière</a></li>
                           <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.categorie.article')); ?>">Catégorie article</a></li>
                        </ul>
                     </li>                
                  <?php endif; ?>

                  <!-- Menu Utilisateur agent -->
                  <?php if(Auth::user()->user_statut == "VALIDE"): ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_EMP")): ?>
                        <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="fa fa-user-md"></i>
                              <span class="nav-text" style="margin-left:-15px">Gestion des employeurs</span>
                           </a>                    
                           <ul aria-expanded="false">
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_EMP")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.creer.entreprise')); ?>">Créer un compte employeur</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_EMP")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.valider.entreprise')); ?>">Liste des employeurs à valider</a></li>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.entreprise')); ?>">Liste des employeurs</a></li>
                              <?php endif; ?>
                           </ul>                   
                        </li>                      
                     <?php endif; ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND")): ?>
                        <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="fa fa-graduation-cap"></i>
                              <span class="nav-text" style="margin-left:-15px">Gestion des demandeurs</span>
                           </a>
                           <ul aria-expanded="false">
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_DEMP")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demandeur.creercompte')); ?>">Créer un compte demadeur d'emploi</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demandeur.sanscarte')); ?>">Liste des demandeur à valider</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "EXTRAC_PROFIL")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.profil.candidature')); ?>">Extraction des profils de candidatures</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_DEMP") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_DEMP")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.demandeur')); ?>">Liste des demandeurs</a></li>
                                 <?php if($carte_expiree > 0): ?>
                                    <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demandeur.carte.expiree')); ?>">Liste des demandeurs carte expirée</a></li>
                                 <?php endif; ?>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CAND")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.candidature.avalider')); ?>">Liste des candidatures à valider</a></li>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.demande.candidatureanpe')); ?>">Liste des candidatures de l'ANPE</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CAND")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.candidature')); ?>">Liste des candidatures</a></li>
                              <?php endif; ?>
                           </ul>
                        </li>
                     <?php endif; ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_OFF") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_OFF")): ?>
                             <li><a href="javascript:void()" class="has-arrow ai-icon" style="font-weight:bold;" aria-expanded="false">
                              <i class="flaticon-381-notepad"></i>
                              <span class="nav-text" style="margin-left:-15px">Gestion des offres</span>
                           </a>
                           <ul aria-expanded="false">
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_OFF")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.publier.offreemploi')); ?>">Publier une offre</a></li>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.publier.employeuroffreemploi')); ?>">Publier une offre pour employeur</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ACT_OFF")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.valider.offre')); ?>">Offres à valider</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_OFF")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.offre')); ?>">Liste des offres</a></li>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.offre.expiree')); ?>">Offres expirées</a></li>
                              <?php endif; ?>
                           </ul>
                        </li>
                     <?php endif; ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_ART") or Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")): ?>
                        <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="flaticon-381-television"></i>
                              <span class="nav-text" style="margin-left:-15px">Gestion des articles</span>
                           </a>                    
                           <ul aria-expanded="false">
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_ART")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.publier.article')); ?>">Publier un article</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_ART")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.article')); ?>">Liste des articles</a></li>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.article.expire')); ?>">Liste des articles expirés</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CMT")): ?>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.commentaire.avalider')); ?>">Commentaires à valider</a></li>
                                 <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.commentaire')); ?>">Liste des commentaires</a></li>
                              <?php endif; ?>
                           </ul>
                        </li>
                     <?php endif; ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT")): ?>
                        <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="fa fa-users"></i>
                              <span class="nav-text" style="margin-left:-15px">Gestion des agents</span>
                           </a>
                           <ul aria-expanded="false">
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CREATE_AGENT")): ?>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.compte.utilisateur')); ?>">Créer un compte agent</a></li>
                              <?php endif; ?>
                              <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "ACT_AGENT") or Stdfn::isActionAutorisee(Auth::user()->id, "DESAC_AGENT")): ?>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.liste.utilisateur')); ?>">Liste des agents</a></li>
                              <?php endif; ?>
                           </ul>
                        </li>
                     <?php endif; ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_CVTH") or Stdfn::isActionAutorisee(Auth::user()->id, "VAL_CVTH")): ?>
                        <li>
                              <a href="<?php echo e(route('admin.liste.cvtheque')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                              <i class="fa fa-book"></i>
                              <span class="nav-text" style="margin-left:-15px">Gestion de la cvthèque</span>
                           </a>
                        </li>
                     <?php endif; ?>
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_FICH") or Stdfn::isActionAutorisee(Auth::user()->id, "PUB_FICH")): ?>
                        <li>
                              <a href="<?php echo e(route('admin.liste.publication')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                              <i class="fa fa-file-pdf-o"></i>
                              <span class="nav-text" style="margin-left:-15px">Publication des fichiers</span>
                           </a>
                        </li>
                     <?php endif; ?>   
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "CONSUL_START")): ?>
                        <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="flaticon-381-controls-3"></i>
                              <span class="nav-text" style="margin-left:-15px">Statistiques</span>
                           </a>
                           <ul aria-expanded="false">
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statistiques.journalieres')); ?>">Statistiques journalières</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statistiques.mensuelles')); ?>">Statistiques mensuelles</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statistiques.annuelles')); ?>">Statistiques annuelles</a></li>
                           </ul>
                        </li>
                     <?php endif; ?>                  
                     <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "PARAM")): ?>
                        <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="fa fa-gears"></i>
                              <span class="nav-text" style="margin-left:-15px">Paramétrage de base</span>
                           </a>
                           <ul aria-expanded="false">
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.typecontrat')); ?>">Type de contrat</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.nationaliteentreprise')); ?>">Nationalité entreprise</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.region')); ?>">Région</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.pays')); ?>">Nationalité</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.languelocale')); ?>">Langue locale</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.langueinter')); ?>">Langue internationale</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.statutentreprise')); ?>">Statut Entreprise</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.situationentreprise')); ?>">Situation Entreprise</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.secteuractivite')); ?>">Secteurs d'activité</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.diplome')); ?>">Diplôme</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.filiere')); ?>">Filière</a></li>
                              <li class="menu_text" style="font-size:10px !important"><a href="<?php echo e(route('admin.categorie.article')); ?>">Catégorie article</a></li>
                           </ul>
                        </li>                
                     <?php endif; ?>
                  <?php endif; ?>
                  <li>
                        <a href="<?php echo e(route('admin.compte')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                        <i class="fa fa-user"></i>
                        <span class="nav-text" style="margin-left:-15px">Mon compte</span>
                     </a>
                  </li>
               <?php endif; ?> 
               <?php if(Auth::user()->profil_id ==2): ?>
                       <li><a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                        <i class="fa fa-gift" aria-hidden="true"></i>
                        <span class="nav-text" style="margin-left:-15px">Gérer les offres</span>
                     </a>
                           <ul aria-expanded="false">
                               <li style="margin-left:-30px"><a href="<?php echo e(route('entreprise.publieroffre')); ?>">Publier une offre</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('gestionoffre')); ?>">Liste des offres</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('gestionoffreexpiree')); ?>">Liste des offres expirées</a></li>
                           </ul>
                       </li>
                       <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="fa fa-graduation-cap" aria-hidden="true"></i>
                              <span class="nav-text" style="margin-left:-15px">Les Candidatures</span>
                           </a>
                           <ul aria-expanded="false">
                               <li style="margin-left:-30px"><a href="<?php echo e(route('entreprise.candidature.avalider')); ?>">Candidatures à valider</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('entreprise.listecandidature')); ?>">Liste des candidatures</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('entreprise.listecandidatureapprouvee')); ?>">Liste des candidature approuvées</a></li>
                           </ul>
                       </li>
                       <li>
                           <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                              <i class="fa fa-book" aria-hidden="true"></i>
                              <span class="nav-text" style="margin-left:-15px">Cvthèque</span>
                           </a>
                           <ul aria-expanded="false">
                               <li style="margin-left:-30px"><a href="<?php echo e(route('entreprise.rechercher.profil')); ?>">Rechercher un profil</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('entreprise.profil.recommande')); ?>">Profils recommandés</a></li>
                           </ul>
                       </li>
                       <li>
                        <a href="<?php echo e(route('entreprise.compte')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                        <i class="fa fa-user"></i>
                        <span class="nav-text" style="margin-left:-15px">Mon compte</span>
                     </a>
                  </li>
               <?php endif; ?>
               <?php if(Auth::user()->profil_id ==3): ?>
                  <li><a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                        <i class="fa fa-graduation-cap" aria-hidden="true"></i>
                        <span class="nav-text" style="margin-left:-15px">Mes Candidatures</span>
                     </a>
                           <ul aria-expanded="false">
                               <li style="margin-left:-30px"><a href="<?php echo e(route('demandeur.candidature.attente')); ?>">Liste des candidatures en attente</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('demandeur.candidature.valide')); ?>">Liste des candidatures validées</a></li>
                               <li style="margin-left:-30px"><a href="<?php echo e(route('demandeur.candidature.approuve')); ?>">Liste des candidatures approuvées</a></li>
                           </ul>
                       </li>
                  <li>
                     <a class="has-arrow ai-icon" style="font-weight:bold;" href="javascript:void()" aria-expanded="false">
                        <i class="fa fa-address-card"></i>
                        <span class="nav-text" style="margin-left:-15px">Mon CV</span>
                     </a>
                     <ul aria-expanded="false">
                        <li style="margin-left:-30px"><a href="<?php echo e(route('demandeur.nouveau.cv')); ?>">Créer mon CV</a></li>
                        <li style="margin-left:-30px"><a href="<?php echo e(route('demandeur.moncv')); ?>">Consulter mon CV</a></li>
                     </ul>
                  </li>
                  <li>
                     <a href="<?php echo e(route('demandeur.carte')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                        <i class="fa fa-address-card"></i>
                        <span class="nav-text" style="margin-left:-15px">Ma carte</span>
                     </a>
                  </li>
                  <li>
                     <a href="<?php echo e(route('demandeur.compte')); ?>" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                        <i class="fa fa-user"></i>
                        <span class="nav-text" style="margin-left:-15px">Mon compte</span>
                     </a>
                  </li>
               <?php endif; ?>  
               <li>
                  <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault(); document.getElementById('logout-form').submit();" class="ai-icon" style="font-weight:bold;" aria-expanded="false">
                     <i class="fa fa-unlock-alt"></i>
                     <span class="nav-text" style="margin-left:-15px">Se déconnecter</span>
                     <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                         <?php echo csrf_field(); ?>
                     </form>
                  </a>
               </li>                 
                </ul>
         </div>
        </div>
        <div class="content-body">
            <?php echo $__env->yieldContent('content'); ?>
        </div>
        <div class="footer">
            <div class="copyright">
                <p class="mb-0">Copyright © ANPE propulsé par <a href="">EMERZONE</a> <?php echo gmdate("Y"); ?></p>
            </div>
        </div>
    </div>
   <script src="<?php echo e(asset('vendor/global/global.min.js')); ?>"></script>
   <script src="<?php echo e(asset('vendor/bootstrap-select/dist/js/bootstrap-select.min.js')); ?>"></script>
   <script src="<?php echo e(asset('vendor/chart.js')); ?>"></script>
    <script src="<?php echo e(asset('js/custom.min.js')); ?>"></script>
   <script src="<?php echo e(asset('js/deznav-init.js')); ?>"></script>
   <script src="<?php echo e(asset('vendor/owl-carousel/owl.carousel.js')); ?>"></script>

   <script src="https://cdn.jsdelivr.net/npm/summernote@0.8.18/dist/summernote-bs4.min.js"></script>
    <script src="dist/snb-gallery-brick.min.js" type="text/javascript"></script>
   
   <!-- Chart piety plugin files -->
    <script src="<?php echo e(asset('vendor/peity/jquery.peity.min.js')); ?>"></script>
   <script src="<?php echo e(asset('vendor/apexchart/apexchart.js')); ?>"></script> 
   <script src="<?php echo e(asset('js/dashboard/dashboard-1.js')); ?>"></script>
   
   <!-- Datatable -->
    <script src="<?php echo e(asset('vendor/datatables/js/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/plugins-init/datatables.init.js')); ?>"></script>

   <!-- /Notify JS files -->
    <script src="<?php echo e(asset('assets/js/sweetalert.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/sweetalert2@11.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/toastr.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/action.js')); ?>"></script> 

    <script src="<?php echo e(asset('vendor/select2/js/select2.full.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/plugins-init/select2-init.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/chart.js/Chart.bundle.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/dashboard/statistics.js')); ?>"></script>

    <script src="<?php echo e(asset('vendor/jquery-steps/build/jquery.steps.min.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/jquery-validation/jquery.validate.min.js')); ?>"></script>
    <script src="<?php echo e(asset('js/plugins-init/jquery.validate-init.js')); ?>"></script>
   <script src="<?php echo e(asset('vendor/jquery-smartwizard/dist/js/jquery.smartWizard.js')); ?>"></script>
   
   <script src="<?php echo e(asset('vendor/flot/jquery.flot.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/flot/jquery.flot.pie.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/flot/jquery.flot.resize.js')); ?>"></script>
    <script src="<?php echo e(asset('vendor/flot-spline/jquery.flot.spline.min.js')); ?>"></script>
    
   <script src="<?php echo e(asset('js/plugins-init/flot-init.js')); ?>"></script>

   <script>
      function carouselReview(){
         /*  testimonial one function by = owl.carousel.js') }} */
         jQuery('.testimonial-one').owlCarousel({
            loop:true,
            autoplay:true,
            margin:30,
            nav:false,
            dots: false,
            left:true,
            navText: ['', ''],
            responsive:{
               0:{
                  items:1
               },
               800:{
                  items:1
               }, 
               991:{
                  items:2
               },       
               
               1200:{
                  items:2
               },
               1600:{
                  items:3
               }
            }
         })       
      }
      jQuery(window).on('load',function(){
         setTimeout(function(){
            carouselReview();
         }, 1000); 
      });
   </script>

   <script>
        <?php if(Session::has('info_error')): ?>
            toastr.error("<?php echo e(Session::get('info_error')); ?>", "MESSAGE D'ERREUR")
        <?php endif; ?>

        <?php if(Session::has('error')): ?>
            toastr.error("<?php echo e(Session::get('error')); ?>", "MESSAGE D'ERREUR")
        <?php endif; ?>

        <?php if(Session::has('success')): ?>
            toastr.success("<?php echo e(Session::get('success')); ?>", "MESSAGE")
        <?php endif; ?>

        <?php if(Session::has('info_warning')): ?>
            toastr.warning("<?php echo e(Session::get('info_warning')); ?>", "MESSAGE D'ERREUR")
        <?php endif; ?>

        <?php if(Session::has('info_erreur')): ?>
            toastr.error("<?php echo e(Session::get('info_erreur')); ?>", "MESSAGE D'ERREUR")
        <?php endif; ?>

        <?php if(Session::has('erreur')): ?>
            toastr.error("<?php echo e(Session::get('erreur')); ?>", "MESSAGE D'ERREUR")
        <?php endif; ?>


        <?php if(Session::has('info_succes')): ?>
            toastr.success("<?php echo e(Session::get('info_succes')); ?>", "MESSAGE")
        <?php endif; ?>

        <?php if(Session::has('session_expired')): ?>
            toastr.primary("<?php echo e(Session::get('session_expired')); ?>", "CONNEXION EXPIREE")
        <?php endif; ?>

        <?php if($errors->any()): ?>
            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                toastr.error("<?php echo e($error); ?>", "MESSAGE D'ERREUR")
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
    </script>

    <script>
      /* Description */
       $('#summernote').summernote({
           height: 300,
           toolbar: [
               ['insert', ['picture', 'link', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });

       /* Mission */
       $('#exampleMission').summernote({
           height: 300,
           toolbar: [
               ['insert', ['picture', 'link', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });


       /* Profil */
       $('#OffreProfil').summernote({
           height: 300,
           toolbar: [
               ['insert', ['picture', 'link', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });

       /* Composition du dossier */
       $('#CompositionDossier').summernote({
           height: 300,
           toolbar: [
               ['insert', ['picture', 'link', 'video', 'table', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });

       /* Autre information */
       $('#AutreInfo').summernote({
           height: 300,
           toolbar: [
               ['insert', ['picture', 'link', 'video', 'table', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });

       /* Témoignage */
       $('#temoignage').summernote({
           height: 300,
           toolbar: [
               ['insert', ['picture', 'link', 'video', 'table', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });

       /* Description entreprise employeur */
       $('#DescriptionEmployeur').summernote({
           height: 200,
           toolbar: [
               ['insert', ['picture', 'link', 'video', 'table', 'hr', 'summernoteGallery']],
               ['font style', ['fontname', 'fontsize', 'color', 'bold', 'italic',
               'underline', 'strikethrough', 'superscript', 'subscript', 'clear']],
               ['paragraph style', ['style', 'ol', 'ul', 'paragraph', 'height']],
               ['misc', ['fullscreen', 'codeview', 'undo', 'redo', 'help']]
               ['extensions', ['summernoteGallery']],
           ],
           summernoteGallery: {
               source: {
                   // data: data,
                   url: location.origin+location.pathname+'/server/example.json',
                   responseDataKey: 'data',
                   nextPageKey: 'links.next',
               },
               modal: {
                   loadOnScroll: true,
                   noImageSelected_msg: 'No image was selected, please select one by clicking it!',
               },
               buttonLabel: '<i class="fa fa-file-image-o"></i> SN Gallery'
           }
       });
   </script>
</body>

</html><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anpe-app/resources/views/layouts/appp.blade.php ENDPATH**/ ?>