<?php
    use Carbon\Carbon;
?>


<?php $__env->startSection('title'); ?>
    Statistiques mensuelles
<?php $__env->stopSection(); ?>

<?php $__env->startSection('titre'); ?>
    Statistiques mensuelles
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <script src="<?php echo e(asset('js/chart.js')); ?>"></script>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Statistiques</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Statistiques mensuelles</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Suivi des comptes par mois</h4>
                        <div class="float-end">
                            <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")): ?> 
                                <?php if($data_employeur > 0 or $data_employeurbroui > 0): ?>                                                          
                                    <a class="badge badge-primary employeur" href="<?php echo e(route('admin.excel-statistiques.mensuelles-emp')); ?>">Employeurs</a>
                                <?php endif; ?>
                                <?php if($data_users > 0 or $data_user_brouillons > 0): ?>
                                    <a class="badge badge-success" href="<?php echo e(route('admin.excel-statistiques.mensuelles-demp')); ?>">Demandeurs d'emploi</a> 
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body pb-0"> 
                        <canvas id="myChart"></canvas>
                    </div>
                </div><br>
            </div>
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Suivi des offres d'emploi par mois</h4>
                        <div class="float-end">
                            <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")): ?>  
                                <?php if($data_offrespubliees > 0): ?>                                                         
                                    <a class="badge badge-success" href="<?php echo e(route('admin.excel-statistiques.mensuelles-offrepub')); ?>">Offres publiées</a>
                                <?php endif; ?>
                                <?php if($data_offresbrouillon > 0): ?>
                                    <a class="badge badge-danger" href="<?php echo e(route('admin.excel-statistiques.mensuelles-offrebroui')); ?>">Offres brouillons</a> 
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <canvas id="chart_offre"></canvas>
                    </div>
                </div><br>
            </div>
        </div>
    </div>
    <script>
        var ctx = document.getElementById('myChart').getContext('2d');
        var myChart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Janv', 'Févr', 'Mars', 'Avr', 'Mai', 'Juin', 'Juill', 'Août', 'Sept', 'Oct', 'Nov', 'Déc'],
                datasets: [{
                    label: 'Demandeurs d\'emploi traités',
                    data: <?php echo json_encode($data_users, 15, 512) ?>,
                    fill: false,
                    backgroundColor: 'rgba(1, 153, 0)',
                    borderColor: 'rgba(1, 153, 0)',
                    borderWidth: 1
                }, {
                    label: 'Demandeurs d\'emploi non traités',
                    data: <?php echo json_encode($data_user_brouillons, 15, 512) ?>,
                    fill: false,
                    backgroundColor: 'rgb(249, 57, 57)',
                    borderColor: 'rgb(249, 57, 57)',
                    borderWidth: 1
                }, {
                    label: 'Employeurs traités',
                    data: <?php echo json_encode($data_employeur, 15, 512) ?>,
                    fill: false,
                    backgroundColor: '#3d09ff',
                    borderColor: '#3d09ff',
                    borderWidth: 1
                }, {
                    label: 'Employeurs non traités',
                    data: <?php echo json_encode($data_employeurbroui, 15, 512) ?>,
                    fill: false,
                    backgroundColor: '#630a01',
                    borderColor: '#630a01',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            stepSize: 10
                        }
                    }]
                }
            }
        });
    </script>
    <script>
        var ctx = document.getElementById('chart_offre').getContext('2d');
        var chart_offre = new Chart(ctx, {
            type: 'line',
            data: {
                labels: ['Janv', 'Févr', 'Mars', 'Avr', 'Mai', 'Juin', 'Juill', 'Août', 'Sept', 'Oct', 'Nov', 'Déc'],
                datasets: [{
                    label: 'Offres publiées',
                    data: <?php echo json_encode($data_offrespubliees, 15, 512) ?>,
                    fill: false,
                    backgroundColor: 'rgba(1, 153, 0)',
                    borderColor: 'rgba(1, 153, 0)',
                    borderWidth: 1
                }, {
                    label: 'Offres non publiées',
                    data: <?php echo json_encode($data_offresbrouillon, 15, 512) ?>,
                    fill: false,
                    backgroundColor: 'rgb(249, 57, 57)',
                    borderColor: 'rgb(249, 57, 57)',
                    borderWidth: 1
                }]
            },
            options: {
                scales: {
                    yAxes: [{
                        ticks: {
                            beginAtZero: true,
                            stepSize: 10
                        }
                    }]
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.appp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anpe-app/resources/views/admin/statistique/statistiquemensuelle.blade.php ENDPATH**/ ?>