

<?php $__env->startSection('title'); ?>
    Statistiques annuelles
<?php $__env->stopSection(); ?>

<?php $__env->startSection('titre'); ?>
    Statistiques annuelles
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <script src="<?php echo e(asset('js/chart.js')); ?>"></script>
    <div class="container-fluid">
        <div class="page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="javascript:void(0)">Statistiques</a></li>
                <li class="breadcrumb-item active"><a href="javascript:void(0)">Statistiques annuelles</a></li>
            </ol>
        </div>
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Suivi des comptes par années</h5>
                        <div class="float-end">
                            <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")): ?>                                                           
                                <a class="badge badge-primary employeur" href="<?php echo e(route('admin.excel-statistiques.annuelles-emp')); ?>">Employeurs</a>
                                <a class="badge badge-success" href="<?php echo e(route('admin.excel-statistiques.annuelles-demp')); ?>">Demandeurs d'emploi</a> 
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <canvas id="graphique"></canvas>
                    </div>
                </div><br>
            </div>
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <h5 class="card-title">Suivi des offres d'emploi par année</h5>
                        <div class="float-end">
                            <?php if(Stdfn::isActionAutorisee(Auth::user()->id, "ADM_TOUT") or Stdfn::isActionAutorisee(Auth::user()->id, "EXPORT_START")): ?>                                                           
                                <a class="badge badge-success" href="<?php echo e(route('admin.excel-statistiques.annuelles-offrepub')); ?>">Offres publiées</a>
                                <a class="badge badge-danger" href="<?php echo e(route('admin.excel-statistiques.annuelles-offrebroui')); ?>">Offres brouillons</a> 
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="card-body pb-0">
                        <canvas id="graphiqueoffre"></canvas>
                    </div>
                </div><br>
            </div>
        </div>
    </div>
    <script>
        var ctx = document.getElementById('graphique').getContext('2d');
        var chart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($annees); ?>,
                datasets: [
                    {
                        label: 'Employeurs Brouillon',
                        data: <?php echo json_encode($employeursBrouillon); ?>,
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1,
                        fill: true
                    },
                    {
                        label: 'Employeurs Valide',
                        data: <?php echo json_encode($employeursValide); ?>,
                        backgroundColor: 'rgba(255, 99, 132, 0.2)',
                        borderColor: 'rgba(255, 99, 132, 1)',
                        borderWidth: 1,
                        fill: true
                    },
                    {
                        label: 'Demandeurs d\'emploi Brouillon',
                        data: <?php echo json_encode($demandeursBrouillon); ?>,
                        backgroundColor: 'rgba(54, 162, 235, 0.2)',
                        borderColor: 'rgba(54, 162, 235, 1)',
                        borderWidth: 1,
                        fill: true
                    },
                    {
                        label: 'Demandeurs d\'emploi Valide',
                        data: <?php echo json_encode($demandeursValide); ?>,
                        backgroundColor: 'rgba(255, 206, 86, 0.2)',
                        borderColor: 'rgba(255, 206, 86, 1)',
                        borderWidth: 1,
                        fill: true
                    }
                ]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
    <script>
        var ctx = document.getElementById('graphiqueoffre').getContext('2d');
        var chart = new Chart(ctx, {
            type: 'line',
            data: {
                labels: <?php echo json_encode($annees); ?>,
                datasets: [
                    {
                        label: 'Offres Brouillon',
                        data: <?php echo json_encode($offreBrouillon); ?>,
                        backgroundColor: 'rgba(75, 192, 192, 0.2)',
                        borderColor: 'rgba(75, 192, 192, 1)',
                        borderWidth: 1,
                        fill: true
                    },
                    {
                        label: 'Offres Valide',
                        data: <?php echo json_encode($offreValide); ?>,
                        backgroundColor: 'rgba(255, 206, 86, 0.2)',
                        borderColor: 'rgba(255, 206, 86, 1)',
                        borderWidth: 1,
                        fill: true
                    }
                ]
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.appp', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/anpe-app/resources/views/admin/statistique/statistique.blade.php ENDPATH**/ ?>